/*
 * Decompiled with CFR 0.152.
 */
package azkaban.user;

import azkaban.user.Permission;
import azkaban.user.Role;
import azkaban.user.User;
import azkaban.user.UserManager;
import azkaban.user.UserManagerException;
import azkaban.utils.Props;
import com.webank.wedatasphere.schedulis.common.utils.XmlResolveUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlUserManager
implements UserManager {
    private static final Logger logger = LoggerFactory.getLogger(XmlUserManager.class);
    public static final String XML_FILE_PARAM = "user.manager.xml.file";
    public static final String AZKABAN_USERS_TAG = "azkaban-users";
    public static final String USER_TAG = "user";
    public static final String ROLE_TAG = "role";
    public static final String GROUP_TAG = "group";
    public static final String ROLENAME_ATTR = "name";
    public static final String ROLEPERMISSIONS_ATTR = "permissions";
    public static final String USERNAME_ATTR = "username";
    public static final String PASSWORD_ATTR = "password";
    public static final String EMAIL_ATTR = "email";
    public static final String ROLES_ATTR = "roles";
    public static final String PROXY_ATTR = "proxy";
    public static final String GROUPS_ATTR = "groups";
    public static final String GROUPNAME_ATTR = "name";
    private final String xmlPath;
    private HashMap<String, User> users;
    private HashMap<String, String> userPassword;
    private HashMap<String, Role> roles;
    private HashMap<String, Set<String>> groupRoles;
    private HashMap<String, Set<String>> proxyUserMap;

    public XmlUserManager(Props props) {
        this.xmlPath = props.getString(XML_FILE_PARAM);
        this.parseXMLFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseXMLFile() {
        File file = new File(this.xmlPath);
        if (!file.exists()) {
            throw new IllegalArgumentException("User xml file " + this.xmlPath + " doesn't exist.");
        }
        HashMap<String, User> users = new HashMap<String, User>();
        HashMap<String, String> userPassword = new HashMap<String, String>();
        HashMap<String, Role> roles = new HashMap<String, Role>();
        HashMap<String, Set<String>> groupRoles = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> proxyUserMap = new HashMap<String, Set<String>>();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            XmlResolveUtils.avoidXEE(docBuilderFactory);
            builder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalArgumentException("Exception while parsing user xml. Document builder not created.", e);
        }
        Document doc = null;
        try {
            doc = builder.parse(file);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException("Exception while parsing " + this.xmlPath + ". Invalid XML.", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Exception while parsing " + this.xmlPath + ". Error reading file.", e);
        }
        NodeList tagList = doc.getChildNodes();
        Node azkabanUsers = tagList.item(0);
        NodeList azkabanUsersList = azkabanUsers.getChildNodes();
        for (int i = 0; i < azkabanUsersList.getLength(); ++i) {
            Node node = azkabanUsersList.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals(USER_TAG)) {
                this.parseUserTag(node, users, userPassword, proxyUserMap);
                continue;
            }
            if (node.getNodeName().equals(ROLE_TAG)) {
                this.parseRoleTag(node, roles);
                continue;
            }
            if (!node.getNodeName().equals(GROUP_TAG)) continue;
            this.parseGroupRoleTag(node, groupRoles);
        }
        XmlUserManager xmlUserManager = this;
        synchronized (xmlUserManager) {
            this.users = users;
            this.userPassword = userPassword;
            this.roles = roles;
            this.proxyUserMap = proxyUserMap;
            this.groupRoles = groupRoles;
        }
    }

    private void parseUserTag(Node node, HashMap<String, User> users, HashMap<String, String> userPassword, HashMap<String, Set<String>> proxyUserMap) {
        Node emailAttr;
        Node groups;
        Node proxy;
        NamedNodeMap userAttrMap = node.getAttributes();
        Node userNameAttr = userAttrMap.getNamedItem(USERNAME_ATTR);
        if (userNameAttr == null) {
            throw new RuntimeException("Error loading user. The 'username' attribute doesn't exist");
        }
        Node passwordAttr = userAttrMap.getNamedItem(PASSWORD_ATTR);
        if (passwordAttr == null) {
            throw new RuntimeException("Error loading user. The 'password' attribute doesn't exist");
        }
        String username = userNameAttr.getNodeValue();
        String password = passwordAttr.getNodeValue();
        userPassword.put(username, password);
        User user = new User(userNameAttr.getNodeValue());
        users.put(username, user);
        logger.info("Loading user " + user.getUserId());
        Node roles = userAttrMap.getNamedItem(ROLES_ATTR);
        if (roles != null) {
            String[] roleSplit;
            String value = roles.getNodeValue();
            for (String role : roleSplit = value.split("\\s*,\\s*")) {
                user.addRole(role);
            }
        }
        if ((proxy = userAttrMap.getNamedItem(PROXY_ATTR)) != null) {
            String[] proxySplit;
            String value = proxy.getNodeValue();
            for (String proxyUser : proxySplit = value.split("\\s*,\\s*")) {
                Set<String> proxySet = proxyUserMap.get(username);
                if (proxySet == null) {
                    proxySet = new HashSet<String>();
                    proxyUserMap.put(username, proxySet);
                }
                proxySet.add(proxyUser);
            }
        }
        if ((groups = userAttrMap.getNamedItem(GROUPS_ATTR)) != null) {
            String[] groupSplit;
            String value = groups.getNodeValue();
            for (String group : groupSplit = value.split("\\s*,\\s*")) {
                user.addGroup(group);
            }
        }
        if ((emailAttr = userAttrMap.getNamedItem(EMAIL_ATTR)) != null) {
            user.setEmail(emailAttr.getNodeValue());
        }
    }

    private void parseRoleTag(Node node, HashMap<String, Role> roles) {
        NamedNodeMap roleAttrMap = node.getAttributes();
        Node roleNameAttr = roleAttrMap.getNamedItem("name");
        if (roleNameAttr == null) {
            throw new RuntimeException("Error loading role. The role 'name' attribute doesn't exist");
        }
        Node permissionAttr = roleAttrMap.getNamedItem(ROLEPERMISSIONS_ATTR);
        if (permissionAttr == null) {
            throw new RuntimeException("Error loading role. The role 'permissions' attribute doesn't exist");
        }
        String roleName = roleNameAttr.getNodeValue();
        String permissions = permissionAttr.getNodeValue();
        String[] permissionSplit = permissions.split("\\s*,\\s*");
        Permission perm = new Permission();
        for (String permString : permissionSplit) {
            try {
                Permission.Type type = Permission.Type.valueOf(permString);
                perm.addPermission(type);
            }
            catch (IllegalArgumentException e) {
                logger.error("Error adding type " + permString + ". Permission doesn't exist.", (Throwable)e);
            }
        }
        Role role = new Role(roleName, perm);
        roles.put(roleName, role);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User getUser(String username, String password) throws UserManagerException {
        if (username == null || username.trim().isEmpty()) {
            throw new UserManagerException("Empty User Name.");
        }
        if (password == null || password.trim().isEmpty()) {
            throw new UserManagerException("Empty Password.");
        }
        String foundPassword = null;
        User user = null;
        XmlUserManager xmlUserManager = this;
        synchronized (xmlUserManager) {
            foundPassword = this.userPassword.get(username);
            if (foundPassword != null) {
                user = this.users.get(username);
            }
        }
        if (foundPassword == null || !foundPassword.equals(password)) {
            throw new UserManagerException("Username/Password not found.");
        }
        if (user == null) {
            throw new UserManagerException("Internal error: User not found.");
        }
        this.resolveGroupRoles(user);
        user.setPermissions(new User.UserPermissions(){

            @Override
            public boolean hasPermission(String permission) {
                return true;
            }

            @Override
            public void addPermission(String permission) {
            }
        });
        return user;
    }

    private void resolveGroupRoles(User user) {
        for (String group : user.getGroups()) {
            Set<String> groupRoleSet = this.groupRoles.get(group);
            if (groupRoleSet == null) continue;
            for (String role : groupRoleSet) {
                user.addRole(role);
            }
        }
    }

    private void parseGroupRoleTag(Node node, HashMap<String, Set<String>> groupRoles) {
        NamedNodeMap groupAttrMap = node.getAttributes();
        Node groupNameAttr = groupAttrMap.getNamedItem("name");
        if (groupNameAttr == null) {
            throw new RuntimeException("Error loading role. The role 'name' attribute doesn't exist");
        }
        String groupName = groupNameAttr.getNodeValue();
        HashSet<String> roleSet = new HashSet<String>();
        Node roles = groupAttrMap.getNamedItem(ROLES_ATTR);
        if (roles != null) {
            String[] roleSplit;
            String value = roles.getNodeValue();
            for (String role : roleSplit = value.split("\\s*,\\s*")) {
                roleSet.add(role);
            }
        }
        groupRoles.put(groupName, roleSet);
        logger.info("Group roles " + groupName + " added.");
    }

    @Override
    public boolean validateUser(String username) {
        return this.users.containsKey(username);
    }

    @Override
    public Role getRole(String roleName) {
        return this.roles.get(roleName);
    }

    @Override
    public boolean validateGroup(String group) {
        return true;
    }

    @Override
    public boolean validateProxyUser(String proxyUser, User realUser) {
        return this.proxyUserMap.containsKey(realUser.getUserId()) && this.proxyUserMap.get(realUser.getUserId()).contains(proxyUser);
    }
}

