/*
 * Decompiled with CFR 0.152.
 */
package azkaban.trigger;

import azkaban.trigger.ConditionChecker;
import azkaban.trigger.TriggerException;
import azkaban.utils.Props;
import azkaban.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckerTypeLoader {
    public static final String DEFAULT_CONDITION_CHECKER_PLUGIN_DIR = "plugins/conditioncheckers";
    private static final Logger logger = LoggerFactory.getLogger(CheckerTypeLoader.class);
    protected static Map<String, Class<? extends ConditionChecker>> checkerToClass = new HashMap<String, Class<? extends ConditionChecker>>();

    public static void registerBuiltinCheckers(Map<String, Class<? extends ConditionChecker>> builtinCheckers) {
        checkerToClass.putAll(checkerToClass);
        for (String type : builtinCheckers.keySet()) {
            logger.info("Loaded " + type + " checker.");
        }
    }

    public void init(Props props) throws TriggerException {
    }

    public synchronized void registerCheckerType(String type, Class<? extends ConditionChecker> checkerClass) {
        logger.info("Registering checker " + type);
        if (!checkerToClass.containsKey(type)) {
            checkerToClass.put(type, checkerClass);
        }
    }

    public ConditionChecker createCheckerFromJson(String type, Object obj) throws Exception {
        ConditionChecker checker = null;
        Class<? extends ConditionChecker> checkerClass = checkerToClass.get(type);
        if (checkerClass == null) {
            throw new Exception("Checker type " + type + " not supported!");
        }
        checker = (ConditionChecker)Utils.invokeStaticMethod((ClassLoader)checkerClass.getClassLoader(), (String)checkerClass.getName(), (String)"createFromJson", (Object[])new Object[]{obj});
        return checker;
    }

    public ConditionChecker createChecker(String type, Object ... args) {
        ConditionChecker checker = null;
        Class<? extends ConditionChecker> checkerClass = checkerToClass.get(type);
        checker = (ConditionChecker)Utils.callConstructor(checkerClass, (Object[])args);
        return checker;
    }

    public Map<String, Class<? extends ConditionChecker>> getSupportedCheckers() {
        return checkerToClass;
    }
}

