/*
 * Decompiled with CFR 0.152.
 */
package azkaban.trigger;

import azkaban.trigger.TriggerAction;
import azkaban.trigger.TriggerException;
import azkaban.utils.Props;
import azkaban.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionTypeLoader {
    public static final String DEFAULT_TRIGGER_ACTION_PLUGIN_DIR = "plugins/triggeractions";
    private static final Logger logger = LoggerFactory.getLogger(ActionTypeLoader.class);
    protected static Map<String, Class<? extends TriggerAction>> actionToClass = new HashMap<String, Class<? extends TriggerAction>>();

    public static void registerBuiltinActions(Map<String, Class<? extends TriggerAction>> builtinActions) {
        actionToClass.putAll(builtinActions);
        for (String type : builtinActions.keySet()) {
            logger.info("Loaded " + type + " action.");
        }
    }

    public void init(Props props) throws TriggerException {
    }

    public synchronized void registerActionType(String type, Class<? extends TriggerAction> actionClass) {
        logger.info("Registering action " + type);
        if (!actionToClass.containsKey(type)) {
            actionToClass.put(type, actionClass);
        }
    }

    public TriggerAction createActionFromJson(String type, Object obj) throws Exception {
        TriggerAction action = null;
        Class<? extends TriggerAction> actionClass = actionToClass.get(type);
        if (actionClass == null) {
            throw new Exception("Action Type " + type + " not supported!");
        }
        action = (TriggerAction)Utils.invokeStaticMethod((ClassLoader)actionClass.getClassLoader(), (String)actionClass.getName(), (String)"createFromJson", (Object[])new Object[]{obj});
        return action;
    }

    public TriggerAction createAction(String type, Object ... args) {
        TriggerAction action = null;
        Class<? extends TriggerAction> actionClass = actionToClass.get(type);
        action = (TriggerAction)Utils.callConstructor(actionClass, (Object[])args);
        return action;
    }

    public Set<String> getSupportedActions() {
        return actionToClass.keySet();
    }
}

