/*
 * Decompiled with CFR 0.152.
 */
package azkaban.storage;

import azkaban.spi.Storage;
import azkaban.storage.DatabaseStorage;
import azkaban.storage.HdfsStorage;
import azkaban.storage.LocalStorage;

public enum StorageImplementationType {
    LOCAL(LocalStorage.class),
    HDFS(HdfsStorage.class),
    DATABASE(DatabaseStorage.class);

    private final Class<? extends Storage> implementationClass;

    private StorageImplementationType(Class<? extends Storage> implementationClass) {
        this.implementationClass = implementationClass;
    }

    public static StorageImplementationType from(String name) {
        try {
            return StorageImplementationType.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Class<? extends Storage> getImplementationClass() {
        return this.implementationClass;
    }
}

