/*
 * Decompiled with CFR 0.152.
 */
package azkaban.storage;

import azkaban.AzkabanCommonModuleConfig;
import azkaban.spi.Storage;
import azkaban.spi.StorageException;
import azkaban.spi.StorageMetadata;
import azkaban.storage.HdfsAuth;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HdfsStorage
implements Storage {
    private static final Logger logger = LoggerFactory.getLogger(HdfsStorage.class);
    private static final String HDFS_SCHEME = "hdfs";
    private final HdfsAuth hdfsAuth;
    private final URI rootUri;
    private final FileSystem hdfs;

    @Inject
    public HdfsStorage(HdfsAuth hdfsAuth, FileSystem hdfs, AzkabanCommonModuleConfig config) {
        this.hdfsAuth = Objects.requireNonNull(hdfsAuth);
        this.hdfs = Objects.requireNonNull(hdfs);
        this.rootUri = config.getHdfsRootUri();
        Objects.requireNonNull(this.rootUri.getAuthority(), "URI must have host:port mentioned.");
        Preconditions.checkArgument((boolean)HDFS_SCHEME.equals(this.rootUri.getScheme()));
    }

    public InputStream get(String key) throws IOException {
        this.hdfsAuth.authorize();
        return this.hdfs.open(this.fullPath(key));
    }

    public String put(StorageMetadata metadata, File localFile) {
        this.hdfsAuth.authorize();
        Path projectsPath = new Path(this.rootUri.getPath(), String.valueOf(metadata.getProjectId()));
        try {
            Path targetPath;
            if (this.hdfs.mkdirs(projectsPath)) {
                logger.info("Created project dir: " + projectsPath);
            }
            if (this.hdfs.exists(targetPath = this.createTargetPath(metadata, projectsPath))) {
                logger.info(String.format("Duplicate Found: meta: %s path: %s", metadata, targetPath));
                return this.getRelativePath(targetPath);
            }
            logger.info(String.format("Creating project artifact: meta: %s path: %s", metadata, targetPath));
            this.hdfs.copyFromLocalFile(new Path(localFile.getAbsolutePath()), targetPath);
            return this.getRelativePath(targetPath);
        }
        catch (IOException e) {
            logger.error("error in put(): Metadata: " + metadata);
            throw new StorageException((Throwable)e);
        }
    }

    private String getRelativePath(Path targetPath) {
        return URI.create(this.rootUri.getPath()).relativize(targetPath.toUri()).getPath();
    }

    private Path createTargetPath(StorageMetadata metadata, Path projectsPath) {
        return new Path(projectsPath, String.format("%s-%s.zip", String.valueOf(metadata.getProjectId()), new String(Hex.encodeHex((byte[])metadata.getHash()))));
    }

    public boolean delete(String key) {
        this.hdfsAuth.authorize();
        Path path = this.fullPath(key);
        try {
            return this.hdfs.delete(path, false);
        }
        catch (IOException e) {
            logger.error("HDFS delete failed on " + path, (Throwable)e);
            return false;
        }
    }

    private Path fullPath(String key) {
        return new Path(this.rootUri.toString(), key);
    }
}

