/*
 * Decompiled with CFR 0.152.
 */
package azkaban.storage;

import azkaban.spi.AzkabanException;
import azkaban.utils.Props;
import java.io.IOException;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HdfsAuth {
    private static final Logger logger = LoggerFactory.getLogger(HdfsAuth.class);
    private final boolean isSecurityEnabled;
    private UserGroupInformation loggedInUser = null;
    private String keytabPath = null;
    private String keytabPrincipal = null;

    @Inject
    public HdfsAuth(Props props, Configuration conf) {
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.isSecurityEnabled = UserGroupInformation.isSecurityEnabled();
        if (this.isSecurityEnabled) {
            logger.info("The Hadoop cluster has enabled security");
            this.keytabPath = Objects.requireNonNull(props.getString("azkaban.keytab.path"));
            this.keytabPrincipal = Objects.requireNonNull(props.getString("azkaban.kerberos.principal"));
        }
    }

    public void authorize() {
        if (this.isSecurityEnabled) {
            try {
                this.login(this.keytabPrincipal, this.keytabPath);
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
                throw new AzkabanException(String.format("Error: Unable to authorize to Hadoop. Principal: %s Keytab: %s", this.keytabPrincipal, this.keytabPath));
            }
        }
    }

    private void login(String keytabPrincipal, String keytabPath) throws IOException {
        if (this.loggedInUser == null) {
            logger.info(String.format("Logging in using Principal: %s Keytab: %s", keytabPrincipal, keytabPath));
            UserGroupInformation.loginUserFromKeytab((String)keytabPrincipal, (String)keytabPath);
            this.loggedInUser = UserGroupInformation.getLoginUser();
            logger.info(String.format("User %s logged in.", this.loggedInUser));
        } else {
            logger.info(String.format("User %s already logged in. Refreshing TGT", this.loggedInUser));
            this.loggedInUser.checkTGTAndReloginFromKeytab();
        }
    }
}

