/*
 * Decompiled with CFR 0.152.
 */
package azkaban.sla;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableNode;
import azkaban.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class SlaOption {
    public static final String TYPE_FLOW_FINISH = "FlowFinish";
    public static final String TYPE_FLOW_SUCCEED = "FlowSucceed";
    public static final String TYPE_JOB_FINISH = "JobFinish";
    public static final String TYPE_JOB_SUCCEED = "JobSucceed";
    public static final String TYPE_FLOW_FAILURE_EMAILS = "FlowFailureEmails";
    public static final String TYPE_FLOW_SUCCESS_EMAILS = "FlowSuccessEmails";
    public static final String TYPE_FLOW_FINISH_EMAILS = "FlowFinishEmails";
    public static final String TYPE_JOB_FAILURE_EMAILS = "JobFailureEmails";
    public static final String TYPE_JOB_SUCCESS_EMAILS = "JobSuccessEmails";
    public static final String TYPE_JOB_FINISH_EMAILS = "JobFinishEmails";
    public static final String INFO_TIME_SET = "TimeSet";
    public static final String INFO_EMAIL_ACTION_SET = "email_action_set";
    public static final String INFO_KILL_FLOW_ACTION_SET = "kill_flow_action_set";
    public static final String INFO_DURATION = "Duration";
    public static final String INFO_FLOW_NAME = "FlowName";
    public static final String INFO_JOB_NAME = "JobName";
    public static final String INFO_EMAIL_LIST = "EmailList";
    public static final String INFO_DEP_TYPE_INFORM = "depTypeInform";
    public static final String INFO_ALERT_LEVEL = "AlertLevel";
    public static final String ALERT_TYPE = "SlaAlertType";
    public static final String ACTION_CANCEL_FLOW = "SlaCancelFlow";
    public static final String ACTION_ALERT = "SlaAlert";
    public static final String ACTION_KILL_JOB = "SlaKillJob";
    private static final DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"YYYY-MM-dd HH:mm:ss");
    private String type;
    private Map<String, Object> info;
    private List<String> actions;
    private String level;
    private String timeSet;
    private String emailAction;
    private String killAction;
    public static final String INFO_EMBEDDED_ID = "embeddedId";

    public SlaOption(String type, List<String> actions, Map<String, Object> info, String level) {
        this.type = type;
        this.info = info;
        this.actions = actions;
        this.level = level;
    }

    public static List<SlaOption> getJobLevelSLAOptions(ExecutableFlow flow) {
        HashSet<String> jobLevelSLAs = new HashSet<String>(Arrays.asList(TYPE_JOB_FINISH, TYPE_JOB_SUCCEED));
        return flow.getSlaOptions().stream().filter(slaOption -> jobLevelSLAs.contains(slaOption.getType())).collect(Collectors.toList());
    }

    public static List<SlaOption> getFlowLevelSLAOptions(ExecutableFlow flow) {
        HashSet<String> flowLevelSLAs = new HashSet<String>(Arrays.asList(TYPE_FLOW_FINISH, TYPE_FLOW_SUCCEED));
        return flow.getSlaOptions().stream().filter(slaOption -> flowLevelSLAs.contains(slaOption.getType())).collect(Collectors.toList());
    }

    public static SlaOption fromObject(Object object) {
        HashMap slaObj = (HashMap)object;
        String type = (String)slaObj.get("type");
        List actions = (List)slaObj.get("actions");
        Map info = (Map)slaObj.get("info");
        String level = (String)slaObj.get("level");
        return new SlaOption(type, actions, info, level);
    }

    public static String createSlaMessage(SlaOption slaOption, ExecutableFlow flow) {
        String type = slaOption.getType();
        int execId = flow.getExecutionId();
        if (type.equals(TYPE_FLOW_FINISH)) {
            String flowName = (String)slaOption.getInfo().get(INFO_FLOW_NAME);
            String duration = (String)slaOption.getInfo().get(INFO_DURATION);
            String basicinfo = "SLA \u544a\u8b66: Your flow " + flowName + " failed to FINISH within " + duration + "#br";
            String expected = "\u8be6\u7ec6\u4fe1\u606f : #brFlow " + flowName + "#br\u6267\u884cID: " + execId + "#br\u9884\u8ba1\u8d85\u65f6\u65f6\u95f4: " + duration + "#br\u5f00\u59cb\u65f6\u95f4: " + fmt.print((ReadableInstant)new DateTime(flow.getStartTime())) + "#br\u7ed3\u675f\u65f6\u95f4: " + fmt.print((ReadableInstant)new DateTime(flow.getEndTime())) + "#br";
            String actual = "Flow \u73b0\u5728\u7684\u72b6\u6001\u662f " + (Object)((Object)flow.getStatus());
            return basicinfo + expected + actual;
        }
        if (type.equals(TYPE_FLOW_SUCCEED)) {
            String flowName = (String)slaOption.getInfo().get(INFO_FLOW_NAME);
            String duration = (String)slaOption.getInfo().get(INFO_DURATION);
            String basicinfo = "SLA \u544a\u8b66: Your flow " + flowName + " failed to SUCCEED within " + duration + "#br";
            String expected = "\u8be6\u7ec6\u4fe1\u606f : #brFlow " + flowName + "#br\u6267\u884cID: " + execId + "#br\u9884\u8ba1\u8d85\u65f6\u65f6\u95f4: " + duration + "#br\u5f00\u59cb\u65f6\u95f4: " + fmt.print((ReadableInstant)new DateTime(flow.getStartTime())) + "#br\u7ed3\u675f\u65f6\u95f4: " + fmt.print((ReadableInstant)new DateTime(flow.getEndTime())) + "#br";
            String actual = "Flow \u73b0\u5728\u7684\u72b6\u6001\u662f " + (Object)((Object)flow.getStatus());
            return basicinfo + expected + actual;
        }
        if (type.equals(TYPE_JOB_FINISH)) {
            String jobName = (String)slaOption.getInfo().get(INFO_JOB_NAME);
            String duration = (String)slaOption.getInfo().get(INFO_DURATION);
            ExecutableNode job = flow.getExecutableNode(jobName);
            String basicinfo = "SLA \u544a\u8b66: Your job " + jobName + " failed to FINISH within " + duration + "#br";
            String expected = "\u8be6\u7ec6\u4fe1\u606f : #brJob " + jobName + "#br\u9884\u8ba1\u8d85\u65f6\u65f6\u95f4: " + duration + "#br\u5f00\u59cb\u65f6\u95f4: " + fmt.print((ReadableInstant)new DateTime(job.getStartTime())) + "#br\u7ed3\u675f\u65f6\u95f4: " + fmt.print((ReadableInstant)new DateTime(job.getEndTime())) + "#br";
            String actual = "Job \u73b0\u5728\u7684\u72b6\u6001\u662f " + (Object)((Object)job.getStatus());
            return basicinfo + expected + actual;
        }
        if (type.equals(TYPE_JOB_SUCCEED)) {
            String jobName = (String)slaOption.getInfo().get(INFO_JOB_NAME);
            String duration = (String)slaOption.getInfo().get(INFO_DURATION);
            ExecutableNode job = flow.getExecutableNode(jobName);
            String basicinfo = "SLA \u544a\u8b66: Your job " + jobName + " failed to SUCCEED within " + duration + "#br";
            String expected = "\u8be6\u7ec6\u4fe1\u606f : #brJob " + jobName + "#br\u9884\u8ba1\u8d85\u65f6\u65f6\u95f4: " + duration + "#br\u5f00\u59cb\u65f6\u95f4: " + fmt.print((ReadableInstant)new DateTime(job.getStartTime())) + "#br\u7ed3\u675f\u65f6\u95f4: " + fmt.print((ReadableInstant)new DateTime(job.getEndTime())) + "#br";
            String actual = "Job \u73b0\u5728\u7684\u72b6\u6001\u662f " + (Object)((Object)job.getStatus());
            return basicinfo + expected + actual;
        }
        return "Unrecognized SLA type " + type;
    }

    public static String createFinishSlaMessage(SlaOption slaOption, ExecutableFlow flow) {
        String type = slaOption.getType();
        if (type.equals(TYPE_FLOW_SUCCESS_EMAILS)) {
            return SlaOption.buildSlaMessageText(flow, slaOption, "Flow", "SUCCESS");
        }
        if (type.equals(TYPE_FLOW_FAILURE_EMAILS)) {
            return SlaOption.buildSlaMessageText(flow, slaOption, "Flow", "FAILURE");
        }
        if (type.equals(TYPE_FLOW_FINISH_EMAILS)) {
            return SlaOption.buildSlaMessageText(flow, slaOption, "Flow", "FINISH");
        }
        if (type.equals(TYPE_JOB_SUCCESS_EMAILS)) {
            return SlaOption.buildSlaMessageText(flow, slaOption, "Job", "SUCCESS");
        }
        if (type.equals(TYPE_JOB_FAILURE_EMAILS)) {
            return SlaOption.buildSlaMessageText(flow, slaOption, "Job", "FAILURE");
        }
        if (type.equals(TYPE_JOB_FINISH_EMAILS)) {
            return SlaOption.buildSlaMessageText(flow, slaOption, "Job", "FINISH");
        }
        return "Unrecognized SLA type " + type;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map<String, Object> getInfo() {
        return this.info;
    }

    public void setInfo(Map<String, Object> info) {
        this.info = info;
    }

    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(List<String> actions) {
        this.actions = actions;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getTimeSet() {
        return this.timeSet;
    }

    public void setTimeSet(String timeSet) {
        this.timeSet = timeSet;
    }

    public String getEmailAction() {
        return this.emailAction;
    }

    public void setEmailAction(String emailAction) {
        this.emailAction = emailAction;
    }

    public String getKillAction() {
        return this.killAction;
    }

    public void setKillAction(String killAction) {
        this.killAction = killAction;
    }

    public Map<String, Object> toObject() {
        HashMap<String, Object> slaObj = new HashMap<String, Object>();
        slaObj.put("type", this.type);
        slaObj.put("info", this.info);
        slaObj.put("actions", this.actions);
        slaObj.put("level", this.level);
        return slaObj;
    }

    public Object toWebObject() {
        HashMap<String, Object> slaObj = new HashMap<String, Object>();
        if (this.type.equals(TYPE_FLOW_FINISH) || this.type.equals(TYPE_FLOW_SUCCEED)) {
            slaObj.put("id", "");
        } else {
            slaObj.put("id", this.info.get(INFO_JOB_NAME));
            slaObj.put(INFO_EMBEDDED_ID, null != this.info.get(INFO_EMBEDDED_ID) ? this.info.get(INFO_EMBEDDED_ID) : "");
        }
        slaObj.put("duration", this.info.get(INFO_DURATION));
        if (this.type.equals(TYPE_FLOW_FINISH) || this.type.equals(TYPE_JOB_FINISH)) {
            slaObj.put("rule", "FINISH");
        } else if (this.type.equals(TYPE_FLOW_SUCCEED) || this.type.equals(TYPE_JOB_SUCCEED)) {
            slaObj.put("rule", "SUCCESS");
        } else if (this.type.equals(TYPE_FLOW_FAILURE_EMAILS) || this.type.equals(TYPE_JOB_FAILURE_EMAILS)) {
            slaObj.put("rule", "FAILURE EMAILS");
        } else if (this.type.equals(TYPE_FLOW_SUCCESS_EMAILS) || this.type.equals(TYPE_JOB_SUCCESS_EMAILS)) {
            slaObj.put("rule", "SUCCESS EMAILS");
        } else {
            slaObj.put("rule", "FINISH EMAILS");
        }
        ArrayList<String> actionsObj = new ArrayList<String>();
        for (String act : this.actions) {
            if (act.equals(ACTION_ALERT)) {
                actionsObj.add("EMAIL");
                continue;
            }
            actionsObj.add("KILL");
        }
        slaObj.put("actions", actionsObj);
        slaObj.put("level", this.level);
        return slaObj;
    }

    public String toString() {
        return "Sla of " + this.getType() + this.getInfo() + this.getActions();
    }

    private static String buildSlaMessageText(ExecutableFlow flow, SlaOption slaOption, String taskType, String runStatus) {
        int execId = flow.getExecutionId();
        String slaText = "Finish Sla Message Bulid";
        String string = runStatus = "Finish".equals(runStatus) ? "Finish" : runStatus;
        if ("Flow".equals(taskType)) {
            String flowName = (String)slaOption.getInfo().get(INFO_FLOW_NAME);
            String basicInfo = "SLA \u544a\u8b66: Your flow " + flowName + " " + runStatus + " ! #br";
            String expected = "\u8be6\u7ec6\u4fe1\u606f: #brFlow " + flowName + " in execution " + execId + " is expected to FINISH from " + fmt.print((ReadableInstant)new DateTime(flow.getStartTime())) + "#brFlow \u5f00\u59cb\u65f6\u95f4: " + fmt.print((ReadableInstant)new DateTime(flow.getStartTime())) + " \u7ed3\u675f\u65f6\u95f4: " + fmt.print((ReadableInstant)new DateTime(flow.getEndTime())) + ".#brFlow \u6267\u884c\u8017\u65f6\uff1a" + Utils.formatDuration((long)flow.getStartTime(), (long)flow.getEndTime()) + ".#br";
            String actual = "Flow \u73b0\u5728\u7684\u72b6\u6001\u662f: " + runStatus + " !";
            slaText = basicInfo + expected + actual;
        } else {
            String jobName = (String)slaOption.getInfo().get(INFO_JOB_NAME);
            ExecutableNode job = flow.getExecutableNode(jobName);
            String basicInfo = "SLA \u544a\u8b66: Your job " + jobName + " " + runStatus + " in execution " + execId + ".#br";
            String expected = "\u8be6\u7ec6\u4fe1\u606f: #brJob \u5f00\u59cb\u65f6\u95f4: " + fmt.print((ReadableInstant)new DateTime(job.getStartTime())) + " \u7ed3\u675f\u65f6\u95f4: " + fmt.print((ReadableInstant)new DateTime(job.getEndTime())) + ".#brJob \u6267\u884c\u8017\u65f6\uff1a" + Utils.formatDuration((long)job.getStartTime(), (long)job.getEndTime()) + ".#brJob \u5c5e\u4e8e Flow: " + flow.getId() + ".#br";
            String actual = "Job \u73b0\u5728\u7684\u72b6\u6001\u662f: " + runStatus + " !";
            slaText = basicInfo + expected + actual;
        }
        return slaText;
    }
}

