/*
 * Decompiled with CFR 0.152.
 */
package azkaban.server.session;

import azkaban.server.session.Session;
import azkaban.utils.Props;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionCache {
    private static final Logger logger = LoggerFactory.getLogger(SessionCache.class);
    private static final int MAX_NUM_SESSIONS = 10000;
    private static final long DEFAULT_SESSION_TIME_TO_LIVE = 3600000L;
    private final Cache<String, Session> cache;
    private final long effectiveSessionTimeToLive;

    @Inject
    public SessionCache(Props props) {
        this.effectiveSessionTimeToLive = props.getLong("session.time.to.live", 3600000L);
        this.cache = CacheBuilder.newBuilder().maximumSize((long)props.getInt("max.num.sessions", 10000)).expireAfterAccess(this.effectiveSessionTimeToLive, TimeUnit.MILLISECONDS).build();
    }

    public Session getSession(String sessionId) {
        Session elem = (Session)this.cache.getIfPresent((Object)sessionId);
        return elem;
    }

    public long getEffectiveSessionTimeToLive() {
        return this.effectiveSessionTimeToLive;
    }

    public void addSession(Session session) {
        this.cache.put((Object)session.getSessionId(), (Object)session);
    }

    public void removeSession(String id) {
        this.cache.invalidate((Object)id);
    }

    public Cache<String, Session> getCache() {
        return this.cache;
    }

    public Session getSessionByUsername(String username) {
        for (Session session : this.cache.asMap().values()) {
            if (!session.getUser().getUserId().equals(username)) continue;
            return session;
        }
        return null;
    }
}

