/*
 * Decompiled with CFR 0.152.
 */
package azkaban.server;

import azkaban.executor.ExecutionOptions;
import azkaban.executor.ExecutorManagerException;
import azkaban.user.Permission;
import azkaban.user.Role;
import azkaban.user.User;
import azkaban.utils.JSONUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.webank.wedatasphere.schedulis.common.utils.GsonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequestUtils.class);

    public static ExecutionOptions parseFlowOptions(HttpServletRequest req) throws ServletException {
        String disabled;
        String[] emailSplit;
        String emails;
        ExecutionOptions execOptions = new ExecutionOptions();
        if (HttpRequestUtils.hasParam(req, "failureAction")) {
            String option = HttpRequestUtils.getParam(req, "failureAction");
            if (option.equals("finishCurrent")) {
                execOptions.setFailureAction(ExecutionOptions.FailureAction.FINISH_CURRENTLY_RUNNING);
            } else if (option.equals("cancelImmediately")) {
                execOptions.setFailureAction(ExecutionOptions.FailureAction.CANCEL_ALL);
            } else if (option.equals("finishPossible")) {
                execOptions.setFailureAction(ExecutionOptions.FailureAction.FINISH_ALL_POSSIBLE);
            } else if (option.equals("failedPause")) {
                execOptions.setFailureAction(ExecutionOptions.FailureAction.FAILED_PAUSE);
            }
        }
        if (HttpRequestUtils.hasParam(req, "failureEmailsOverride")) {
            boolean override = HttpRequestUtils.getBooleanParam(req, "failureEmailsOverride", false);
            execOptions.setFailureEmailsOverridden(override);
        }
        if (HttpRequestUtils.hasParam(req, "successEmailsOverride")) {
            boolean override = HttpRequestUtils.getBooleanParam(req, "successEmailsOverride", false);
            execOptions.setSuccessEmailsOverridden(override);
        }
        if (HttpRequestUtils.hasParam(req, "failureEmails") && !(emails = HttpRequestUtils.getParam(req, "failureEmails")).isEmpty()) {
            emailSplit = emails.split("\\s*,\\s*|\\s*;\\s*|\\s+");
            execOptions.setFailureEmails(Arrays.asList(emailSplit));
        }
        if (HttpRequestUtils.hasParam(req, "successEmails") && !(emails = HttpRequestUtils.getParam(req, "successEmails")).isEmpty()) {
            emailSplit = emails.split("\\s*,\\s*|\\s*;\\s*|\\s+");
            execOptions.setSuccessEmails(Arrays.asList(emailSplit));
        }
        if (HttpRequestUtils.hasParam(req, "notifyFailureFirst")) {
            execOptions.setNotifyOnFirstFailure(Boolean.parseBoolean(HttpRequestUtils.getParam(req, "notifyFailureFirst")));
        }
        if (HttpRequestUtils.hasParam(req, "notifyFailureLast")) {
            execOptions.setNotifyOnLastFailure(Boolean.parseBoolean(HttpRequestUtils.getParam(req, "notifyFailureLast")));
        }
        String concurrentOption = HttpRequestUtils.getParam(req, "concurrentOption", "skip");
        execOptions.setConcurrentOption(concurrentOption);
        if (concurrentOption.equals("pipeline")) {
            int pipelineLevel = HttpRequestUtils.getIntParam(req, "pipelineLevel");
            execOptions.setPipelineLevel(pipelineLevel);
        } else if (concurrentOption.equals("queue")) {
            int queueLevel = HttpRequestUtils.getIntParam(req, "queueLevel", 1);
            execOptions.setPipelineLevel(queueLevel);
        }
        String mailCreator = "default";
        if (HttpRequestUtils.hasParam(req, "mailCreator")) {
            mailCreator = HttpRequestUtils.getParam(req, "mailCreator");
            execOptions.setMailCreator(mailCreator);
        }
        Map<String, String> flowParamGroup = HttpRequestUtils.getParamGroup(req, "flowOverride");
        execOptions.addAllFlowParameters(flowParamGroup);
        if (HttpRequestUtils.hasParam(req, "disabled") && !(disabled = HttpRequestUtils.getParam(req, "disabled")).isEmpty()) {
            List disabledList = (List)JSONUtils.parseJSONFromStringQuiet((String)disabled);
            execOptions.setDisabledJobs(disabledList);
        }
        return execOptions;
    }

    public static ExecutionOptions parseFlowOptions(JsonObject jsonObject) throws ServletException {
        List disabledList;
        String[] emailSplit;
        String emails;
        ExecutionOptions execOptions = new ExecutionOptions();
        if (jsonObject.has("failureAction")) {
            String option = jsonObject.get("failureAction").getAsString();
            if (option.equals("finishCurrent")) {
                execOptions.setFailureAction(ExecutionOptions.FailureAction.FINISH_CURRENTLY_RUNNING);
            } else if (option.equals("cancelImmediately")) {
                execOptions.setFailureAction(ExecutionOptions.FailureAction.CANCEL_ALL);
            } else if (option.equals("finishPossible")) {
                execOptions.setFailureAction(ExecutionOptions.FailureAction.FINISH_ALL_POSSIBLE);
            } else if (option.equals("failedPause")) {
                execOptions.setFailureAction(ExecutionOptions.FailureAction.FAILED_PAUSE);
            }
        }
        if (jsonObject.has("failureEmailsOverride")) {
            boolean override = jsonObject.get("failureEmailsOverride").getAsBoolean();
            execOptions.setFailureEmailsOverridden(override);
        }
        if (jsonObject.has("successEmailsOverride")) {
            boolean override = jsonObject.get("successEmailsOverride").getAsBoolean();
            execOptions.setSuccessEmailsOverridden(override);
        }
        if (jsonObject.has("failureEmails") && !(emails = jsonObject.get("failureEmails").getAsString()).isEmpty()) {
            emailSplit = emails.split("\\s*,\\s*|\\s*;\\s*|\\s+");
            execOptions.setFailureEmails(Arrays.asList(emailSplit));
        }
        if (jsonObject.has("successEmails") && !(emails = jsonObject.get("successEmails").getAsString()).isEmpty()) {
            emailSplit = emails.split("\\s*,\\s*|\\s*;\\s*|\\s+");
            execOptions.setSuccessEmails(Arrays.asList(emailSplit));
        }
        if (jsonObject.has("notifyFailureFirst")) {
            execOptions.setNotifyOnFirstFailure(jsonObject.get("notifyFailureFirst").getAsBoolean());
        }
        if (jsonObject.has("notifyFailureLast")) {
            execOptions.setNotifyOnLastFailure(jsonObject.get("notifyFailureLast").getAsBoolean());
        }
        String concurrentOption = "skip";
        if (jsonObject.has("concurrentOption")) {
            concurrentOption = jsonObject.get("concurrentOption").getAsString();
        }
        execOptions.setConcurrentOption(concurrentOption);
        if (concurrentOption.equals("pipeline")) {
            int pipelineLevel = jsonObject.get("pipelineLevel").getAsInt();
            execOptions.setPipelineLevel(pipelineLevel);
        } else if (concurrentOption.equals("queue")) {
            int queueLevel = 1;
            if (jsonObject.has("queueLevel")) {
                queueLevel = jsonObject.get("queueLevel").getAsInt();
            }
            execOptions.setPipelineLevel(queueLevel);
        }
        String mailCreator = "default";
        if (jsonObject.has("mailCreator")) {
            mailCreator = jsonObject.get("mailCreator").getAsString();
            execOptions.setMailCreator(mailCreator);
        }
        Map<String, String> flowParamGroup = new HashMap<String, String>();
        if (jsonObject.has("flowOverride")) {
            flowParamGroup = (Map)GsonUtils.jsonToJavaObject((JsonElement)jsonObject.get("flowOverride").getAsJsonObject(), new TypeToken<Map<String, String>>(){}.getType());
        }
        execOptions.addAllFlowParameters(flowParamGroup);
        if (jsonObject.has("disabled") && (disabledList = (List)GsonUtils.jsonToJavaObject(jsonObject.get("disabled"), new TypeToken<List<Object>>(){}.getType())) != null) {
            execOptions.setDisabledJobs(disabledList);
        }
        return execOptions;
    }

    public static void filterAdminOnlyFlowParams(ExecutionOptions options, User user) throws ExecutorManagerException {
        if (options == null || options.getFlowParameters() == null) {
            return;
        }
        Map<String, String> params = options.getFlowParameters();
        if (!HttpRequestUtils.hasPermission(user, Permission.Type.ADMIN)) {
            params.remove("flowPriority");
            params.remove("useExecutor");
        } else {
            HttpRequestUtils.validateIntegerParam(params, "flowPriority");
            HttpRequestUtils.validateIntegerParam(params, "useExecutor");
        }
    }

    public static boolean validateIntegerParam(Map<String, String> params, String paramName) throws ExecutorManagerException {
        if (params != null && params.containsKey(paramName) && !StringUtils.isNumeric((String)params.get(paramName))) {
            throw new ExecutorManagerException(paramName + " should be an integer");
        }
        return true;
    }

    public static boolean hasPermission(User user, Permission.Type type) {
        for (String roleName : user.getRoles()) {
            Role role = user.getRoleMap().get(roleName);
            if ((role == null || !role.getPermission().isPermissionSet(type)) && !role.getPermission().isPermissionSet(Permission.Type.ADMIN)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasParam(HttpServletRequest request, String param) {
        return request.getParameter(param) != null;
    }

    public static String getParam(HttpServletRequest request, String name) throws ServletException {
        String p = StringEscapeUtils.unescapeHtml((String)request.getParameter(name));
        if (p == null) {
            throw new ServletException("Missing required parameter '" + name + "'.");
        }
        return p;
    }

    public static String getParam(HttpServletRequest request, String name, String defaultVal) {
        String p = request.getParameter(name);
        if (p == null) {
            return defaultVal;
        }
        return p;
    }

    public static int getIntParam(HttpServletRequest request, String name) throws ServletException {
        String p = HttpRequestUtils.getParam(request, name);
        return Integer.parseInt(p);
    }

    public static int getIntParam(HttpServletRequest request, String name, int defaultVal) {
        if (HttpRequestUtils.hasParam(request, name)) {
            try {
                return HttpRequestUtils.getIntParam(request, name);
            }
            catch (Exception e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public static boolean getBooleanParam(HttpServletRequest request, String name) throws ServletException {
        String p = HttpRequestUtils.getParam(request, name);
        return Boolean.parseBoolean(p);
    }

    public static boolean getBooleanParam(HttpServletRequest request, String name, boolean defaultVal) {
        if (HttpRequestUtils.hasParam(request, name)) {
            try {
                return HttpRequestUtils.getBooleanParam(request, name);
            }
            catch (Exception e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public static long getLongParam(HttpServletRequest request, String name) throws ServletException {
        String p = HttpRequestUtils.getParam(request, name);
        return Long.valueOf(p);
    }

    public static long getLongParam(HttpServletRequest request, String name, long defaultVal) {
        if (HttpRequestUtils.hasParam(request, name)) {
            try {
                return HttpRequestUtils.getLongParam(request, name);
            }
            catch (Exception e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public static Map<String, String> getParamGroup(HttpServletRequest request, String groupName) throws ServletException {
        Enumeration enumerate = request.getParameterNames();
        String matchString = groupName + "[";
        HashMap<String, String> groupParam = new HashMap<String, String>();
        while (enumerate.hasMoreElements()) {
            String str = (String)enumerate.nextElement();
            if (!str.startsWith(matchString)) continue;
            groupParam.put(str.substring(matchString.length(), str.length() - 1), request.getParameter(str));
        }
        return groupParam;
    }

    public static Map<String, Object> parseWebOptions(ExecutionOptions flowOptions) throws ServletException {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        if (null != flowOptions.getFailureAction()) {
            ExecutionOptions.FailureAction failureOption = flowOptions.getFailureAction();
            if (failureOption.equals((Object)ExecutionOptions.FailureAction.FINISH_CURRENTLY_RUNNING)) {
                responseMap.put("failureAction", "finishCurrent");
            } else if (failureOption.equals((Object)ExecutionOptions.FailureAction.CANCEL_ALL)) {
                responseMap.put("failureAction", "cancelImmediately");
            } else if (failureOption.equals((Object)ExecutionOptions.FailureAction.FINISH_ALL_POSSIBLE)) {
                responseMap.put("failureAction", "finishPossible");
            } else if (failureOption.equals((Object)ExecutionOptions.FailureAction.FAILED_PAUSE)) {
                responseMap.put("failureAction", "failedPause");
            }
        }
        responseMap.put("failureEmailsOverridden", flowOptions.isFailureEmailsOverridden());
        responseMap.put("successEmailsOverridden", flowOptions.isSuccessEmailsOverridden());
        if (null != flowOptions.getFailureEmails()) {
            responseMap.put("failureEmails", flowOptions.getFailureEmails());
        }
        if (null != flowOptions.getSuccessEmails()) {
            responseMap.put("successEmails", flowOptions.getSuccessEmails());
        }
        responseMap.put("notifyOnFirstFailure", flowOptions.getNotifyOnFirstFailure());
        responseMap.put("notifyOnLastFailure", flowOptions.getNotifyOnLastFailure());
        responseMap.put("concurrentOption", flowOptions.getConcurrentOption());
        if (null != flowOptions.getPipelineLevel()) {
            responseMap.put("pipelineLevel", flowOptions.getPipelineLevel());
        }
        responseMap.put("mailCreator", flowOptions.getMailCreator());
        responseMap.put("flowParameters", flowOptions.getFlowParameters());
        responseMap.put("disabledJobs", flowOptions.getDisabledJobs());
        return responseMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonObject parseRequestToJsonObject(HttpServletRequest request) {
        JsonObject json = null;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), "utf-8"));
            json = JsonParser.parseReader((Reader)br).getAsJsonObject();
        }
        catch (Exception io) {
            logger.error("IOException: {}", (Throwable)io);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException io) {
                logger.error("IOException: {}", (Throwable)io);
            }
        }
        return json;
    }
}

