/*
 * Decompiled with CFR 0.152.
 */
package azkaban.server;

import azkaban.server.session.SessionCache;
import azkaban.utils.Props;
import com.webank.wedatasphere.schedulis.common.system.common.TransitionService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.velocity.app.VelocityEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AzkabanServer {
    private static final Logger logger = LoggerFactory.getLogger(AzkabanServer.class);
    private static Props azkabanProperties = null;

    public static Props loadProps(String[] args) {
        azkabanProperties = AzkabanServer.loadProps(args, new OptionParser());
        return azkabanProperties;
    }

    public static Props getAzkabanProperties() {
        return azkabanProperties;
    }

    public static Props loadProps(String[] args, OptionParser parser) {
        ArgumentAcceptingOptionSpec configDirectory = parser.acceptsAll(Arrays.asList("c", "conf"), "The conf directory for Azkaban.").withRequiredArg().describedAs("conf").ofType(String.class);
        Props azkabanSettings = null;
        OptionSet options = parser.parse(args);
        if (options.has((OptionSpec)configDirectory)) {
            String path = (String)options.valueOf((OptionSpec)configDirectory);
            logger.info("Loading azkaban settings file from " + path);
            File dir = new File(path);
            if (!dir.exists()) {
                logger.error("Conf directory " + path + " doesn't exist.");
            } else if (!dir.isDirectory()) {
                logger.error("Conf directory " + path + " isn't a directory.");
            } else {
                azkabanSettings = AzkabanServer.loadAzkabanConfigurationFromDirectory(dir);
            }
        } else {
            logger.info("Conf parameter not set, attempting to get value from AZKABAN_HOME env.");
            azkabanSettings = AzkabanServer.loadConfigurationFromAzkabanHome();
        }
        if (azkabanSettings != null) {
            AzkabanServer.updateDerivedConfigs(azkabanSettings);
        }
        return azkabanSettings;
    }

    private static void updateDerivedConfigs(Props azkabanSettings) {
        boolean isSslEnabled = azkabanSettings.getBoolean("jetty.use.ssl", true);
        int port = isSslEnabled ? azkabanSettings.getInt("jetty.ssl.port", 8443) : azkabanSettings.getInt("jetty.port", 8081);
        String hostname = azkabanSettings.getString("jetty.hostname", "localhost");
        azkabanSettings.put("server.hostname", hostname);
        azkabanSettings.put("server.port", Integer.valueOf(port));
        azkabanSettings.put("server.useSSL", String.valueOf(isSslEnabled));
    }

    public static Props loadAzkabanConfigurationFromDirectory(File dir) {
        File azkabanPrivatePropsFile = new File(dir, "azkaban.private.properties");
        File azkabanPropsFile = new File(dir, "azkaban.properties");
        Props props = null;
        try {
            if (azkabanPrivatePropsFile.exists() && azkabanPrivatePropsFile.isFile()) {
                logger.info("Loading azkaban private properties file");
                props = new Props(null, azkabanPrivatePropsFile);
            }
            if (azkabanPropsFile.exists() && azkabanPropsFile.isFile()) {
                logger.info("Loading azkaban properties file");
                props = new Props(props, azkabanPropsFile);
            }
        }
        catch (FileNotFoundException e) {
            logger.error("File not found. Could not load azkaban config file", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("File found, but error reading. Could not load azkaban config file", (Throwable)e);
        }
        return props;
    }

    private static Props loadConfigurationFromAzkabanHome() {
        String azkabanHome = System.getenv("AZKABAN_HOME");
        if (azkabanHome == null) {
            logger.error("AZKABAN_HOME not set. Will try default.");
            return null;
        }
        if (!new File(azkabanHome).isDirectory() || !new File(azkabanHome).canRead()) {
            logger.error(azkabanHome + " is not a readable directory.");
            return null;
        }
        File confPath = new File(azkabanHome, "conf");
        if (!(confPath.exists() && confPath.isDirectory() && confPath.canRead())) {
            logger.error(azkabanHome + " does not contain a readable conf directory.");
            return null;
        }
        return AzkabanServer.loadAzkabanConfigurationFromDirectory(confPath);
    }

    public abstract Props getServerProps();

    public abstract SessionCache getSessionCache();

    public abstract VelocityEngine getVelocityEngine();

    public abstract TransitionService getTransitionService();
}

