/*
 * Decompiled with CFR 0.152.
 */
package azkaban.scheduler;

import azkaban.scheduler.Schedule;
import azkaban.scheduler.ScheduleLoader;
import azkaban.scheduler.ScheduleManagerException;
import azkaban.trigger.Condition;
import azkaban.trigger.ConditionChecker;
import azkaban.trigger.Trigger;
import azkaban.trigger.TriggerAction;
import azkaban.trigger.TriggerLoaderException;
import azkaban.trigger.TriggerManager;
import azkaban.trigger.TriggerManagerAdapter;
import azkaban.trigger.TriggerManagerException;
import azkaban.trigger.builtin.BasicTimeChecker;
import azkaban.trigger.builtin.ExecuteFlowAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerBasedScheduleLoader
implements ScheduleLoader {
    private static final Logger logger = LoggerFactory.getLogger(TriggerBasedScheduleLoader.class);
    private final TriggerManagerAdapter triggerManager;
    private final String triggerSource;
    private long lastUpdateTime = -1L;

    @Inject
    public TriggerBasedScheduleLoader(TriggerManager triggerManager) {
        this.triggerManager = triggerManager;
        this.triggerSource = "SimpleTimeTrigger";
    }

    private Trigger scheduleToTrigger(Schedule s) {
        Condition triggerCondition = this.createTriggerCondition(s);
        Condition expireCondition = this.createExpireCondition(s);
        List<TriggerAction> actions = this.createActions(s);
        Trigger t = new Trigger.TriggerBuilder(s.getSubmitUser(), this.triggerSource, triggerCondition, expireCondition, actions).setSubmitTime(s.getSubmitTime()).setLastModifyTime(s.getLastModifyTime()).setId(s.getScheduleId()).build();
        if (s.isRecurring()) {
            t.setResetOnTrigger(true);
        } else {
            t.setResetOnTrigger(false);
        }
        return t;
    }

    private List<TriggerAction> createActions(Schedule s) {
        ArrayList<TriggerAction> actions = new ArrayList<TriggerAction>();
        ExecuteFlowAction executeAct = new ExecuteFlowAction("executeFlowAction", s.getProjectId(), s.getProjectName(), s.getFlowName(), s.getSubmitUser(), s.getExecutionOptions(), s.getSlaOptions(), s.getOtherOption());
        actions.add(executeAct);
        return actions;
    }

    private Condition createTriggerCondition(Schedule s) {
        HashMap<String, ConditionChecker> checkers = new HashMap<String, ConditionChecker>();
        BasicTimeChecker checker = new BasicTimeChecker("BasicTimeChecker_1", s.getFirstSchedTime(), s.getTimezone(), s.isRecurring(), s.skipPastOccurrences(), s.getPeriod(), s.getCronExpression());
        checkers.put(checker.getId(), checker);
        String expr = checker.getId() + ".eval()";
        Condition cond = new Condition(checkers, expr);
        return cond;
    }

    private Condition createExpireCondition(Schedule s) {
        HashMap<String, ConditionChecker> checkers = new HashMap<String, ConditionChecker>();
        BasicTimeChecker checker = new BasicTimeChecker("EndTimeChecker_1", s.getFirstSchedTime(), s.getTimezone(), s.getEndSchedTime(), false, false, null, null);
        checkers.put(checker.getId(), checker);
        String expr = checker.getId() + ".eval()";
        return new Condition(checkers, expr);
    }

    @Override
    public void insertSchedule(Schedule s) throws ScheduleManagerException {
        Trigger t = this.scheduleToTrigger(s);
        try {
            this.triggerManager.insertTrigger(t, t.getSubmitUser());
            s.setScheduleId(t.getTriggerId());
        }
        catch (TriggerManagerException e) {
            throw new ScheduleManagerException("Failed to insert new schedule!", e);
        }
    }

    @Override
    public void updateSchedule(Schedule s) throws ScheduleManagerException {
        Trigger t = this.scheduleToTrigger(s);
        try {
            this.triggerManager.updateTrigger(t, t.getSubmitUser());
        }
        catch (TriggerManagerException e) {
            throw new ScheduleManagerException("Failed to update schedule!", e);
        }
    }

    private Schedule triggerToSchedule(Trigger t) throws ScheduleManagerException {
        BasicTimeChecker triggerTimeChecker = this.getBasicTimeChecker(t.getTriggerCondition().getCheckers());
        BasicTimeChecker endTimeChecker = this.getEndTimeChecker(t);
        List<TriggerAction> actions = t.getActions();
        ExecuteFlowAction act = null;
        for (TriggerAction action : actions) {
            if (!action.getType().equals("ExecuteFlowAction")) continue;
            act = (ExecuteFlowAction)action;
            break;
        }
        if (triggerTimeChecker != null && act != null) {
            return new Schedule(t.getTriggerId(), act.getProjectId(), act.getProjectName(), act.getFlowName(), t.getStatus().toString(), triggerTimeChecker.getFirstCheckTime(), endTimeChecker == null ? 2524608000000L : endTimeChecker.getNextCheckTime(), triggerTimeChecker.getTimeZone(), triggerTimeChecker.getPeriod(), t.getLastModifyTime(), triggerTimeChecker.getNextCheckTime(), t.getSubmitTime(), t.getSubmitUser(), act.getExecutionOptions(), act.getSlaOptions(), triggerTimeChecker.getCronExpression(), act.getOtherOption());
        }
        logger.error("Failed to parse schedule from trigger!");
        throw new ScheduleManagerException("Failed to parse schedule from trigger!");
    }

    private BasicTimeChecker getBasicTimeChecker(Map<String, ConditionChecker> checkers) {
        for (ConditionChecker checker : checkers.values()) {
            if (!checker.getType().equals("BasicTimeChecker")) continue;
            return (BasicTimeChecker)checker;
        }
        return null;
    }

    private BasicTimeChecker getEndTimeChecker(Trigger t) {
        if (t.getExpireCondition().getExpression().contains("EndTimeChecker")) {
            return this.getBasicTimeChecker(t.getExpireCondition().getCheckers());
        }
        return null;
    }

    @Override
    public void removeSchedule(Schedule s) throws ScheduleManagerException {
        try {
            this.triggerManager.removeTrigger(s.getScheduleId(), s.getSubmitUser());
        }
        catch (TriggerManagerException e) {
            throw new ScheduleManagerException(e.getMessage());
        }
    }

    @Override
    public void updateNextExecTime(Schedule s) throws ScheduleManagerException {
    }

    @Override
    public synchronized List<Schedule> loadUpdatedSchedules() throws ScheduleManagerException {
        List<Trigger> triggers;
        try {
            triggers = this.triggerManager.getTriggerUpdates(this.triggerSource, this.lastUpdateTime);
        }
        catch (TriggerManagerException e) {
            logger.error("load updated schedules failed, caused by:" + e);
            throw new ScheduleManagerException(e);
        }
        ArrayList<Schedule> schedules = new ArrayList<Schedule>();
        for (Trigger t : triggers) {
            this.lastUpdateTime = Math.max(this.lastUpdateTime, t.getLastModifyTime());
            if (t.getActions().size() == 0) continue;
            Schedule s = this.triggerToSchedule(t);
            schedules.add(s);
            logger.info("loaded schedule for " + s.getProjectName() + " (project_ID: " + s.getProjectId() + ")");
        }
        return schedules;
    }

    @Override
    public synchronized List<Integer> loadAllSchedulesId() throws TriggerLoaderException {
        List<Integer> triggersId = null;
        try {
            triggersId = this.triggerManager.getAllTriggersId();
        }
        catch (TriggerLoaderException e) {
            logger.error("load updated schedules failed, caused by:" + e);
        }
        return triggersId;
    }
}

