/*
 * Decompiled with CFR 0.152.
 */
package azkaban.scheduler;

import azkaban.executor.ExecutionOptions;
import azkaban.scheduler.Schedule;
import azkaban.scheduler.ScheduleLoader;
import azkaban.scheduler.ScheduleManagerException;
import azkaban.sla.SlaOption;
import azkaban.trigger.TriggerAgent;
import azkaban.trigger.TriggerLoaderException;
import azkaban.trigger.TriggerStatus;
import azkaban.user.User;
import azkaban.utils.Pair;
import azkaban.utils.Props;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleManager
implements TriggerAgent {
    public static final String SIMPLE_TIME_TRIGGER = "SimpleTimeTrigger";
    private static final Logger logger = LoggerFactory.getLogger(ScheduleManager.class);
    private final DateTimeFormatter _dateFormat = DateTimeFormat.forPattern((String)"MM-dd-yyyy HH:mm:ss:SSS");
    private final ScheduleLoader loader;
    private final Map<Integer, Schedule> scheduleIDMap = new LinkedHashMap<Integer, Schedule>();
    private final Map<Pair<Integer, String>, Schedule> scheduleIdentityPairMap = new LinkedHashMap<Pair<Integer, String>, Schedule>();
    private Props azkprops;

    @Inject
    public ScheduleManager(Props props, ScheduleLoader loader) {
        this.azkprops = props;
        Objects.requireNonNull(props);
        this.loader = loader;
    }

    @Override
    @Deprecated
    public void start() throws ScheduleManagerException {
    }

    private synchronized void updateLocal() throws ScheduleManagerException {
        List<Schedule> updates = this.loader.loadUpdatedSchedules();
        for (Schedule s : updates) {
            if (s.getStatus().equals(TriggerStatus.EXPIRED.toString())) {
                this.onScheduleExpire(s);
                continue;
            }
            this.internalSchedule(s);
        }
        if (this.azkprops.getBoolean("webserver.ha.model", false)) {
            this.filterInvalidSchedules();
        }
    }

    private void filterInvalidSchedules() {
        try {
            List<Integer> schedulesId = this.loader.loadAllSchedulesId();
            if (this.scheduleIDMap != null && this.scheduleIDMap.size() != 0) {
                Set<Integer> tmpScheduleIDSet = this.scheduleIDMap.keySet();
                Iterator<Object> iterator = tmpScheduleIDSet.iterator();
                while (iterator.hasNext()) {
                    int scheduleId = (Integer)iterator.next();
                    if (schedulesId != null && schedulesId.size() != 0) {
                        if (schedulesId.contains(scheduleId)) continue;
                        this.scheduleIDMap.remove(scheduleId);
                        continue;
                    }
                    this.scheduleIDMap.clear();
                }
            }
            if (this.scheduleIdentityPairMap != null && this.scheduleIdentityPairMap.size() != 0) {
                Collection<Schedule> tmpScheduleIdentityPairSet = this.scheduleIdentityPairMap.values();
                for (Schedule schedule : tmpScheduleIdentityPairSet) {
                    if (schedulesId != null && schedulesId.size() != 0) {
                        if (schedulesId.contains(schedule.getScheduleId())) continue;
                        this.scheduleIdentityPairMap.remove(schedule);
                        continue;
                    }
                    this.scheduleIdentityPairMap.clear();
                }
            }
        }
        catch (TriggerLoaderException e) {
            logger.error("filterInvalidSchedules failed " + e);
        }
    }

    private void onScheduleExpire(Schedule s) {
        this.removeSchedule(s);
    }

    @Override
    public void shutdown() {
    }

    public synchronized List<Schedule> getSchedules() throws ScheduleManagerException {
        this.updateLocal();
        return new ArrayList<Schedule>(this.scheduleIDMap.values());
    }

    public Schedule getSchedule(int projectId, String flowId) throws ScheduleManagerException {
        this.updateLocal();
        return this.scheduleIdentityPairMap.get(new Pair<Integer, String>(projectId, flowId));
    }

    public Schedule getSchedule(int scheduleId) throws ScheduleManagerException {
        this.updateLocal();
        return this.scheduleIDMap.get(scheduleId);
    }

    public synchronized void removeSchedule(Schedule sched) {
        Pair<Integer, String> identityPairMap = sched.getScheduleIdentityPair();
        Schedule schedule = this.scheduleIdentityPairMap.get(identityPairMap);
        if (schedule != null) {
            this.scheduleIdentityPairMap.remove(identityPairMap);
        }
        this.scheduleIDMap.remove(sched.getScheduleId());
        try {
            this.loader.removeSchedule(sched);
        }
        catch (ScheduleManagerException e) {
            logger.error("", (Throwable)e);
        }
    }

    public Schedule scheduleFlow(int scheduleId, int projectId, String projectName, String flowName, String status, long firstSchedTime, long endSchedTime, DateTimeZone timezone, ReadablePeriod period, long lastModifyTime, long nextExecTime, long submitTime, String submitUser, ExecutionOptions execOptions, List<SlaOption> slaOptions) {
        Schedule sched = new Schedule(scheduleId, projectId, projectName, flowName, status, firstSchedTime, endSchedTime, timezone, period, lastModifyTime, nextExecTime, submitTime, submitUser, execOptions, slaOptions, null);
        logger.info("Scheduling flow '" + sched.getScheduleName() + "' for " + this._dateFormat.print(firstSchedTime) + " with a period of " + (period == null ? "(non-recurring)" : period));
        this.insertSchedule(sched);
        return sched;
    }

    public Schedule cronScheduleFlow(int scheduleId, int projectId, String projectName, String flowName, String status, long firstSchedTime, long endSchedTime, DateTimeZone timezone, long lastModifyTime, long nextExecTime, long submitTime, String submitUser, ExecutionOptions execOptions, List<SlaOption> slaOptions, String cronExpression) {
        Schedule sched = new Schedule(scheduleId, projectId, projectName, flowName, status, firstSchedTime, endSchedTime, timezone, null, lastModifyTime, nextExecTime, submitTime, submitUser, execOptions, slaOptions, cronExpression);
        logger.info("Scheduling flow '" + sched.getScheduleName() + "' for " + this._dateFormat.print(firstSchedTime) + " cron Expression = " + cronExpression);
        this.insertSchedule(sched);
        return sched;
    }

    public Schedule cronScheduleFlow(int scheduleId, int projectId, String projectName, String flowName, String status, long firstSchedTime, long endSchedTime, DateTimeZone timezone, long lastModifyTime, long nextExecTime, long submitTime, String submitUser, ExecutionOptions execOptions, List<SlaOption> slaOptions, String cronExpression, Map<String, Object> otherOption) {
        Schedule sched = new Schedule(scheduleId, projectId, projectName, flowName, status, firstSchedTime, endSchedTime, timezone, null, lastModifyTime, nextExecTime, submitTime, submitUser, execOptions, slaOptions, cronExpression, otherOption);
        logger.info("Scheduling flow '" + sched.getScheduleName() + "' for " + this._dateFormat.print(firstSchedTime) + " cron Expression = " + cronExpression);
        this.insertSchedule(sched);
        return sched;
    }

    private synchronized void internalSchedule(Schedule s) {
        this.scheduleIDMap.put(s.getScheduleId(), s);
        this.scheduleIdentityPairMap.put(s.getScheduleIdentityPair(), s);
    }

    public synchronized void insertSchedule(Schedule s) {
        block5: {
            Schedule exist = this.scheduleIdentityPairMap.get(s.getScheduleIdentityPair());
            if (s.updateTime()) {
                try {
                    if (exist == null) {
                        this.loader.insertSchedule(s);
                        this.internalSchedule(s);
                        break block5;
                    }
                    s.setScheduleId(exist.getScheduleId());
                    this.loader.updateSchedule(s);
                    this.internalSchedule(s);
                }
                catch (ScheduleManagerException e) {
                    logger.error("", (Throwable)e);
                }
            } else {
                logger.error("The provided schedule is non-recurring and the scheduled time already passed. " + s.getScheduleName());
            }
        }
    }

    @Override
    public void loadTriggerFromProps(Props props) throws ScheduleManagerException {
        throw new ScheduleManagerException("create " + this.getTriggerSource() + " from json not supported yet");
    }

    @Override
    public String getTriggerSource() {
        return SIMPLE_TIME_TRIGGER;
    }

    public synchronized List<Schedule> getSchedulesByUser(User user) throws ScheduleManagerException {
        this.updateLocal();
        ArrayList<Schedule> scheduleList = new ArrayList<Schedule>(this.scheduleIDMap.values());
        List<Schedule> userScheduleList = scheduleList.stream().filter(schedule -> user.getUserId().equals(schedule.getSubmitUser())).collect(Collectors.toList());
        return userScheduleList;
    }
}

