/*
 * Decompiled with CFR 0.152.
 */
package azkaban.scheduler;

import azkaban.executor.ExecutionOptions;
import azkaban.sla.SlaOption;
import azkaban.utils.Pair;
import azkaban.utils.Utils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.DurationFieldType;
import org.joda.time.Hours;
import org.joda.time.Minutes;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;
import org.joda.time.Weeks;
import org.quartz.CronExpression;

public class Schedule {
    private final int projectId;
    private final String projectName;
    private final String flowName;
    private final long firstSchedTime;
    private final long endSchedTime;
    private final DateTimeZone timezone;
    private final long lastModifyTime;
    private final ReadablePeriod period;
    private final String submitUser;
    private final String status;
    private final long submitTime;
    private final String cronExpression;
    private final boolean skipPastOccurrences = true;
    private int scheduleId;
    private long nextExecTime;
    private ExecutionOptions executionOptions;
    private List<SlaOption> slaOptions;
    private Map<String, Object> otherOption = new HashMap<String, Object>();

    public Schedule(int scheduleId, int projectId, String projectName, String flowName, String status, long firstSchedTime, long endSchedTime, DateTimeZone timezone, ReadablePeriod period, long lastModifyTime, long nextExecTime, long submitTime, String submitUser, ExecutionOptions executionOptions, List<SlaOption> slaOptions, String cronExpression) {
        this.scheduleId = scheduleId;
        this.projectId = projectId;
        this.projectName = projectName;
        this.flowName = flowName;
        this.firstSchedTime = firstSchedTime;
        this.endSchedTime = endSchedTime;
        this.timezone = timezone;
        this.lastModifyTime = lastModifyTime;
        this.period = period;
        this.nextExecTime = nextExecTime;
        this.submitUser = submitUser;
        this.status = status;
        this.submitTime = submitTime;
        this.executionOptions = executionOptions;
        this.slaOptions = slaOptions;
        this.cronExpression = cronExpression;
    }

    public Schedule(int scheduleId, int projectId, String projectName, String flowName, String status, long firstSchedTime, long endSchedTime, DateTimeZone timezone, ReadablePeriod period, long lastModifyTime, long nextExecTime, long submitTime, String submitUser, ExecutionOptions executionOptions, List<SlaOption> slaOptions, String cronExpression, Map<String, Object> otherOption) {
        this.scheduleId = scheduleId;
        this.projectId = projectId;
        this.projectName = projectName;
        this.flowName = flowName;
        this.firstSchedTime = firstSchedTime;
        this.endSchedTime = endSchedTime;
        this.timezone = timezone;
        this.lastModifyTime = lastModifyTime;
        this.period = period;
        this.nextExecTime = nextExecTime;
        this.submitUser = submitUser;
        this.status = status;
        this.submitTime = submitTime;
        this.executionOptions = executionOptions;
        this.slaOptions = slaOptions;
        this.cronExpression = cronExpression;
        this.otherOption = otherOption;
    }

    public static ReadablePeriod parsePeriodString(String periodStr) {
        Months period;
        char periodUnit = periodStr.charAt(periodStr.length() - 1);
        if (periodUnit == 'n') {
            return null;
        }
        int periodInt = Integer.parseInt(periodStr.substring(0, periodStr.length() - 1));
        switch (periodUnit) {
            case 'M': {
                period = Months.months((int)periodInt);
                break;
            }
            case 'w': {
                period = Weeks.weeks((int)periodInt);
                break;
            }
            case 'd': {
                period = Days.days((int)periodInt);
                break;
            }
            case 'h': {
                period = Hours.hours((int)periodInt);
                break;
            }
            case 'm': {
                period = Minutes.minutes((int)periodInt);
                break;
            }
            case 's': {
                period = Seconds.seconds((int)periodInt);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid schedule period unit '" + periodUnit);
            }
        }
        return period;
    }

    public static String createPeriodString(ReadablePeriod period) {
        String periodStr = "n";
        if (period == null) {
            return "n";
        }
        if (period.get(DurationFieldType.months()) > 0) {
            int months = period.get(DurationFieldType.months());
            periodStr = months + "M";
        } else if (period.get(DurationFieldType.weeks()) > 0) {
            int weeks = period.get(DurationFieldType.weeks());
            periodStr = weeks + "w";
        } else if (period.get(DurationFieldType.days()) > 0) {
            int days = period.get(DurationFieldType.days());
            periodStr = days + "d";
        } else if (period.get(DurationFieldType.hours()) > 0) {
            int hours = period.get(DurationFieldType.hours());
            periodStr = hours + "h";
        } else if (period.get(DurationFieldType.minutes()) > 0) {
            int minutes = period.get(DurationFieldType.minutes());
            periodStr = minutes + "m";
        } else if (period.get(DurationFieldType.seconds()) > 0) {
            int seconds = period.get(DurationFieldType.seconds());
            periodStr = seconds + "s";
        }
        return periodStr;
    }

    public ExecutionOptions getExecutionOptions() {
        return this.executionOptions;
    }

    public List<SlaOption> getSlaOptions() {
        return this.slaOptions;
    }

    public void setSlaOptions(List<SlaOption> slaOptions) {
        this.slaOptions = slaOptions;
    }

    public void setFlowOptions(ExecutionOptions executionOptions) {
        this.executionOptions = executionOptions;
    }

    public String getScheduleName() {
        return this.projectName + "." + this.flowName + " (" + this.projectId + ")";
    }

    public Map<String, Object> getOtherOption() {
        return this.otherOption;
    }

    public void setOtherOption(Map<String, Object> otherOption) {
        this.otherOption = otherOption;
    }

    public String toString() {
        String underlying = this.projectName + "." + this.flowName + " (" + this.projectId + ") to be run at (starting) " + new DateTime(this.firstSchedTime).toDateTimeISO();
        if (this.period == null && this.cronExpression == null) {
            return underlying + " non-recurring";
        }
        if (this.cronExpression != null) {
            return underlying + " with CronExpression {" + this.cronExpression + "}";
        }
        return underlying + " with precurring period of " + Schedule.createPeriodString(this.period);
    }

    public Pair<Integer, String> getScheduleIdentityPair() {
        return new Pair<Integer, String>(this.getProjectId(), this.getFlowName());
    }

    public int getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(int scheduleId) {
        this.scheduleId = scheduleId;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public long getFirstSchedTime() {
        return this.firstSchedTime;
    }

    public DateTimeZone getTimezone() {
        return this.timezone;
    }

    public long getLastModifyTime() {
        return this.lastModifyTime;
    }

    public ReadablePeriod getPeriod() {
        return this.period;
    }

    public long getNextExecTime() {
        return this.nextExecTime;
    }

    public void setNextExecTime(long nextExecTime) {
        this.nextExecTime = nextExecTime;
    }

    public String getSubmitUser() {
        return this.submitUser;
    }

    public String getStatus() {
        return this.status;
    }

    public long getSubmitTime() {
        return this.submitTime;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public boolean updateTime() {
        if (new DateTime(this.nextExecTime).isAfterNow()) {
            return true;
        }
        if (this.cronExpression != null) {
            DateTime nextTime = this.getNextCronRuntime(this.nextExecTime, this.timezone, Utils.parseCronExpression((String)this.cronExpression, (DateTimeZone)this.timezone));
            this.nextExecTime = nextTime.getMillis();
            return true;
        }
        if (this.period != null) {
            DateTime nextTime = this.getNextRuntime(this.nextExecTime, this.timezone, this.period);
            this.nextExecTime = nextTime.getMillis();
            return true;
        }
        return false;
    }

    private DateTime getNextRuntime(long scheduleTime, DateTimeZone timezone, ReadablePeriod period) {
        DateTime now = new DateTime();
        DateTime date = new DateTime(scheduleTime).withZone(timezone);
        int count = 0;
        while (!now.isBefore((ReadableInstant)date)) {
            if (count > 100000) {
                throw new IllegalStateException("100000 increments of period did not get to present time.");
            }
            if (period == null) break;
            date = date.plus(period);
            ++count;
        }
        return date;
    }

    private DateTime getNextCronRuntime(long scheduleTime, DateTimeZone timezone, CronExpression ce) {
        Date date = new DateTime(scheduleTime).withZone(timezone).toDate();
        if (ce != null) {
            date = ce.getNextValidTimeAfter(date);
        }
        return new DateTime((Object)date);
    }

    public Map<String, Object> optionsToObject() {
        if (this.executionOptions != null) {
            HashMap<String, Object> schedObj = new HashMap<String, Object>();
            if (this.executionOptions != null) {
                schedObj.put("executionOptions", this.executionOptions.toObject());
            }
            if (this.slaOptions != null) {
                ArrayList<Map<String, Object>> slaOptionsObject = new ArrayList<Map<String, Object>>();
                for (SlaOption sla : this.slaOptions) {
                    slaOptionsObject.add(sla.toObject());
                }
                schedObj.put("slaOptions", slaOptionsObject);
            }
            return schedObj;
        }
        return null;
    }

    public void createAndSetScheduleOptions(Object obj) {
        ExecutionOptions execOptions;
        HashMap schedObj = (HashMap)obj;
        if (schedObj.containsKey("executionOptions")) {
            this.executionOptions = execOptions = ExecutionOptions.createFromObject(schedObj.get("executionOptions"));
        } else if (schedObj.containsKey("flowOptions")) {
            this.executionOptions = execOptions = ExecutionOptions.createFromObject(schedObj.get("flowOptions"));
            execOptions.setConcurrentOption("skip");
        } else {
            this.executionOptions = new ExecutionOptions();
            this.executionOptions.setConcurrentOption("skip");
        }
        if (schedObj.containsKey("slaOptions")) {
            List slaOptionsObject = (List)schedObj.get("slaOptions");
            ArrayList<SlaOption> slaOptions = new ArrayList<SlaOption>();
            for (Object slaObj : slaOptionsObject) {
                slaOptions.add(SlaOption.fromObject(slaObj));
            }
            this.slaOptions = slaOptions;
        }
    }

    public boolean isRecurring() {
        return this.period != null || this.cronExpression != null;
    }

    public boolean skipPastOccurrences() {
        return this.skipPastOccurrences;
    }

    public long getEndSchedTime() {
        return this.endSchedTime;
    }
}

