/*
 * Decompiled with CFR 0.152.
 */
package azkaban.project.validator;

import azkaban.project.Project;
import azkaban.project.validator.ProjectValidator;
import azkaban.project.validator.ValidationReport;
import azkaban.project.validator.ValidatorClassLoader;
import azkaban.project.validator.ValidatorManager;
import azkaban.project.validator.ValidatorManagerException;
import azkaban.utils.Props;
import com.webank.wedatasphere.schedulis.common.utils.XmlResolveUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlValidatorManager
implements ValidatorManager {
    public static final String VALIDATOR_TAG = "validator";
    public static final String CLASSNAME_ATTR = "classname";
    public static final String ITEM_TAG = "property";
    private static final Logger logger = LoggerFactory.getLogger(XmlValidatorManager.class);
    private static final Map<String, Long> resourceTimestamps = new HashMap<String, Long>();
    private static ValidatorClassLoader validatorLoader;
    private final String validatorDirPath;
    private Map<String, ProjectValidator> validators;

    public XmlValidatorManager(Props props) {
        this.validatorDirPath = props.getString("project.validators.dir", "validators");
        File validatorDir = new File(this.validatorDirPath);
        if (!validatorDir.canRead() || !validatorDir.isDirectory()) {
            logger.warn("Validator directory " + this.validatorDirPath + " does not exist or is not a directory.");
        }
        this.checkResources();
        try {
            this.loadValidators(props, logger);
        }
        catch (Exception e) {
            logger.error("Cannot load all the validators.");
            throw new ValidatorManagerException(e);
        }
    }

    private void checkResources() {
        File validatorDir = new File(this.validatorDirPath);
        ArrayList<URL> resources = new ArrayList<URL>();
        boolean reloadResources = false;
        try {
            if (validatorDir.canRead() && validatorDir.isDirectory()) {
                for (File f : validatorDir.listFiles()) {
                    if (!f.getName().endsWith(".jar")) continue;
                    resources.add(f.toURI().toURL());
                    if (resourceTimestamps.get(f.getName()) != null && resourceTimestamps.get(f.getName()).longValue() == f.lastModified()) continue;
                    reloadResources = true;
                    logger.info("Resource " + f.getName() + " is updated. Reload the classloader.");
                    resourceTimestamps.put(f.getName(), f.lastModified());
                }
            }
        }
        catch (MalformedURLException e) {
            throw new ValidatorManagerException(e);
        }
        if (reloadResources) {
            if (validatorLoader != null) {
                try {
                    validatorLoader.close();
                }
                catch (ValidatorManagerException e) {
                    logger.error("Cannot reload validator classloader because failure to close the validator classloader.", (Throwable)e);
                }
            }
            validatorLoader = new ValidatorClassLoader(resources.toArray(new URL[resources.size()]));
        }
    }

    @Override
    public void loadValidators(Props props, Logger log) {
        this.validators = new LinkedHashMap<String, ProjectValidator>();
        if (!props.containsKey((Object)"project.validators.xml.file")) {
            logger.warn("Azkaban properties file does not contain the key project.validators.xml.file");
            return;
        }
        String xmlPath = props.get((Object)"project.validators.xml.file");
        File file = new File(xmlPath);
        if (!file.exists()) {
            logger.error("Azkaban validator configuration file " + xmlPath + " does not exist.");
            return;
        }
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            XmlResolveUtils.avoidXEE(docBuilderFactory);
            builder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ValidatorManagerException("Exception while parsing validator xml. Document builder not created.", e);
        }
        Document doc = null;
        try {
            doc = builder.parse(file);
        }
        catch (SAXException e) {
            throw new ValidatorManagerException("Exception while parsing " + xmlPath + ". Invalid XML.", e);
        }
        catch (IOException e) {
            throw new ValidatorManagerException("Exception while parsing " + xmlPath + ". Error reading file.", e);
        }
        NodeList tagList = doc.getChildNodes();
        Node azkabanValidators = tagList.item(0);
        NodeList azkabanValidatorsList = azkabanValidators.getChildNodes();
        for (int i = 0; i < azkabanValidatorsList.getLength(); ++i) {
            Node node = azkabanValidatorsList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals(VALIDATOR_TAG)) continue;
            this.parseValidatorTag(node, props, log);
        }
    }

    private void parseValidatorTag(Node node, Props props, Logger log) {
        NamedNodeMap validatorAttrMap = node.getAttributes();
        Node classNameAttr = validatorAttrMap.getNamedItem(CLASSNAME_ATTR);
        if (classNameAttr == null) {
            throw new ValidatorManagerException("Error loading validator. The validator 'classname' attribute doesn't exist");
        }
        NodeList keyValueItemsList = node.getChildNodes();
        for (int i = 0; i < keyValueItemsList.getLength(); ++i) {
            Node keyValuePair = keyValueItemsList.item(i);
            if (!keyValuePair.getNodeName().equals(ITEM_TAG)) continue;
            this.parseItemTag(keyValuePair, props);
        }
        String className = classNameAttr.getNodeValue();
        try {
            Class<?> validatorClass = validatorLoader.loadClass(className);
            Constructor<?> validatorConstructor = validatorClass.getConstructor(Logger.class);
            ProjectValidator validator = (ProjectValidator)validatorConstructor.newInstance(log);
            validator.initialize(props);
            this.validators.put(validator.getValidatorName(), validator);
            logger.info("Added validator " + className + " to list of validators.");
        }
        catch (Exception e) {
            logger.error("Could not instantiate ProjectValidator " + className);
            throw new ValidatorManagerException(e);
        }
    }

    private void parseItemTag(Node node, Props props) {
        NamedNodeMap keyValueMap = node.getAttributes();
        Node keyAttr = keyValueMap.getNamedItem("key");
        Node valueAttr = keyValueMap.getNamedItem("value");
        if (keyAttr == null || valueAttr == null) {
            throw new ValidatorManagerException("Error loading validator key/value pair. The 'key' or 'value' attribute doesn't exist");
        }
        props.put(keyAttr.getNodeValue(), valueAttr.getNodeValue());
    }

    @Override
    public Map<String, ValidationReport> validate(Project project, File projectDir) {
        LinkedHashMap<String, ValidationReport> reports = new LinkedHashMap<String, ValidationReport>();
        for (Map.Entry<String, ProjectValidator> validator : this.validators.entrySet()) {
            reports.put(validator.getKey(), validator.getValue().validateProject(project, projectDir));
            logger.info("Validation status of validator " + validator.getKey() + " is " + (Object)((Object)((ValidationReport)reports.get(validator.getKey())).getStatus()));
        }
        return reports;
    }

    @Override
    public List<String> getValidatorsInfo() {
        ArrayList<String> info = new ArrayList<String>();
        for (String key : this.validators.keySet()) {
            info.add(key);
        }
        return info;
    }
}

