/*
 * Decompiled with CFR 0.152.
 */
package azkaban.project;

import azkaban.executor.ExecutorManagerException;
import azkaban.flow.Flow;
import azkaban.project.AzkabanProjectLoader;
import azkaban.project.FlowLoaderUtils;
import azkaban.project.FlowTrigger;
import azkaban.project.Project;
import azkaban.project.ProjectFileHandler;
import azkaban.project.ProjectLoader;
import azkaban.project.ProjectLogEvent;
import azkaban.project.ProjectManagerException;
import azkaban.project.ProjectWhitelist;
import azkaban.project.validator.ValidationReport;
import azkaban.project.validator.XmlValidatorManager;
import azkaban.storage.StorageManager;
import azkaban.user.Permission;
import azkaban.user.User;
import azkaban.utils.CaseInsensitiveConcurrentHashMap;
import azkaban.utils.Props;
import azkaban.utils.PropsUtils;
import com.google.common.io.Files;
import com.webank.wedatasphere.schedulis.common.i18nutils.LoadJsonUtils;
import com.webank.wedatasphere.schedulis.common.system.SystemManager;
import com.webank.wedatasphere.schedulis.common.utils.PagingListStreamUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ProjectManager {
    private static final Logger logger = LoggerFactory.getLogger(ProjectManager.class);
    private final AzkabanProjectLoader azkabanProjectLoader;
    private final ProjectLoader projectLoader;
    private final Props props;
    private final boolean creatorDefaultPermissions;
    private final ConcurrentHashMap<Integer, Project> projectsById = new ConcurrentHashMap();
    private final CaseInsensitiveConcurrentHashMap<Project> projectsByName = new CaseInsensitiveConcurrentHashMap();
    private SystemManager systemManager;

    @Inject
    public ProjectManager(AzkabanProjectLoader azkabanProjectLoader, ProjectLoader loader, StorageManager storageManager, Props props, SystemManager systemManager) {
        this.projectLoader = Objects.requireNonNull(loader);
        this.props = Objects.requireNonNull(props);
        this.azkabanProjectLoader = Objects.requireNonNull(azkabanProjectLoader);
        this.systemManager = Objects.requireNonNull(systemManager);
        this.creatorDefaultPermissions = props.getBoolean("creator.default.proxy", true);
        Props prop = new Props(props);
        prop.put("project.archive.file.path", "initialize");
        new XmlValidatorManager(prop);
        this.loadAllProjects();
        this.loadProjectWhiteList();
    }

    public boolean hasFlowTrigger(Project project, Flow flow) throws IOException, ProjectManagerException {
        String flowFileName = flow.getId() + ".flow";
        int latestFlowVersion = this.projectLoader.getLatestFlowVersion(project.getId(), flow.getVersion(), flowFileName);
        if (latestFlowVersion > 0) {
            File tempDir = Files.createTempDir();
            try {
                File flowFile = this.projectLoader.getUploadedFlowFile(project.getId(), project.getVersion(), flowFileName, latestFlowVersion, tempDir);
                FlowTrigger flowTrigger = FlowLoaderUtils.getFlowTriggerFromYamlFile(flowFile);
                boolean bl = flowTrigger != null;
                return bl;
            }
            catch (Exception ex) {
                logger.error("error in getting flow file", (Throwable)ex);
                throw ex;
            }
            finally {
                FlowLoaderUtils.cleanUpDir(tempDir);
            }
        }
        return false;
    }

    public void loadAllProjects() {
        List<Project> projects;
        try {
            projects = this.projectLoader.fetchAllActiveProjects();
        }
        catch (ProjectManagerException e) {
            throw new RuntimeException("Could not load projects from store.", (Throwable)((Object)e));
        }
        for (Project proj : projects) {
            this.projectsByName.put(proj.getName(), proj);
            this.projectsById.put(proj.getId(), proj);
        }
        for (Project proj : projects) {
            this.loadAllProjectFlows(proj);
        }
    }

    private void loadAllProjectFlows(Project project) {
        try {
            List<Flow> flows = this.projectLoader.fetchAllProjectFlows(project);
            HashMap<String, Flow> flowMap = new HashMap<String, Flow>();
            for (Flow flow : flows) {
                flowMap.put(flow.getId(), flow);
            }
            project.setFlows(flowMap);
        }
        catch (ProjectManagerException e) {
            throw new RuntimeException("Could not load projects flows from store.", (Throwable)((Object)e));
        }
    }

    public Props getProps() {
        return this.props;
    }

    public List<Project> getUserProjects(User user) {
        ArrayList<Project> array = new ArrayList<Project>();
        this.loadAllProjects();
        for (Project project : this.projectsById.values()) {
            Permission perm = project.getUserPermission(user);
            if (perm == null || !project.getCreateUser().equals(user.getUserId())) continue;
            array.add(project);
        }
        List<Project> newArray = array.stream().sorted(Comparator.comparing(Project::getName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
        return newArray;
    }

    public List<Project> getGroupProjects(User user) {
        ArrayList<Project> array = new ArrayList<Project>();
        this.loadAllProjects();
        for (Project project : this.projectsById.values()) {
            if (!project.hasGroupPermission(user, Permission.Type.READ)) continue;
            array.add(project);
        }
        List<Project> newArray = array.stream().sorted(Comparator.comparing(Project::getName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
        return newArray;
    }

    public List<Project> getUserProjectsByRegex(User user, String regexPattern) {
        Pattern pattern;
        this.loadAllProjects();
        ArrayList<Project> array = new ArrayList<Project>();
        try {
            pattern = Pattern.compile(regexPattern, 2);
        }
        catch (PatternSyntaxException e) {
            logger.error("Bad regex pattern " + regexPattern);
            return array;
        }
        for (Project project : this.projectsById.values()) {
            Permission perm = project.getUserPermission(user);
            if (perm == null || !perm.isPermissionSet(Permission.Type.ADMIN) && !perm.isPermissionSet(Permission.Type.READ) || !pattern.matcher(project.getName()).find() && !pattern.matcher(project.getDescription()).find() && !pattern.matcher(project.getCreateUser()).find()) continue;
            array.add(project);
        }
        List<Project> newArray = array.stream().sorted(Comparator.comparing(Project::getName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
        return newArray;
    }

    public List<Project> getProjects() {
        this.loadAllProjects();
        ArrayList<Project> projectList = new ArrayList<Project>(this.projectsById.values());
        List<Project> newArray = projectList.stream().sorted(Comparator.comparing(Project::getName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
        return newArray;
    }

    public List<Project> getProjectsByRegex(String regexPattern) {
        Pattern pattern;
        ArrayList<Project> allProjects = new ArrayList<Project>();
        try {
            pattern = Pattern.compile(regexPattern, 2);
        }
        catch (PatternSyntaxException e) {
            logger.error("Bad regex pattern " + regexPattern);
            return allProjects;
        }
        for (Project project : this.getProjects()) {
            if (!pattern.matcher(project.getName()).find()) continue;
            allProjects.add(project);
        }
        List<Project> newArray = allProjects.stream().sorted(Comparator.comparing(Project::getName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
        return newArray;
    }

    public Boolean isActiveProject(int id) {
        this.loadAllProjects();
        return this.projectsById.containsKey(id);
    }

    public Project getProject(String name) {
        Project fetchedProject = this.projectsByName.get(name);
        if (fetchedProject == null) {
            try {
                logger.info("Project " + name + " doesn't exist in cache, fetching from DB now.");
                fetchedProject = this.projectLoader.fetchProjectByName(name);
            }
            catch (ProjectManagerException e) {
                logger.error("Could not load project from store.", (Throwable)((Object)e));
            }
        }
        return fetchedProject;
    }

    public Project getProject(int id) {
        this.loadAllProjects();
        Project fetchedProject = this.projectsById.get(id);
        if (fetchedProject == null) {
            try {
                fetchedProject = this.projectLoader.fetchProjectById(id);
            }
            catch (ProjectManagerException e) {
                logger.error("Could not load project from store.", (Throwable)((Object)e));
            }
        }
        return fetchedProject;
    }

    public List<Flow> getRunningFlow(Project project) {
        return this.projectLoader.getRunningFlow(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project createProject(String projectName, String description, User creator) throws ProjectManagerException {
        Project newProject;
        if (projectName == null || projectName.trim().isEmpty()) {
            throw new ProjectManagerException("\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        if (description == null || description.trim().isEmpty()) {
            throw new ProjectManagerException("\u9879\u76ee\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        if (creator == null) {
            throw new ProjectManagerException("\u5fc5\u987b\u4f7f\u7528\u6709\u6548\u7528\u6237\u521b\u5efa\u9879\u76ee.");
        }
        if (!projectName.matches("[a-zA-Z][a-zA-Z_0-9|-]*")) {
            throw new ProjectManagerException("\u9879\u76ee\u540d\u79f0\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\uff0c\u540e\u9762\u8ddf\u7740\u4efb\u610f\u6570\u91cf\u7684\u5b57\u6bcd\uff0c\u6570\u5b57, '-' \u6216\u8005 '_'.");
        }
        ProjectManager projectManager = this;
        synchronized (projectManager) {
            if (this.projectsByName.containsKey(projectName)) {
                throw new ProjectManagerException("\u9879\u76ee\u5df2\u7ecf\u5b58\u5728.");
            }
            logger.info("Trying to create " + projectName + " by user " + creator.getUserId());
            newProject = this.projectLoader.createNewProject(projectName, description, creator);
            this.projectsByName.put(newProject.getName(), newProject);
            this.projectsById.put(newProject.getId(), newProject);
        }
        if (this.creatorDefaultPermissions) {
            this.projectLoader.updatePermission(newProject, creator.getUserId(), new Permission(Permission.Type.ADMIN), true);
            newProject.removeAllProxyUsers();
            for (String pUser : creator.getProxyUsers()) {
                newProject.addProxyUser(pUser);
            }
            try {
                this.updateProjectSetting(newProject);
            }
            catch (ProjectManagerException e) {
                e.printStackTrace();
                throw e;
            }
        }
        this.projectLoader.postEvent(newProject, ProjectLogEvent.EventType.CREATED, creator.getUserId(), null);
        return newProject;
    }

    public synchronized Project purgeProject(Project project, User deleter) throws ProjectManagerException {
        this.projectLoader.cleanOlderProjectVersion(project.getId(), project.getVersion() + 1, Collections.emptyList());
        this.projectLoader.postEvent(project, ProjectLogEvent.EventType.PURGE, deleter.getUserId(), String.format("Purged versions before %d", project.getVersion() + 1));
        return project;
    }

    public synchronized Project removeProject(Project project, User deleter) throws ProjectManagerException {
        this.loadAllProjects();
        this.projectLoader.removeProject(project, deleter.getUserId());
        this.projectLoader.postEvent(project, ProjectLogEvent.EventType.DELETED, deleter.getUserId(), null);
        this.projectsByName.remove(project.getName());
        this.projectsById.remove(project.getId());
        return project;
    }

    public void updateProjectDescription(Project project, String description, User modifier) throws ProjectManagerException {
        this.projectLoader.updateDescription(project, description, modifier.getUserId());
        this.projectLoader.postEvent(project, ProjectLogEvent.EventType.DESCRIPTION, modifier.getUserId(), "Description changed to " + description);
    }

    public List<ProjectLogEvent> getProjectEventLogs(Project project, int results, int skip) throws ProjectManagerException {
        return this.projectLoader.getProjectEvents(project, results, skip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Props getPropertiesFromFlowFile(Flow flow, String jobName, String flowFileName, int flowVersion) throws ProjectManagerException {
        File tempDir = null;
        Props props = null;
        try {
            tempDir = Files.createTempDir();
            File flowFile = this.projectLoader.getUploadedFlowFile(flow.getProjectId(), flow.getVersion(), flowFileName, flowVersion, tempDir);
            String path = jobName == null ? flow.getId() : flow.getId() + ":" + jobName;
            props = FlowLoaderUtils.getPropsFromYamlFile(path, flowFile);
        }
        catch (Exception e) {
            logger.error("Failed to get props from flow file. " + e);
        }
        finally {
            FlowLoaderUtils.cleanUpDir(tempDir);
        }
        return props;
    }

    public Props getProperties(Project project, Flow flow, String jobName, String source) throws ProjectManagerException {
        if (FlowLoaderUtils.isAzkabanFlowVersion20(flow.getAzkabanFlowVersion())) {
            return this.getPropertiesFromFlowFile(flow, jobName, source, 1);
        }
        return this.projectLoader.fetchProjectProperty(project, source);
    }

    public Props getJobOverrideProperty(Project project, Flow flow, String jobName, String source) throws ProjectManagerException {
        if (FlowLoaderUtils.isAzkabanFlowVersion20(flow.getAzkabanFlowVersion())) {
            int flowVersion = this.projectLoader.getLatestFlowVersion(flow.getProjectId(), flow.getVersion(), source);
            return this.getPropertiesFromFlowFile(flow, jobName, source, flowVersion);
        }
        return this.projectLoader.fetchProjectProperty(project, jobName + ".jor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJobOverrideProperty(Project project, Flow flow, Props prop, String jobName, String source, User modifier) throws ProjectManagerException {
        File tempDir = null;
        Props oldProps = null;
        if (FlowLoaderUtils.isAzkabanFlowVersion20(flow.getAzkabanFlowVersion())) {
            try {
                tempDir = Files.createTempDir();
                int flowVersion = this.projectLoader.getLatestFlowVersion(flow.getProjectId(), flow.getVersion(), source);
                File flowFile = this.projectLoader.getUploadedFlowFile(flow.getProjectId(), flow.getVersion(), source, flowVersion, tempDir);
                String path = flow.getId() + ":" + jobName;
                oldProps = FlowLoaderUtils.getPropsFromYamlFile(path, flowFile);
                FlowLoaderUtils.setPropsInYamlFile(path, flowFile, prop);
                this.projectLoader.uploadFlowFile(flow.getProjectId(), flow.getVersion(), flowFile, flowVersion + 1);
            }
            catch (Exception e) {
                logger.error("Failed to set job override property. " + e);
            }
            finally {
                FlowLoaderUtils.cleanUpDir(tempDir);
            }
        } else {
            prop.setSource(jobName + ".jor");
            oldProps = this.projectLoader.fetchProjectProperty(project, prop.getSource());
            if (oldProps == null) {
                this.projectLoader.uploadProjectProperty(project, prop);
            } else {
                this.projectLoader.updateProjectProperty(project, prop);
            }
        }
        String diffMessage = PropsUtils.getPropertyDiff((Props)oldProps, (Props)prop);
        this.projectLoader.postEvent(project, ProjectLogEvent.EventType.PROPERTY_OVERRIDE, modifier.getUserId(), diffMessage);
    }

    public void updateProjectSetting(Project project) throws ProjectManagerException {
        this.projectLoader.updateProjectSettings(project);
    }

    public void addProjectProxyUser(Project project, String proxyName, User modifier) throws ProjectManagerException {
        logger.info("User " + modifier.getUserId() + " adding proxy user " + proxyName + " to project " + project.getName());
        project.addProxyUser(proxyName);
        this.projectLoader.postEvent(project, ProjectLogEvent.EventType.PROXY_USER, modifier.getUserId(), "Proxy user " + proxyName + " is added to project.");
        this.updateProjectSetting(project);
    }

    public void removeProjectProxyUser(Project project, String proxyName, User modifier) throws ProjectManagerException {
        logger.info("User " + modifier.getUserId() + " removing proxy user " + proxyName + " from project " + project.getName());
        project.removeProxyUser(proxyName);
        this.projectLoader.postEvent(project, ProjectLogEvent.EventType.PROXY_USER, modifier.getUserId(), "Proxy user " + proxyName + " has been removed form the project.");
        this.updateProjectSetting(project);
    }

    public void updateProjectPermission(Project project, String name, Permission perm, boolean group, User modifier) throws ProjectManagerException {
        logger.info("User " + modifier.getUserId() + " updating permissions for project " + project.getName() + " for " + name + " " + perm.toString());
        this.projectLoader.updatePermission(project, name, perm, group);
        if (group) {
            this.projectLoader.postEvent(project, ProjectLogEvent.EventType.GROUP_PERMISSION, modifier.getUserId(), "Permission for group " + name + " set to " + perm.toString());
        } else {
            this.projectLoader.postEvent(project, ProjectLogEvent.EventType.USER_PERMISSION, modifier.getUserId(), "Permission for user " + name + " set to " + perm.toString());
        }
    }

    public void removeProjectPermission(Project project, String name, boolean group, User modifier) throws ProjectManagerException {
        logger.info("User " + modifier.getUserId() + " removing permissions for project " + project.getName() + " for " + name);
        this.projectLoader.removePermission(project, name, group);
        if (group) {
            this.projectLoader.postEvent(project, ProjectLogEvent.EventType.GROUP_PERMISSION, modifier.getUserId(), "Permission for group " + name + " removed.");
        } else {
            this.projectLoader.postEvent(project, ProjectLogEvent.EventType.USER_PERMISSION, modifier.getUserId(), "Permission for user " + name + " removed.");
        }
    }

    public ProjectFileHandler getProjectFileHandler(Project project, int version) throws ProjectManagerException {
        return this.azkabanProjectLoader.getProjectFile(project, version);
    }

    public Map<String, ValidationReport> uploadProject(Project project, File archive, String fileType, User uploader, Props additionalProps) throws ProjectManagerException, ExecutorManagerException {
        return this.azkabanProjectLoader.uploadProject(project, archive, fileType, uploader, additionalProps);
    }

    public Boolean checkFlowName(Project project, File archive, String fileType, Props additionalProps) {
        return this.azkabanProjectLoader.checkFlowName(project, archive, fileType, additionalProps);
    }

    public void updateFlow(Project project, Flow flow) throws ProjectManagerException {
        this.projectLoader.updateFlow(project, flow.getVersion(), flow);
    }

    public void postProjectEvent(Project project, ProjectLogEvent.EventType type, String user, String message) {
        this.projectLoader.postEvent(project, type, user, message);
    }

    public boolean loadProjectWhiteList() {
        if (this.props.containsKey((Object)"project.whitelist.xml.file")) {
            ProjectWhitelist.load(this.props);
            return true;
        }
        return false;
    }

    public void loadUserProjects(User user) {
        List<Project> projects;
        try {
            projects = this.getUserProjects(user);
        }
        catch (ProjectManagerException e) {
            throw new RuntimeException("Could not load projects from store.", (Throwable)((Object)e));
        }
        for (Project proj : projects) {
            this.projectsByName.put(proj.getName(), proj);
            this.projectsById.put(proj.getId(), proj);
        }
        for (Project proj : projects) {
            this.loadAllProjectFlows(proj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project createProject(String projectName, String description, String group, User creator) throws ProjectManagerException {
        Project newProject;
        String languageType = LoadJsonUtils.getLanguageType();
        Map<String, String> dataMap = languageType.equalsIgnoreCase("zh_CN") ? LoadJsonUtils.transJson("/com.webank.wedatasphere.schedulis.i18n.conf/azkaban-common-zh_CN.json", "azkaban.project.ProjectManager") : LoadJsonUtils.transJson("/com.webank.wedatasphere.schedulis.i18n.conf/azkaban-common-en_US.json", "azkaban.project.ProjectManager");
        if (projectName == null || projectName.trim().isEmpty()) {
            throw new ProjectManagerException(dataMap.get("noBlankProgramName"));
        }
        if (description == null || description.trim().isEmpty()) {
            throw new ProjectManagerException(dataMap.get("noBlankProgramDesc"));
        }
        if (creator == null) {
            throw new ProjectManagerException(dataMap.get("noInvalidUser"));
        }
        if (!projectName.matches("[a-zA-Z][a-zA-Z_0-9|-]*")) {
            throw new ProjectManagerException(dataMap.get("checkProgramName"));
        }
        ProjectManager projectManager = this;
        synchronized (projectManager) {
            if (this.projectsByName.containsKey(projectName)) {
                throw new ProjectManagerException(dataMap.get("hasExistProgram"));
            }
            logger.info("Trying to create " + projectName + " by user " + creator.getUserId());
            newProject = this.projectLoader.createNewProject(projectName, description, creator);
            this.projectsByName.put(newProject.getName(), newProject);
            this.projectsById.put(newProject.getId(), newProject);
        }
        if (this.creatorDefaultPermissions) {
            this.projectLoader.updatePermission(newProject, creator.getUserId(), new Permission(Permission.Type.ADMIN), !"".equals(group), group);
            newProject.removeAllProxyUsers();
            for (String pUser : creator.getProxyUsers()) {
                newProject.addProxyUser(pUser);
            }
            try {
                this.updateProjectSetting(newProject);
            }
            catch (ProjectManagerException e) {
                e.printStackTrace();
                throw e;
            }
        }
        this.projectLoader.postEvent(newProject, ProjectLogEvent.EventType.CREATED, creator.getUserId(), null);
        return newProject;
    }

    public PagingListStreamUtil<Project> getUserProjectsPage(int skip, int size, List<Project> userProjectList) {
        PagingListStreamUtil<Project> paging = new PagingListStreamUtil<Project>(userProjectList, size);
        paging.setCurPageNo(skip);
        return paging;
    }

    public PagingListStreamUtil<Project> getGroupProjectsPage(int skip, int size, List<Project> groupProjectList) {
        PagingListStreamUtil<Project> paging = new PagingListStreamUtil<Project>(groupProjectList, size);
        paging.setCurPageNo(skip);
        return paging;
    }

    public PagingListStreamUtil<Project> getAllProjectsPage(int skip, int size, List<Project> allProjectList) {
        PagingListStreamUtil<Project> paging = new PagingListStreamUtil<Project>(allProjectList, size);
        paging.setCurPageNo(skip);
        return paging;
    }

    public List<Project> getGroupProjectsByRegex(User user, String regexPattern) {
        Pattern pattern;
        ArrayList<Project> array = new ArrayList<Project>();
        try {
            pattern = Pattern.compile(regexPattern, 2);
        }
        catch (PatternSyntaxException e) {
            logger.error("Bad regex pattern " + regexPattern);
            return array;
        }
        for (Project project : this.projectsById.values()) {
            if (!project.hasGroupPermission(user, Permission.Type.READ) || !pattern.matcher(project.getName()).find()) continue;
            array.add(project);
        }
        List<Project> newArray = array.stream().sorted(Comparator.comparing(Project::getName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
        return newArray;
    }

    public void removeProjectPermission(Project project, String userId, User modifier) throws ProjectManagerException {
        logger.info("User " + modifier.getUserId() + " removing permissions for project " + project.getName() + " for " + userId);
        this.projectLoader.removeProjectPermission(project, userId);
        this.projectLoader.postEvent(project, ProjectLogEvent.EventType.USER_PERMISSION, modifier.getUserId(), "Permission for user " + userId + " removed.");
    }

    public List<Project> getUserAllProjects(User user, String orderOption) {
        this.loadAllProjects();
        ArrayList<Project> array = new ArrayList<Project>();
        List<Integer> projectIds = this.systemManager.getMaintainedProjects(user);
        boolean isDepartmentMaintainer = this.systemManager.isDepartmentMaintainer(user);
        for (Project project : this.projectsById.values()) {
            Permission permission = project.getUserPermission(user);
            Predicate<Permission> hasPermission = perm -> perm != null && (perm.isPermissionSet(Permission.Type.ADMIN) || perm.isPermissionSet(Permission.Type.READ));
            Predicate<User> isMaintained = u -> isDepartmentMaintainer && projectIds.contains(project.getId());
            if (!isMaintained.test(user) && !hasPermission.test(permission)) continue;
            array.add(project);
        }
        List<Object> newArray = new ArrayList();
        newArray = "orderUpdateTimeSort".equals(orderOption) ? array.stream().sorted(Comparator.comparing(Project::getLastModifiedTimestamp).reversed()).collect(Collectors.toList()) : array.stream().sorted(Comparator.comparing(Project::getName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
        return newArray;
    }

    public List<Project> getMaintainedProjects(User user, List<Integer> projectIds, String orderOption) {
        this.loadAllProjects();
        ArrayList<Project> array = new ArrayList<Project>();
        for (Project project : this.projectsById.values()) {
            Permission permission = project.getUserPermission(user);
            Predicate<Permission> hasPermission = perm -> perm != null && (perm.isPermissionSet(Permission.Type.ADMIN) || perm.isPermissionSet(Permission.Type.READ));
            Predicate<Project> isMaintained = proj -> projectIds.contains(proj.getId());
            if (!isMaintained.test(project) && !hasPermission.test(permission)) continue;
            array.add(project);
        }
        List<Object> newArray = new ArrayList();
        newArray = "orderUpdateTimeSort".equals(orderOption) ? array.stream().sorted(Comparator.comparing(Project::getLastModifiedTimestamp).reversed()).collect(Collectors.toList()) : array.stream().sorted(Comparator.comparing(Project::getName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
        return newArray;
    }

    public List<Project> getUserPersonProjectsByRegex(User user, String regexPattern, String orderOption) {
        Pattern pattern;
        ArrayList<Project> array = new ArrayList<Project>();
        try {
            pattern = Pattern.compile(regexPattern, 2);
        }
        catch (PatternSyntaxException e) {
            logger.error("Bad regex pattern " + regexPattern);
            return array;
        }
        this.loadAllProjects();
        for (Project project : this.projectsById.values()) {
            Permission perm = project.getUserPermission(user);
            if (perm == null || !project.getCreateUser().equals(user.getUserId()) || !pattern.matcher(project.getName()).find() && !pattern.matcher(project.getDescription()).find() && !pattern.matcher(project.getCreateUser()).find()) continue;
            array.add(project);
        }
        List<Object> newArray = new ArrayList();
        newArray = "orderUpdateTimeSort".equals(orderOption) ? array.stream().sorted(Comparator.comparing(Project::getLastModifiedTimestamp).reversed()).collect(Collectors.toList()) : array.stream().sorted(Comparator.comparing(Project::getName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
        return newArray;
    }

    public List<Project> getUserProjects(User user, String orderOption) {
        this.loadAllProjects();
        ArrayList<Project> array = new ArrayList<Project>();
        for (Project project : this.projectsById.values()) {
            Permission perm = project.getUserPermission(user);
            if (perm == null || !project.getCreateUser().equals(user.getUserId())) continue;
            array.add(project);
        }
        List<Object> newArray = new ArrayList();
        newArray = "orderUpdateTimeSort".equals(orderOption) ? array.stream().sorted(Comparator.comparing(Project::getLastModifiedTimestamp).reversed()).collect(Collectors.toList()) : array.stream().sorted(Comparator.comparing(Project::getName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
        return newArray;
    }

    public List<Project> getProjects(String orderOption) {
        this.loadAllProjects();
        ArrayList<Project> projectList = new ArrayList<Project>(this.projectsById.values());
        List<Object> newArray = new ArrayList();
        newArray = "orderUpdateTimeSort".equals(orderOption) ? projectList.stream().sorted(Comparator.comparing(Project::getLastModifiedTimestamp).reversed()).collect(Collectors.toList()) : projectList.stream().sorted(Comparator.comparing(Project::getName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
        return newArray;
    }

    public List<Project> getProjectsByRegex(String regexPattern, String orderOption) {
        Pattern pattern;
        ArrayList<Project> allProjects = new ArrayList<Project>();
        try {
            pattern = Pattern.compile(regexPattern, 2);
        }
        catch (PatternSyntaxException e) {
            logger.error("Bad regex pattern " + regexPattern);
            return allProjects;
        }
        for (Project project : this.getProjects()) {
            if (!pattern.matcher(project.getName()).find() && !pattern.matcher(project.getDescription()).find() && !pattern.matcher(project.getCreateUser()).find()) continue;
            allProjects.add(project);
        }
        List<Object> newArray = new ArrayList();
        newArray = "orderUpdateTimeSort".equals(orderOption) ? allProjects.stream().sorted(Comparator.comparing(Project::getLastModifiedTimestamp).reversed()).collect(Collectors.toList()) : allProjects.stream().sorted(Comparator.comparing(Project::getName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
        return newArray;
    }

    public List<Project> getUserProjectsByRegex(User user, String regexPattern, String orderOption) {
        Pattern pattern;
        ArrayList<Project> array = new ArrayList<Project>();
        try {
            pattern = Pattern.compile(regexPattern, 2);
        }
        catch (PatternSyntaxException e) {
            logger.error("Bad regex pattern " + regexPattern);
            return array;
        }
        this.loadAllProjects();
        for (Project project : this.projectsById.values()) {
            Permission perm = project.getUserPermission(user);
            if (perm == null || !perm.isPermissionSet(Permission.Type.ADMIN) && !perm.isPermissionSet(Permission.Type.READ) || !pattern.matcher(project.getName()).find() && !pattern.matcher(project.getDescription()).find() && !pattern.matcher(project.getCreateUser()).find()) continue;
            array.add(project);
        }
        List<Object> newArray = new ArrayList();
        newArray = "orderUpdateTimeSort".equals(orderOption) ? array.stream().sorted(Comparator.comparing(Project::getLastModifiedTimestamp).reversed()).collect(Collectors.toList()) : array.stream().sorted(Comparator.comparing(Project::getName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
        return newArray;
    }

    public List<Project> getMaintainedProjectsByRegex(User user, List<Integer> projectIds, String regexPattern, String orderOption) {
        Pattern pattern;
        ArrayList<Project> array = new ArrayList<Project>();
        try {
            pattern = Pattern.compile(regexPattern, 2);
        }
        catch (PatternSyntaxException e) {
            logger.error("Bad regex pattern " + regexPattern);
            return array;
        }
        this.loadAllProjects();
        for (Project project : this.projectsById.values()) {
            Permission permission = project.getUserPermission(user);
            Predicate<Permission> hasPermission = perm -> perm != null && (perm.isPermissionSet(Permission.Type.ADMIN) || perm.isPermissionSet(Permission.Type.READ));
            Predicate<Project> isMaintained = proj -> projectIds.contains(proj.getId());
            if (!isMaintained.test(project) && !hasPermission.test(permission) || !pattern.matcher(project.getName()).find() && !pattern.matcher(project.getDescription()).find() && !pattern.matcher(project.getCreateUser()).find()) continue;
            array.add(project);
        }
        List<Object> newArray = new ArrayList();
        newArray = "orderUpdateTimeSort".equals(orderOption) ? array.stream().sorted(Comparator.comparing(Project::getLastModifiedTimestamp).reversed()).collect(Collectors.toList()) : array.stream().sorted(Comparator.comparing(Project::getName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
        return newArray;
    }

    public List<Flow> getTodayCreateProjectNoRunNum(String username) throws ProjectManagerException {
        ArrayList<Flow> todayCreateFlowNoRunList = new ArrayList<Flow>();
        List<Project> todayCreateProjectList = this.projectLoader.getTodayCreateProjects(username);
        for (Project project : todayCreateProjectList) {
            List<Flow> flows = this.getProject(project.getId()).getFlows();
            for (Flow flow : flows) {
                int todayRunCount = this.projectLoader.getTodayRunFlow(project.getId(), flow.getId());
                if (todayRunCount != 0) continue;
                todayCreateFlowNoRunList.add(flow);
            }
        }
        return todayCreateFlowNoRunList;
    }

    public List<Map> getTodayCreateProjectNoRunFlowInfo(String username) throws ProjectManagerException {
        ArrayList<Map> todayCreateFlowNoRunFlowList = new ArrayList<Map>();
        List<Project> todayCreateProjectList = this.projectLoader.getTodayCreateProjects(username);
        for (Project project : todayCreateProjectList) {
            List<Flow> flows = this.getProject(project.getId()).getFlows();
            for (Flow flow : flows) {
                int todayRunCount = this.projectLoader.getTodayRunFlow(project.getId(), flow.getId());
                if (todayRunCount != 0) continue;
                HashMap<String, String> flowInfo = new HashMap<String, String>();
                flowInfo.put("ProjectName", project.getName());
                flowInfo.put("flowName", flow.getId());
                flowInfo.put("projectUser", project.getLastModifiedUser());
                todayCreateFlowNoRunFlowList.add(flowInfo);
            }
        }
        return todayCreateFlowNoRunFlowList;
    }
}

