/*
 * Decompiled with CFR 0.152.
 */
package azkaban.project;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutionReference;
import azkaban.executor.ExecutorLoader;
import azkaban.executor.ExecutorManagerException;
import azkaban.flow.Flow;
import azkaban.flow.Node;
import azkaban.project.DirectoryFlowLoader;
import azkaban.project.DirectoryYamlFlowLoader;
import azkaban.project.FlowLoader;
import azkaban.project.FlowLoaderFactory;
import azkaban.project.FlowLoaderUtils;
import azkaban.project.Project;
import azkaban.project.ProjectFileHandler;
import azkaban.project.ProjectLoader;
import azkaban.project.ProjectLogEvent;
import azkaban.project.ProjectManagerException;
import azkaban.project.validator.ValidationReport;
import azkaban.project.validator.ValidationStatus;
import azkaban.project.validator.XmlValidatorManager;
import azkaban.storage.StorageManager;
import azkaban.user.User;
import azkaban.utils.Pair;
import azkaban.utils.Props;
import azkaban.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AzkabanProjectLoader {
    private static final Logger log = LoggerFactory.getLogger(AzkabanProjectLoader.class);
    private static final String DIRECTORY_FLOW_REPORT_KEY = "Directory Flow";
    private final Props props;
    private final ProjectLoader projectLoader;
    private final StorageManager storageManager;
    private final FlowLoaderFactory flowLoaderFactory;
    private final File tempDir;
    private final int projectVersionRetention;
    private final ExecutorLoader executorLoader;

    @Inject
    AzkabanProjectLoader(Props props, ProjectLoader projectLoader, StorageManager storageManager, FlowLoaderFactory flowLoaderFactory, ExecutorLoader executorLoader) {
        this.props = Objects.requireNonNull(props, "Props is null");
        this.projectLoader = Objects.requireNonNull(projectLoader, "project Loader is null");
        this.storageManager = Objects.requireNonNull(storageManager, "Storage Manager is null");
        this.flowLoaderFactory = Objects.requireNonNull(flowLoaderFactory, "Flow Loader Factory is null");
        this.tempDir = new File(props.getString("project.temp.dir", "temp"));
        this.executorLoader = executorLoader;
        if (!this.tempDir.exists()) {
            log.info("Creating temp dir: " + this.tempDir.getAbsolutePath());
            this.tempDir.mkdirs();
        } else {
            log.info("Using temp dir: " + this.tempDir.getAbsolutePath());
        }
        this.projectVersionRetention = props.getInt("project.version.retention", 3);
        log.info("Project version retention is set to " + this.projectVersionRetention);
    }

    public Boolean checkFlowName(Project project, File archive, String fileType, Props additionalProps) {
        log.info("Check if the flow name is greater > 128 !!!");
        Props prop = new Props(this.props);
        prop.putAll(additionalProps);
        File file = null;
        file = this.unzipProject(archive, fileType);
        FlowLoader loader = this.flowLoaderFactory.createFlowLoader(file);
        loader.loadProjectFlow(project, file);
        Boolean flag = true;
        Map<String, Flow> flows = loader.getFlowMap();
        HashSet<String> flowIds = new HashSet<String>();
        for (Flow flow : flows.values()) {
            flowIds.add(flow.getId());
            if (flow.getNodes().size() <= 1) continue;
            for (Node node : flow.getNodes()) {
                flowIds.add(node.getId());
                if (node.getEmbeddedFlowId() == null) continue;
                this.getNodeId(project, node.getEmbeddedFlowId(), flowIds);
            }
        }
        for (String flowId : flowIds) {
            if (flowId.length() <= 128) continue;
            flag = false;
            break;
        }
        if (!flag.booleanValue()) {
            return false;
        }
        return true;
    }

    private void getNodeId(Project project, String nodeId, Set<String> flowIds) {
        Flow flow = project.getFlow(nodeId);
        if (flow != null) {
            for (Node node : flow.getNodes()) {
                flowIds.add(node.getId());
                if (node.getEmbeddedFlowId() == null) continue;
                this.getNodeId(project, node.getEmbeddedFlowId(), flowIds);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ValidationReport> uploadProject(Project project, File archive, String fileType, User uploader, Props additionalProps) throws ProjectManagerException, ExecutorManagerException {
        FlowLoader loader;
        Map<String, ValidationReport> reports;
        File file;
        block3: {
            Map<String, ValidationReport> map;
            log.info("Uploading files to " + project.getName());
            Props prop = new Props(this.props);
            prop.putAll(additionalProps);
            file = null;
            try {
                file = this.unzipProject(archive, fileType);
                reports = this.validateProject(project, archive, file, prop);
                loader = this.flowLoaderFactory.createFlowLoader(file);
                reports.put(DIRECTORY_FLOW_REPORT_KEY, loader.loadProjectFlow(project, file));
                if (this.isReportStatusValid(reports, project)) break block3;
                FlowLoaderUtils.cleanUpDir(file);
                map = reports;
            }
            catch (Throwable throwable) {
                FlowLoaderUtils.cleanUpDir(file);
                throw throwable;
            }
            FlowLoaderUtils.cleanUpDir(file);
            return map;
        }
        this.persistProject(project, loader, archive, file, uploader);
        FlowLoaderUtils.cleanUpDir(file);
        this.cleanUpProjectOldInstallations(project);
        return reports;
    }

    private File unzipProject(File archive, String fileType) throws ProjectManagerException {
        File file;
        if (fileType == null) {
            throw new ProjectManagerException("Unknown file type for " + archive.getName());
        }
        if ("zip".equals(fileType)) {
            try {
                file = this.unzipFile(archive);
            }
            catch (Exception e) {
                throw new ProjectManagerException("Error unzipping file:" + archive.getName() + ", Please check if there are Chinese characters in the file name.", e);
            }
        } else {
            throw new ProjectManagerException("Unsupported archive type for file " + archive.getName());
        }
        return file;
    }

    private Map<String, ValidationReport> validateProject(Project project, File archive, File file, Props prop) {
        prop.put("project.archive.file.path", archive.getAbsolutePath());
        XmlValidatorManager validatorManager = new XmlValidatorManager(prop);
        log.info("Validating project " + archive.getName() + " using the registered validators " + validatorManager.getValidatorsInfo().toString());
        return validatorManager.validate(project, file);
    }

    private boolean isReportStatusValid(Map<String, ValidationReport> reports, Project project) {
        ValidationStatus status = ValidationStatus.PASS;
        for (Map.Entry<String, ValidationReport> report : reports.entrySet()) {
            if (report.getValue().getStatus().compareTo(status) <= 0) continue;
            status = report.getValue().getStatus();
        }
        if (status == ValidationStatus.ERROR) {
            log.error("Error found in uploading to " + project.getName());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistProject(Project project, FlowLoader loader, File archive, File projectDir, User uploader) throws ProjectManagerException {
        Project project2 = project;
        synchronized (project2) {
            int newProjectVersion = this.projectLoader.getLatestProjectVersion(project) + 1;
            Map<String, Flow> flows = loader.getFlowMap();
            for (Flow flow : flows.values()) {
                flow.setProjectId(project.getId());
                flow.setVersion(newProjectVersion);
            }
            this.storageManager.uploadProject(project, newProjectVersion, archive, uploader);
            log.info("Uploading flow to db for project " + archive.getName());
            this.projectLoader.uploadFlows(project, newProjectVersion, flows.values());
            log.info("Changing project versions for project " + archive.getName());
            this.projectLoader.changeProjectVersion(project, newProjectVersion, uploader.getUserId());
            project.setFlows(flows);
            if (loader instanceof DirectoryFlowLoader) {
                DirectoryFlowLoader directoryFlowLoader = (DirectoryFlowLoader)loader;
                log.info("Uploading Job properties");
                this.projectLoader.uploadProjectProperties(project, new ArrayList<Props>(directoryFlowLoader.getJobPropsMap().values()));
                log.info("Uploading Props properties");
                this.projectLoader.uploadProjectProperties(project, directoryFlowLoader.getPropsList());
            } else if (loader instanceof DirectoryYamlFlowLoader) {
                this.uploadFlowFilesRecursively(projectDir, project, newProjectVersion);
            } else {
                throw new ProjectManagerException("Invalid type of flow loader.");
            }
            this.projectLoader.postEvent(project, ProjectLogEvent.EventType.UPLOADED, uploader.getUserId(), "Uploaded project files zip " + archive.getName());
        }
    }

    private void uploadFlowFilesRecursively(File projectDir, Project project, int newProjectVersion) {
        for (File file : projectDir.listFiles(new FlowLoaderUtils.SuffixFilter(".flow"))) {
            int newFlowVersion = this.projectLoader.getLatestFlowVersion(project.getId(), newProjectVersion, file.getName()) + 1;
            this.projectLoader.uploadFlowFile(project.getId(), newProjectVersion, file, newFlowVersion);
        }
        for (File file : projectDir.listFiles(new FlowLoaderUtils.DirFilter())) {
            this.uploadFlowFilesRecursively(file, project, newProjectVersion);
        }
    }

    private void cleanUpProjectOldInstallations(Project project) throws ProjectManagerException, ExecutorManagerException {
        log.info("Cleaning up old install files older than " + (project.getVersion() - this.projectVersionRetention));
        Map<Integer, Pair<ExecutionReference, ExecutableFlow>> unfinishedFlows = this.executorLoader.fetchUnfinishedFlowsMetadata();
        List<Integer> versionsWithUnfinishedExecutions = unfinishedFlows.values().stream().map(pair -> (ExecutableFlow)pair.getSecond()).filter(exflow -> exflow.getProjectId() == project.getId()).map(exflow -> exflow.getVersion()).collect(Collectors.toList());
        this.projectLoader.cleanOlderProjectVersion(project.getId(), project.getVersion() - this.projectVersionRetention, versionsWithUnfinishedExecutions);
        this.storageManager.cleanupProjectArtifacts(project.getId());
    }

    private File unzipFile(File archiveFile) throws IOException {
        ZipFile zipfile = new ZipFile(archiveFile);
        File unzipped = Utils.createTempDir((File)this.tempDir);
        Utils.unzip((ZipFile)zipfile, (File)unzipped);
        zipfile.close();
        return unzipped;
    }

    public ProjectFileHandler getProjectFile(Project project, int version) throws ProjectManagerException {
        if (version == -1) {
            version = this.projectLoader.getLatestProjectVersion(project);
        }
        return this.storageManager.getProjectFile(project.getId(), version);
    }
}

