/*
 * Decompiled with CFR 0.152.
 */
package azkaban.metrics;

import azkaban.metrics.MetricsManager;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CommonMetrics {
    public static final String FLOW_FAIL_METER_NAME = "flow-fail-meter";
    public static final String DISPATCH_FAIL_METER_NAME = "dispatch-fail-meter";
    public static final String DISPATCH_SUCCESS_METER_NAME = "dispatch-success-meter";
    public static final String SEND_EMAIL_FAIL_METER_NAME = "send-email-fail-meter";
    public static final String SEND_EMAIL_SUCCESS_METER_NAME = "send-email-success-meter";
    public static final String SUBMIT_FLOW_SUCCESS_METER_NAME = "submit-flow-success-meter";
    public static final String SUBMIT_FLOW_FAIL_METER_NAME = "submit-flow-fail-meter";
    public static final String SUBMIT_FLOW_SKIP_METER_NAME = "submit-flow-skip-meter";
    public static final String OOM_WAITING_JOB_COUNT_NAME = "OOM-waiting-job-count";
    public static final String QUEUE_WAIT_HISTOGRAM_NAME = "queue-wait-histogram";
    public static final String FLOW_SETUP_TIMER_NAME = "flow-setup-timer";
    private final AtomicLong OOMWaitingJobCount = new AtomicLong(0L);
    private final MetricsManager metricsManager;
    private Meter flowFailMeter;
    private Meter dispatchFailMeter;
    private Meter dispatchSuccessMeter;
    private Meter sendEmailFailMeter;
    private Meter sendEmailSuccessMeter;
    private Meter submitFlowSuccessMeter;
    private Meter submitFlowFailMeter;
    private Meter submitFlowSkipMeter;
    private Histogram queueWaitMeter;
    private Timer flowSetupTimer;

    @Inject
    public CommonMetrics(MetricsManager metricsManager) {
        this.metricsManager = metricsManager;
        this.setupAllMetrics();
    }

    private void setupAllMetrics() {
        this.flowFailMeter = this.metricsManager.addMeter(FLOW_FAIL_METER_NAME);
        this.dispatchFailMeter = this.metricsManager.addMeter(DISPATCH_FAIL_METER_NAME);
        this.dispatchSuccessMeter = this.metricsManager.addMeter(DISPATCH_SUCCESS_METER_NAME);
        this.sendEmailFailMeter = this.metricsManager.addMeter(SEND_EMAIL_FAIL_METER_NAME);
        this.sendEmailSuccessMeter = this.metricsManager.addMeter(SEND_EMAIL_SUCCESS_METER_NAME);
        this.submitFlowSuccessMeter = this.metricsManager.addMeter(SUBMIT_FLOW_SUCCESS_METER_NAME);
        this.submitFlowFailMeter = this.metricsManager.addMeter(SUBMIT_FLOW_FAIL_METER_NAME);
        this.submitFlowSkipMeter = this.metricsManager.addMeter(SUBMIT_FLOW_SKIP_METER_NAME);
        this.metricsManager.addGauge(OOM_WAITING_JOB_COUNT_NAME, this.OOMWaitingJobCount::get);
        this.queueWaitMeter = this.metricsManager.addHistogram(QUEUE_WAIT_HISTOGRAM_NAME);
        this.flowSetupTimer = this.metricsManager.addTimer(FLOW_SETUP_TIMER_NAME);
    }

    public void markFlowFail() {
        this.flowFailMeter.mark();
    }

    public void markDispatchFail() {
        this.dispatchFailMeter.mark();
    }

    public void markDispatchSuccess() {
        this.dispatchSuccessMeter.mark();
    }

    public void markSendEmailFail() {
        this.sendEmailFailMeter.mark();
    }

    public void markSendEmailSuccess() {
        this.sendEmailSuccessMeter.mark();
    }

    public void markSubmitFlowSuccess() {
        this.submitFlowSuccessMeter.mark();
    }

    public void markSubmitFlowSkip() {
        this.submitFlowSkipMeter.mark();
    }

    public void markSubmitFlowFail() {
        this.submitFlowFailMeter.mark();
    }

    public void incrementOOMJobWaitCount() {
        this.OOMWaitingJobCount.incrementAndGet();
    }

    public void decrementOOMJobWaitCount() {
        this.OOMWaitingJobCount.decrementAndGet();
    }

    public void addQueueWait(long time) {
        this.queueWaitMeter.update(time);
    }

    public Timer.Context getFlowSetupTimerContext() {
        return this.flowSetupTimer.time();
    }
}

