/*
 * Decompiled with CFR 0.152.
 */
package azkaban.metric;

import azkaban.metric.IMetric;
import azkaban.metric.MetricReportManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMetric<T>
implements IMetric<T>,
Cloneable {
    protected static final Logger logger = LoggerFactory.getLogger(MetricReportManager.class);
    protected String name;
    protected T value;
    protected String type;
    protected MetricReportManager metricManager;

    protected AbstractMetric(String metricName, String metricType, T initialValue, MetricReportManager manager) {
        this.name = metricName;
        this.type = metricType;
        this.value = initialValue;
        this.metricManager = manager;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValueType() {
        return this.type;
    }

    @Override
    public void updateMetricManager(MetricReportManager manager) {
        this.metricManager = manager;
    }

    @Override
    public IMetric<T> getSnapshot() throws CloneNotSupportedException {
        return (IMetric)this.clone();
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void notifyManager() {
        logger.debug(String.format("Notifying Manager for %s", this.getClass().getName()));
        try {
            this.metricManager.reportMetric(this);
        }
        catch (Throwable ex) {
            logger.error(String.format("Metric Manager is not set for %s metric", this.getClass().getName()), ex);
        }
    }
}

