/*
 * Decompiled with CFR 0.152.
 */
package azkaban.jobcallback;

import azkaban.jobcallback.JobCallbackStatusEnum;
import azkaban.utils.Props;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobCallbackValidator {
    private static final Logger logger = LoggerFactory.getLogger(JobCallbackValidator.class);

    public static int validate(String jobName, Props serverProps, Props jobProps, Collection<String> errors) {
        int maxNumCallback = serverProps.getInt("jobcallback.max_count", 3);
        int maxPostBodyLength = serverProps.getInt("jobcallback.max.body.length", 4096);
        int totalCallbackCount = 0;
        for (JobCallbackStatusEnum jobStatus : JobCallbackStatusEnum.values()) {
            totalCallbackCount += JobCallbackValidator.validateBasedOnStatus(jobProps, errors, jobStatus, maxNumCallback, maxPostBodyLength);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Found " + totalCallbackCount + " job callbacks for job " + jobName);
        }
        return totalCallbackCount;
    }

    private static int validateBasedOnStatus(Props jobProps, Collection<String> errors, JobCallbackStatusEnum jobStatus, int maxNumCallback, int maxPostBodyLength) {
        int callbackCount = 0;
        String jobCallBackUrl = "job.notification.status.sequence.url".replaceFirst("status", jobStatus.name().toLowerCase());
        String requestMethod = "job.notification.status.sequence.method".replaceFirst("status", jobStatus.name().toLowerCase());
        String httpBody = "job.notification.status.sequence.body".replaceFirst("status", jobStatus.name().toLowerCase());
        for (int i = 0; i <= maxNumCallback; ++i) {
            String callbackUrlKey = jobCallBackUrl.replaceFirst("sequence", Integer.toString(i));
            String callbackUrlValue = jobProps.get((Object)callbackUrlKey);
            if (i == 0) {
                if (callbackUrlValue == null) continue;
                errors.add("Sequence number starts at 1, not 0");
                continue;
            }
            if (callbackUrlValue == null || callbackUrlValue.length() == 0) break;
            String requestMethodKey = requestMethod.replaceFirst("sequence", Integer.toString(i));
            String methodValue = jobProps.getString(requestMethodKey, "GET");
            if ("POST".equals(methodValue)) {
                String postBodyKey = httpBody.replaceFirst("sequence", Integer.toString(i));
                String postBodyValue = jobProps.get((Object)postBodyKey);
                if (postBodyValue == null || postBodyValue.length() == 0) {
                    errors.add("No POST body was specified for job callback '" + callbackUrlValue + "'");
                    continue;
                }
                if (postBodyValue.length() > maxPostBodyLength) {
                    errors.add("POST body length is : " + postBodyValue.length() + " which is larger than supported length of " + maxPostBodyLength);
                    continue;
                }
                ++callbackCount;
                continue;
            }
            if ("GET".equals(methodValue)) {
                ++callbackCount;
                continue;
            }
            errors.add("Unsupported request method: " + methodValue + " Only POST and GET are supported");
        }
        return callbackCount;
    }
}

