/*
 * Decompiled with CFR 0.152.
 */
package azkaban.jobExecutor;

import azkaban.ServiceProvider;
import azkaban.jobExecutor.AbstractProcessJob;
import azkaban.jobExecutor.utils.process.AzkabanProcess;
import azkaban.jobExecutor.utils.process.AzkabanProcessBuilder;
import azkaban.metrics.CommonMetrics;
import azkaban.utils.ExecuteAsUser;
import azkaban.utils.Pair;
import azkaban.utils.Props;
import azkaban.utils.SystemMemoryInfo;
import com.google.common.annotations.VisibleForTesting;
import com.webank.wedatasphere.schedulis.common.utils.HadoopJobUtils;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class ProcessJob
extends AbstractProcessJob {
    public static final String COMMAND = "command";
    public static final String AZKABAN_MEMORY_CHECK = "azkaban.memory.check";
    @Deprecated
    public static final String NATIVE_LIB_FOLDER = "azkaban.native.lib";
    public static final String EXECUTE_AS_USER = "execute.as.user";
    public static final String KRB5CCNAME = "KRB5CCNAME";
    private static final Duration KILL_TIME = Duration.ofSeconds(30L);
    private static final String MEMCHECK_ENABLED = "memCheck.enabled";
    private static final String CHOWN = "chown";
    private static final String CREATE_FILE = "touch";
    private static final int SUCCESSFUL_EXECUTION = 0;
    private static final String TEMP_FILE_NAME = "user_can_write";
    private final CommonMetrics commonMetrics = ServiceProvider.SERVICE_PROVIDER.getInstance(CommonMetrics.class);
    private volatile AzkabanProcess process;
    private volatile boolean killed = false;
    private volatile boolean success;

    public ProcessJob(String jobId, Props sysProps, Props jobProps, Logger log) {
        super(jobId, sysProps, jobProps, log);
    }

    public static String[] partitionCommandLine(String command) {
        ArrayList<String> commands = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer(command.length());
        boolean isApos = false;
        boolean isQuote = false;
        block5: for (int index = 0; index < command.length(); ++index) {
            char c = command.charAt(index);
            switch (c) {
                case ' ': {
                    if (!isQuote && !isApos) {
                        String arg = buffer.toString();
                        buffer = new StringBuffer(command.length() - index);
                        if (arg.length() <= 0) continue block5;
                        commands.add(arg);
                        continue block5;
                    }
                    buffer.append(c);
                    continue block5;
                }
                case '\'': {
                    if (!isQuote) {
                        isApos = !isApos;
                        continue block5;
                    }
                    buffer.append(c);
                    continue block5;
                }
                case '\"': {
                    if (!isApos) {
                        isQuote = !isQuote;
                        continue block5;
                    }
                    buffer.append(c);
                    continue block5;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        if (buffer.length() > 0) {
            String arg = buffer.toString();
            commands.add(arg);
        }
        return commands.toArray(new String[commands.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        try {
            this.resolveProps();
        }
        catch (Exception e) {
            this.handleError("Bad property definition! " + e.getMessage(), e);
        }
        if (this.sysProps.getBoolean(MEMCHECK_ENABLED, true) && this.jobProps.getBoolean(AZKABAN_MEMORY_CHECK, true)) {
            Pair<Long, Long> memPair = this.getProcMemoryRequirement();
            long xms = memPair.getFirst();
            long xmx = memPair.getSecond();
            String oomMsg = String.format("Cannot request memory (Xms %d kb, Xmx %d kb) from system for job %s", xms, xmx, this.getId());
            boolean isMemGranted = true;
            SystemMemoryInfo memInfo = ServiceProvider.SERVICE_PROVIDER.getInstance(SystemMemoryInfo.class);
            for (int attempt = 1; attempt <= 720; ++attempt) {
                isMemGranted = memInfo.canSystemGrantMemory(xmx);
                if (isMemGranted) {
                    this.info(String.format("Memory granted for job %s", this.getId()));
                    if (attempt <= 1) break;
                    this.commonMetrics.decrementOOMJobWaitCount();
                    break;
                }
                if (attempt >= 720) continue;
                this.info(String.format(oomMsg + ", sleep for %s secs and retry, attempt %s of %s", TimeUnit.MILLISECONDS.toSeconds(60000L), attempt, 720));
                if (attempt == 1) {
                    this.commonMetrics.incrementOOMJobWaitCount();
                }
                ProcessJob processJob = this;
                synchronized (processJob) {
                    try {
                        this.wait(60000L);
                    }
                    catch (InterruptedException e) {
                        this.info(String.format("Job %s interrupted while waiting for memory check retry", this.getId()));
                    }
                }
                if (!this.killed) continue;
                this.commonMetrics.decrementOOMJobWaitCount();
                this.info(String.format("Job %s was killed while waiting for memory check retry", this.getId()));
                return;
            }
            if (!isMemGranted) {
                this.commonMetrics.decrementOOMJobWaitCount();
                this.handleError(oomMsg, null);
            }
        }
        List<String> commands = null;
        try {
            commands = this.getCommandList();
        }
        catch (Exception e) {
            this.handleError("Job set up failed " + e.getCause(), e);
        }
        long startMs = System.currentTimeMillis();
        if (commands == null) {
            this.handleError("There are no commands to execute", null);
        }
        this.info(commands.size() + " commands to execute.");
        File[] propFiles = this.initPropsFiles();
        this.initOverAllPropsFiles();
        Map<String, String> envVars = this.getEnvironmentVariables();
        envVars.put(KRB5CCNAME, this.getKrb5ccname(this.jobProps));
        String executeAsUserBinaryPath = null;
        String effectiveUser = null;
        boolean isExecuteAsUser = this.sysProps.getBoolean(EXECUTE_AS_USER, true);
        HashSet<String> blackListedUsers = new HashSet<String>(Arrays.asList(this.sysProps.getString("azkaban.server.blacklist.users", "root,azkaban").split(",")));
        if (isExecuteAsUser) {
            String nativeLibFolder = this.sysProps.getString(NATIVE_LIB_FOLDER);
            executeAsUserBinaryPath = String.format("%s/%s", nativeLibFolder, "execute-as-user");
            effectiveUser = this.getEffectiveUser(this.jobProps);
            if (blackListedUsers.contains(effectiveUser)) {
                throw new RuntimeException(String.format("Not permitted to proxy as '%s' through Azkaban", effectiveUser));
            }
            if (!this.canWriteInCurrentWorkingDirectory(effectiveUser)) {
                this.info("Changing current working directory ownership");
                this.assignUserFileOwnership(effectiveUser, this.getWorkingDirectory());
            }
            for (File propFile : propFiles) {
                this.info("Changing properties files ownership");
                this.assignUserFileOwnership(effectiveUser, propFile.getAbsolutePath());
            }
        }
        for (String command : commands) {
            AzkabanProcessBuilder builder = null;
            if (isExecuteAsUser) {
                String[] cmd = new String[]{executeAsUserBinaryPath, effectiveUser, command};
                this.info("Command: " + command);
                builder = new AzkabanProcessBuilder(cmd).setEnv(envVars).setWorkingDir(this.getCwd()).setLogger(this.getLog()).enableExecuteAsUser().setExecuteAsUserBinaryPath(executeAsUserBinaryPath).setEffectiveUser(effectiveUser);
            } else {
                this.info("Command: " + command);
                builder = new AzkabanProcessBuilder(ProcessJob.partitionCommandLine(command)).setEnv(envVars).setWorkingDir(this.getCwd()).setLogger(this.getLog());
            }
            if (builder.getEnv().size() > 0) {
                this.info("Environment variables: " + builder.getEnv());
            }
            this.info("Working directory: " + builder.getWorkingDir());
            this.logJobProperties();
            ProcessJob cmd = this;
            synchronized (cmd) {
                if (this.killed) {
                    this.info("The job is killed. Abort. No job process created.");
                    return;
                }
                this.process = builder.build();
            }
            try {
                this.process.run();
                this.success = true;
                this.info("Process completed " + (this.success ? "successfully" : "unsuccessfully") + " in " + (System.currentTimeMillis() - startMs) / 1000L + " seconds.");
            }
            catch (Throwable e) {
                try {
                    for (File file : propFiles) {
                        if (file == null || !file.exists()) continue;
                        file.delete();
                    }
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    this.info("Process completed " + (this.success ? "successfully" : "unsuccessfully") + " in " + (System.currentTimeMillis() - startMs) / 1000L + " seconds.");
                    throw throwable;
                }
            }
        }
        this.generateProperties(propFiles[1]);
    }

    private String getKrb5ccname(Props jobProps) {
        String effectiveUser = this.getEffectiveUser(jobProps);
        String projectName = jobProps.getString("azkaban.flow.projectname").replace(" ", "_");
        String flowId = jobProps.getString("azkaban.flow.flowid").replace(" ", "_");
        String jobId = jobProps.getString("azkaban.job.id").replace(" ", "_");
        String execId = jobProps.getString("azkaban.flow.execid");
        String krb5ccname = String.format("/tmp/krb5cc__%s__%s__%s__%s__%s", projectName, flowId, jobId, execId, effectiveUser);
        return krb5ccname;
    }

    private String getEffectiveUser(Props jobProps) {
        String effectiveUser = null;
        if (jobProps.containsKey((Object)"user.to.proxy")) {
            effectiveUser = jobProps.getString("user.to.proxy");
        } else if (jobProps.containsKey((Object)"azkaban.flow.submituser")) {
            effectiveUser = jobProps.getString("azkaban.flow.submituser");
        } else {
            throw new RuntimeException("Internal Error: No user.to.proxy or submit.user in the jobProps");
        }
        this.info("effective user is: " + effectiveUser);
        return effectiveUser;
    }

    private boolean canWriteInCurrentWorkingDirectory(String effectiveUser) throws IOException {
        ExecuteAsUser executeAsUser = new ExecuteAsUser(this.sysProps.getString(NATIVE_LIB_FOLDER));
        List<String> checkIfUserCanWriteCommand = Arrays.asList(CREATE_FILE, this.getWorkingDirectory() + "/" + TEMP_FILE_NAME);
        int result = executeAsUser.execute(effectiveUser, checkIfUserCanWriteCommand);
        return result == 0;
    }

    private void assignUserFileOwnership(String effectiveUser, String fileName) throws Exception {
        ExecuteAsUser executeAsUser = new ExecuteAsUser(this.sysProps.getString(NATIVE_LIB_FOLDER));
        String groupName = this.sysProps.getString("azkaban.group.name", effectiveUser);
        List<String> changeOwnershipCommand = Arrays.asList(CHOWN, effectiveUser + ":" + groupName, fileName);
        this.info("\u4fee\u6539\u5de5\u4f5c\u76ee\u5f55\u540d\uff1a " + fileName + " \u6267\u884c\u7528\u6237\uff1a " + effectiveUser + " \u7528\u6237\u7684\u7ec4\u540d\uff1a" + groupName + ".");
        int result = executeAsUser.execute("root", changeOwnershipCommand);
        if (result != 0) {
            this.handleError("\u4f7f\u7528chown\u547d\u4ee4\u4fee\u6539\u5f53\u524d\u5de5\u4f5c\u76ee\u5f55\u6743\u9650\u5931\u8d25.\u8bf7\u68c0\u67e5\u6267\u884c\u7528\u6237\u6216\u7ec4\u662f\u5426\u6709\u76f8\u5e94\u7684\u6743\u9650\u3002 \u9519\u8bef\u4ee3\u7801: " + Integer.toString(result), null);
        }
    }

    protected Pair<Long, Long> getProcMemoryRequirement() throws Exception {
        return new Pair<Long, Long>(0L, 0L);
    }

    protected void handleError(String errorMsg, Exception e) throws Exception {
        this.error(errorMsg);
        if (e != null) {
            throw new Exception(errorMsg, e);
        }
        throw new Exception(errorMsg);
    }

    protected List<String> getCommandList() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.jobProps.getString(COMMAND));
        int i = 1;
        while (this.jobProps.containsKey((Object)("command." + i))) {
            commands.add(this.jobProps.getString("command." + i));
            ++i;
        }
        return commands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws InterruptedException {
        ProcessJob processJob = this;
        synchronized (processJob) {
            this.killed = true;
            this.notify();
            if (this.process == null) {
                return;
            }
        }
        try {
            this.process.awaitStartup();
            this.warn("Kill with signal TERM failed. Killing with KILL signal.");
            this.process.hardKill();
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        finally {
            if (this.jobProps.get((Object)"type").equals(COMMAND)) {
                String logFilePath = this.jobProps.get((Object)"azkaban.job.log.file");
                this.info("log file path is: " + logFilePath);
                if (StringUtils.isBlank((String)logFilePath)) {
                    this.info("log file does not exist.");
                    return;
                }
                HadoopJobUtils.killAllHadoopJobs(logFilePath, this.getLog());
                HadoopJobUtils.killBdpClientJob(this.getCommandList(), logFilePath, this.getLog(), this.sysProps);
            }
        }
    }

    @Override
    public double getProgress() {
        return this.process != null && this.process.isComplete() ? 1.0 : 0.0;
    }

    public int getProcessId() {
        return this.process.getProcessId();
    }

    @VisibleForTesting
    boolean isSuccess() {
        return this.success;
    }

    @VisibleForTesting
    AzkabanProcess getProcess() {
        return this.process;
    }

    public String getPath() {
        return this._jobPath == null ? "" : this._jobPath;
    }
}

