/*
 * Decompiled with CFR 0.152.
 */
package azkaban.jobExecutor;

import azkaban.jobExecutor.Job;
import azkaban.utils.Props;
import org.slf4j.Logger;

public abstract class AbstractJob
implements Job {
    public static final String JOB_TYPE = "type";
    public static final String JOB_CLASS = "job.class";
    public static final String JOB_PATH = "job.path";
    public static final String JOB_FULLPATH = "job.fullpath";
    public static final String JOB_ID = "job.id";
    private final String _id;
    private final Logger _log;
    private volatile double _progress;

    protected AbstractJob(String id, Logger log) {
        this._id = id;
        this._log = log;
        this._progress = 0.0;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public double getProgress() throws Exception {
        return this._progress;
    }

    public void setProgress(double progress) {
        this._progress = progress;
    }

    @Override
    public void cancel() throws Exception {
        throw new RuntimeException("Job " + this._id + " does not support cancellation!");
    }

    public Logger getLog() {
        return this._log;
    }

    public void debug(String message) {
        this._log.debug(message);
    }

    public void debug(String message, Throwable t) {
        this._log.debug(message, t);
    }

    public void info(String message) {
        this._log.info(message);
    }

    public void info(String message, Throwable t) {
        this._log.info(message, t);
    }

    public void warn(String message) {
        this._log.warn(message);
    }

    public void warn(String message, Throwable t) {
        this._log.warn(message, t);
    }

    public void error(String message) {
        this._log.error(message);
    }

    public void error(String message, Throwable t) {
        this._log.error(message, t);
    }

    @Override
    public Props getJobGeneratedProperties() {
        return new Props();
    }

    @Override
    public abstract void run() throws Exception;

    @Override
    public boolean isCanceled() {
        return false;
    }
}

