/*
 * Decompiled with CFR 0.152.
 */
package azkaban.jmx;

import azkaban.executor.ExecutorManager;
import azkaban.jmx.JmxExecutorManagerMBean;
import java.util.ArrayList;
import java.util.List;

public class JmxExecutorManager
implements JmxExecutorManagerMBean {
    private final ExecutorManager manager;

    public JmxExecutorManager(ExecutorManager manager) {
        this.manager = manager;
    }

    @Override
    public int getNumRunningFlows() {
        return this.manager.getRunningFlows().size();
    }

    @Override
    public String getExecutorThreadState() {
        return this.manager.getExecutorManagerThreadState().toString();
    }

    @Override
    public String getExecutorThreadStage() {
        return this.manager.getExecutorThreadStage();
    }

    @Override
    public boolean isThreadActive() {
        return this.manager.isExecutorManagerThreadActive();
    }

    @Override
    public Long getLastThreadCheckTime() {
        return this.manager.getLastExecutorManagerThreadCheckTime();
    }

    @Override
    public List<String> getPrimaryExecutorHostPorts() {
        return new ArrayList<String>(this.manager.getPrimaryServerHosts());
    }

    @Override
    public String getRunningFlows() {
        return this.manager.getRunningFlowIds();
    }

    @Override
    public boolean isQueueProcessorActive() {
        return this.manager.isQueueProcessorThreadActive();
    }

    @Override
    public String getQueuedFlows() {
        return this.manager.getQueuedFlowIds();
    }

    @Override
    public String getQueueProcessorThreadState() {
        return this.manager.getQueueProcessorThreadState().toString();
    }

    @Override
    public List<String> getAvailableExecutorComparatorNames() {
        return new ArrayList<String>(this.manager.getAvailableExecutorComparatorNames());
    }

    @Override
    public List<String> getAvailableExecutorFilterNames() {
        return new ArrayList<String>(this.manager.getAvailableExecutorFilterNames());
    }

    @Override
    public long getLastSuccessfulExecutorInfoRefresh() {
        return this.manager.getLastSuccessfulExecutorInfoRefresh();
    }
}

