/*
 * Decompiled with CFR 0.152.
 */
package azkaban.history;

import azkaban.ServiceProvider;
import azkaban.alert.Alerter;
import azkaban.executor.AlerterHolder;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutorLoader;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.JdbcExecutorLoader;
import azkaban.executor.Status;
import azkaban.history.ExecutionRecover;
import azkaban.history.GroupTask;
import azkaban.project.Project;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoverTrigger {
    private static Logger logger = LoggerFactory.getLogger(RecoverTrigger.class);
    private boolean hasTaskFailed = false;
    private List<GroupTask> group;
    private List<Map<String, String>> repeatList;
    private int taskSize;
    private boolean errorContinue;
    private int triggerId;
    private int projectId;
    private String flowId;
    private ExecutionRecover executionRecover;
    private final ExecutorLoader loader = ServiceProvider.SERVICE_PROVIDER.getInstance(JdbcExecutorLoader.class);
    private final AlerterHolder alerterHolder = ServiceProvider.SERVICE_PROVIDER.getInstance(AlerterHolder.class);
    private Project project;

    public RecoverTrigger(ExecutionRecover executionRecover) {
        this.repeatList = (List)executionRecover.getRepeatOption().get("repeatTimeList");
        this.taskSize = executionRecover.getTaskSize();
        this.group = new ArrayList<GroupTask>(this.taskSize);
        this.errorContinue = executionRecover.getRecoverErrorOption().equals("errorCountion");
        this.triggerId = executionRecover.getRecoverId();
        this.projectId = executionRecover.getProjectId();
        this.flowId = executionRecover.getFlowId();
        this.executionRecover = executionRecover;
        this.createGroupTask();
    }

    public int getTriggerId() {
        return this.triggerId;
    }

    private void createGroupTask() {
        int repeatSize = this.repeatList.size();
        if (repeatSize < this.taskSize) {
            this.group.add(new GroupTask(this.repeatList, this.errorContinue));
        } else {
            int len = this.repeatList.size() / this.taskSize;
            int remainder = this.repeatList.size() % this.taskSize;
            int lastIndex = 0;
            for (int i = 0; i < this.taskSize; ++i) {
                if (i < this.taskSize - 1) {
                    this.group.add(new GroupTask(this.repeatList.subList(lastIndex, lastIndex + len), this.errorContinue));
                    lastIndex += len;
                    continue;
                }
                this.group.add(new GroupTask(this.repeatList.subList(lastIndex, lastIndex + len + remainder), this.errorContinue));
            }
        }
    }

    public List<GroupTask> getGroup() {
        return this.group;
    }

    public void setGroup(List<GroupTask> group) {
        this.group = group;
    }

    public boolean expireConditionMet() {
        if (this.hasTaskFailed && !this.errorContinue) {
            logger.info("errorStop, stop history recover.");
            this.executionRecover.setEndTime(System.currentTimeMillis());
            this.executionRecover.setRecoverStatus(Status.FAILED);
            this.alert();
            return true;
        }
        List finishedTask = this.repeatList.stream().filter(x -> {
            Status status = Status.fromInteger(Integer.valueOf((String)x.get("recoverStatus")));
            return Status.isStatusFinished(status);
        }).collect(Collectors.toList());
        if (finishedTask != null && finishedTask.size() == this.repeatList.size()) {
            logger.info("stop history recover.");
            this.executionRecover.setEndTime(System.currentTimeMillis());
            this.updateRecoverStatus();
            this.alert();
            return true;
        }
        return false;
    }

    private void alert() {
        if (this.executionRecover.isFinishedAlert()) {
            logger.info("history recover alert.");
            Alerter mailAlerter = this.alerterHolder.get("email");
            if (null == mailAlerter) {
                mailAlerter = this.alerterHolder.get("default");
            }
            try {
                this.executionRecover.setProjectName(this.project.getName());
                mailAlerter.alertOnHistoryRecoverFinish(this.executionRecover);
            }
            catch (Exception e) {
                logger.error("history recover alert failed", (Throwable)e);
            }
        }
    }

    private void updateRecoverStatus() {
        List failedTask = this.repeatList.stream().filter(x -> !((String)x.get("recoverStatus")).equals("50")).collect(Collectors.toList());
        if (failedTask.size() == 0) {
            logger.info("set history recover status to SUCCEEDED");
            this.executionRecover.setRecoverStatus(Status.SUCCEEDED);
        } else if (failedTask.size() != this.repeatList.size()) {
            logger.info("set history recover status to FAILED_SUCCEEDED");
            this.executionRecover.setRecoverStatus(Status.FAILED_SUCCEEDED);
        } else {
            logger.info("set history recover status to FAILED");
            this.executionRecover.setRecoverStatus(Status.FAILED);
        }
    }

    public void updateTaskStatus() {
        List tasks = this.repeatList.stream().filter(item -> item.containsKey("isSubmit") && ((String)item.get("recoverStatus")).equals("20") || ((String)item.get("recoverStatus")).equals("30")).collect(Collectors.toList());
        for (Map task : tasks) {
            try {
                int excId = Integer.valueOf((String)task.get("exeId"));
                ExecutableFlow executableFlow = this.loader.fetchExecutableFlow(excId);
                Status status = executableFlow.getStatus();
                if (!Status.isStatusFinished(status)) continue;
                task.put("recoverStatus", String.valueOf(executableFlow.getStatus().getNumVal()));
                if (status.equals((Object)Status.SUCCEEDED)) continue;
                logger.warn("There are tasks that failed to execute.");
                this.hasTaskFailed = true;
            }
            catch (ExecutorManagerException em) {
                logger.error("update task status failed.", (Throwable)em);
            }
        }
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    public ExecutionRecover getExecutionRecover() {
        return this.executionRecover;
    }

    public void setExecutionRecover(ExecutionRecover executionRecover) {
        this.executionRecover = executionRecover;
    }

    public void setExecutionRecoverStartTime() {
        if (this.executionRecover.getStartTime() == -1L) {
            this.executionRecover.setRecoverStatus(Status.RUNNING);
            this.executionRecover.setStartTime(System.currentTimeMillis());
        }
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public String toString() {
        return "RecoverTrigger{triggerId=" + this.triggerId + ", taskSize=" + this.taskSize + ", projectId=" + this.projectId + ", flowId='" + this.flowId + '\'' + '}';
    }
}

