/*
 * Decompiled with CFR 0.152.
 */
package azkaban.history;

import azkaban.db.DatabaseOperator;
import azkaban.db.EncodingType;
import azkaban.db.SQLTransaction;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.Status;
import azkaban.history.ExecutionRecover;
import azkaban.utils.GZIPUtils;
import azkaban.utils.JSONUtils;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.dbutils.ResultSetHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ExecutionRecoverDao {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionRecoverDao.class);
    private final DatabaseOperator dbOperator;

    @Inject
    public ExecutionRecoverDao(DatabaseOperator dbOperator) {
        this.dbOperator = dbOperator;
    }

    public synchronized Integer uploadExecutableRecoverFlow(ExecutionRecover recover) throws ExecutorManagerException {
        String INSERT_EXECUTABLE_RECOVER_FLOW = "INSERT INTO execution_recover_flows (recover_status, recover_start_time, recover_end_time, ex_interval, now_exec_id, project_id, flow_id, submit_user, submit_time, update_time ) values (?,?,?,?,?,?,?,?,?,?)";
        long submitTime = System.currentTimeMillis();
        SQLTransaction insertAndGetLastID = transOperator -> {
            transOperator.update("INSERT INTO execution_recover_flows (recover_status, recover_start_time, recover_end_time, ex_interval, now_exec_id, project_id, flow_id, submit_user, submit_time, update_time ) values (?,?,?,?,?,?,?,?,?,?)", new Object[]{recover.getRecoverStatus().getNumVal(), recover.getRecoverStartTime(), recover.getRecoverEndTime(), recover.getExInterval(), recover.getNowExecutionId(), recover.getProjectId(), recover.getFlowId(), recover.getSubmitUser(), submitTime, submitTime});
            transOperator.getConnection().commit();
            return transOperator.getLastInsertId();
        };
        try {
            long id = (Long)this.dbOperator.transaction(insertAndGetLastID);
            logger.info("History Recover given recoverid: {}, given id: {}", (Object)recover.getRecoverId(), (Object)id);
            recover.setRecoverId((int)id);
            this.updateExecutableRecoverFlow(recover);
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error creating History Recover.", e);
        }
        return recover.getRecoverId();
    }

    public void updateExecutableRecoverFlow(ExecutionRecover recover) throws ExecutorManagerException {
        this.updateExecutableRecoverFlow(recover, EncodingType.GZIP);
    }

    private void updateExecutableRecoverFlow(ExecutionRecover recover, EncodingType encType) throws ExecutorManagerException {
        String UPDATE_EXECUTABLE_RECOVER_FLOW_DATA = "UPDATE execution_recover_flows  SET recover_status=?, now_exec_id=?, update_time=?, start_time=?, end_time=?, enc_type=?, recover_data=?  WHERE recover_id=? ";
        String json = JSONUtils.toJSON(recover.toObject());
        byte[] data = null;
        try {
            byte[] stringData;
            data = stringData = json.getBytes("UTF-8");
            if (encType == EncodingType.GZIP) {
                data = GZIPUtils.gzipBytes(stringData);
            }
        }
        catch (IOException e) {
            throw new ExecutorManagerException("Error encoding the execution recover flow.");
        }
        try {
            this.dbOperator.update("UPDATE execution_recover_flows  SET recover_status=?, now_exec_id=?, update_time=?, start_time=?, end_time=?, enc_type=?, recover_data=?  WHERE recover_id=? ", new Object[]{recover.getRecoverStatus().getNumVal(), recover.getNowExecutionId(), recover.getUpdateTime(), recover.getStartTime(), recover.getEndTime(), encType.getNumVal(), data, recover.getRecoverId()});
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error updating History Recover.", e);
        }
    }

    public ExecutionRecover getHistoryRecoverFlows(Integer recoverId) throws ExecutorManagerException {
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(recoverId);
        try {
            List recoverList = (List)this.dbOperator.query(FetchExecutionRecoverFlowsWithSubmitInfo.RUNNING_PAGE_KILL_RECOVER_DATA, (ResultSetHandler)new FetchExecutionRecoverFlowsWithSubmitInfo(), params.toArray());
            if (recoverList.size() > 0) {
                return (ExecutionRecover)recoverList.get(0);
            }
            return null;
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error fetching history recover flows", e);
        }
    }

    List<ExecutionRecover> listHistoryRecoverFlowByFlowId(String flowId, String projectId) throws ExecutorManagerException {
        String query = "select exec_id, enc_type, flow_data from execution_flows where flow_id = ? and project_id = ? and repeat_id != '' order by start_time DESC limit 1 ";
        ArrayList<String> params = new ArrayList<String>();
        params.add(flowId);
        params.add(projectId);
        try {
            return (List)this.dbOperator.query(query, (ResultSetHandler)new FetchExecutionRecoverFlows(), params.toArray());
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error fetching history recover flow by flowId", e);
        }
    }

    public List<ExecutionRecover> listHistoryRecoverFlows(Map paramMap, int skip, int num) throws ExecutorManagerException {
        StringBuilder querySql = new StringBuilder("SELECT DISTINCT e.recover_id, recover_status, e.enc_type, e.recover_data FROM execution_recover_flows e  JOIN project_permissions p ON e.project_id = p.`project_id`  WHERE recover_status=30 ");
        ArrayList<Object> params = new ArrayList<Object>();
        boolean first = false;
        if (!paramMap.isEmpty()) {
            String userName;
            Integer recoverStatus;
            String flowContains;
            String projContain = MapUtils.getString((Map)paramMap, (Object)"projContain");
            if (projContain != null && !projContain.isEmpty()) {
                this.wrapperSqlParam(first, paramMap, "projContain", null, "name", "like", querySql, params);
            }
            if ((flowContains = MapUtils.getString((Map)paramMap, (Object)"flowContains")) != null && !flowContains.isEmpty()) {
                this.wrapperSqlParam(first, paramMap, "flowContains", null, "flow_id", "like", querySql, params);
            }
            if ((recoverStatus = MapUtils.getInteger((Map)paramMap, (Object)"recoverStatus")) != null && recoverStatus != 0) {
                this.wrapperSqlParam(first, paramMap, "recoverStatus", "int", "recover_status", "=", querySql, params);
            }
            if ((userName = MapUtils.getString((Map)paramMap, (Object)"userName")) != null && !userName.isEmpty()) {
                this.wrapperSqlParam(first, paramMap, "userName", null, "p.name", "=", querySql, params);
            }
        }
        if (skip > -1 && num > 0) {
            querySql.append("  ORDER BY recover_id DESC LIMIT ?, ?");
            params.add(skip);
            params.add(num);
        }
        try {
            return (List)this.dbOperator.query(querySql.toString(), (ResultSetHandler)new FetchExecutionRecoverFlows(), params.toArray());
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error fetching history recover flows", e);
        }
    }

    public List<ExecutionRecover> listMaintainedHistoryRecoverFlows(String username, List<Integer> maintainedProjectIds, int skip, int num) throws ExecutorManagerException {
        String projectIds = maintainedProjectIds.stream().map(Objects::toString).collect(Collectors.joining(",", "(", ")"));
        String querySQL = "(SELECT recover_id, recover_status, erf.enc_type, recover_data FROM execution_recover_flows erf   JOIN projects p ON erf.project_id = p.id WHERE recover_status=30   AND (project_id IN " + projectIds + " OR submit_user = ?))UNION (SELECT DISTINCT e.recover_id, recover_status, e.enc_type, e.recover_data FROM execution_recover_flows e   JOIN project_permissions p ON e.project_id = p.`project_id`   WHERE recover_status=30 AND p.`name` = ? )   ORDER BY recover_id DESC LIMIT ?, ? ;";
        try {
            return (List)this.dbOperator.query(querySQL, (ResultSetHandler)new FetchExecutionRecoverFlows(), new Object[]{username, username, skip, num});
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error fetching history recover flows", e);
        }
    }

    public ExecutionRecover getHistoryRecoverFlowByPidAndFid(String projectId, String flowId) throws ExecutorManagerException {
        String query = "SELECT recover_id, recover_status, enc_type, recover_data FROM execution_recover_flows WHERE project_id = ? AND flow_id = ? ORDER BY start_time DESC limit 1";
        ArrayList<String> params = new ArrayList<String>();
        params.add(projectId);
        params.add(flowId);
        try {
            List recoverList = (List)this.dbOperator.query(query, (ResultSetHandler)new FetchExecutionRecoverFlows(), params.toArray());
            if (recoverList.size() > 0) {
                return (ExecutionRecover)recoverList.get(0);
            }
            return null;
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error fetching history recover flows", e);
        }
    }

    public List<ExecutionRecover> listHistoryRecover(Map<String, String> paramMap) throws ExecutorManagerException {
        String query = FetchExecutionRecoverFlows.LIST_BASE_EXECUTABLE_RECOVER_FLOW_QUERY;
        ArrayList<Object> params = new ArrayList<Object>();
        boolean first = false;
        if (!paramMap.isEmpty()) {
            String recoverStatus = MapUtils.getString(paramMap, (Object)"recoverStatus", (String)"");
            if (recoverStatus != null && !recoverStatus.isEmpty()) {
                if (first) {
                    query = query + " WHERE ";
                    first = false;
                } else {
                    query = query + " AND ";
                }
                query = query + "recover_status = ?";
                params.add(recoverStatus);
            }
            Integer limitNum = MapUtils.getInteger(paramMap, (Object)"limitNum", (Integer)1);
            if (recoverStatus != null && !recoverStatus.isEmpty()) {
                query = query + " ORDER BY recover_id DESC LIMIT ? ";
                params.add(limitNum);
            }
        }
        try {
            return (List)this.dbOperator.query(query, (ResultSetHandler)new FetchExecutionRecoverFlows(), params.toArray());
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error fetching history recover flows", e);
        }
    }

    public int getHistoryRecoverTotal() throws ExecutorManagerException {
        IntHandler intHandler = new IntHandler();
        try {
            return (Integer)this.dbOperator.query("SELECT COUNT(1) FROM execution_recover_flows WHERE recover_status=30 ", (ResultSetHandler)intHandler);
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error fetching num executions", e);
        }
    }

    public int getUserHistoryRecoverTotal(String userName) throws ExecutorManagerException {
        IntHandler intHandler = new IntHandler();
        ArrayList<String> params = new ArrayList<String>();
        params.add(userName);
        try {
            return (Integer)this.dbOperator.query("SELECT COUNT(DISTINCT e.recover_id) FROM execution_recover_flows e  LEFT JOIN project_permissions p ON e.project_id = p.`project_id`  WHERE recover_status=30 AND p.name = ?", (ResultSetHandler)intHandler, params.toArray());
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error fetching num executions", e);
        }
    }

    public int getMaintainedHistoryRecoverTotal(String username, List<Integer> maintainedProjectIds) throws ExecutorManagerException {
        String projectIds = maintainedProjectIds.stream().map(Objects::toString).collect(Collectors.joining(",", "(", ")"));
        String querySQL = "SELECT COUNT(1) FROM ((SELECT recover_id, recover_status, erf.enc_type, recover_data FROM execution_recover_flows erf  JOIN projects p ON erf.project_id = p.id WHERE recover_status=30  AND (project_id IN " + projectIds + " OR submit_user = ?)) UNION (SELECT DISTINCT e.recover_id, recover_status, e.enc_type, e.recover_data FROM execution_recover_flows e  JOIN project_permissions p ON e.project_id = p.`project_id`  WHERE recover_status=30 AND p.`name` = ?)) tmp";
        try {
            IntHandler intHandler = new IntHandler();
            return (Integer)this.dbOperator.query(querySQL, (ResultSetHandler)intHandler, new Object[]{username, username});
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error fetching num executions", e);
        }
    }

    public List<ExecutionRecover> fetchHistoryRecover() throws ExecutorManagerException {
        FetchExecutionRecoverFlowsWithSubmitInfo recoverFlowsWithSubmitInfo = new FetchExecutionRecoverFlowsWithSubmitInfo();
        try {
            return (List)this.dbOperator.query(FetchExecutionRecoverFlowsWithSubmitInfo.IS_NOT_FINISH_RECOVER_WITH_SUBMIT_TIME, (ResultSetHandler)recoverFlowsWithSubmitInfo);
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error fetching num executions", e);
        }
    }

    public int getExecHistoryTotal(Map<String, String> filterMap) throws ExecutorManagerException {
        IntHandler intHandler = new IntHandler();
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder historyTotalSql = new StringBuilder("SELECT COUNT(1) FROM execution_flows ef JOIN projects p ON ef.project_id = p.id");
        boolean first = true;
        if (null != filterMap.get("userContains")) {
            first = this.wrapperSqlParam(first, filterMap, "userContains", null, "submit_user", "like", historyTotalSql, params);
        }
        if (null != filterMap.get("flowContains")) {
            first = this.wrapperSqlParam(first, filterMap, "flowContains", null, "flow_id", "like", historyTotalSql, params);
            first = this.wrapperSqlParam(first, filterMap, "userName", null, "submit_user", "=", historyTotalSql, params);
        }
        if (null != filterMap.get("filterContains")) {
            if (filterMap.get("projContain") != null && !filterMap.get("projContain").isEmpty()) {
                first = this.wrapperSqlParam(first, filterMap, "projContain", null, "name", "like", historyTotalSql, params);
            }
            if (filterMap.get("flowContain") != null && !filterMap.get("flowContain").isEmpty()) {
                first = this.wrapperSqlParam(first, filterMap, "flowContain", null, "flow_id", "like", historyTotalSql, params);
            }
            if (filterMap.get("execIdContain") != null && !filterMap.get("execIdContain").isEmpty()) {
                first = this.wrapperSqlParam(first, filterMap, "execIdContain", null, "exec_id", "like", historyTotalSql, params);
            }
            if (Integer.valueOf(filterMap.get("status")) != 0) {
                first = this.wrapperSqlParam(first, filterMap, "status", "int", "status", "=", historyTotalSql, params);
            }
            if (!"-1".equals(filterMap.get("beginTime"))) {
                first = this.wrapperSqlParam(first, filterMap, "beginTime", "long", "start_time", ">", historyTotalSql, params);
            }
            if (!"-1".equals(filterMap.get("endTime"))) {
                first = this.wrapperSqlParam(first, filterMap, "endTime", "long", "end_time", "<", historyTotalSql, params);
            }
            if (null != filterMap.get("userContain") && !filterMap.get("userContain").isEmpty()) {
                first = this.wrapperSqlParam(first, filterMap, "userContain", null, "submit_user", "like", historyTotalSql, params);
            }
            if (!"-1".equals(filterMap.get("flowType"))) {
                first = this.wrapperSqlParam(first, filterMap, "flowType", "int", "flow_type", "like", historyTotalSql, params);
            }
        }
        try {
            return (Integer)this.dbOperator.query(historyTotalSql.toString(), (ResultSetHandler)intHandler, params.toArray());
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error fetching num executions", e);
        }
    }

    public int getExecHistoryTotal(String username, Map<String, String> filterMap, List<Integer> projectIds) throws ExecutorManagerException {
        IntHandler intHandler = new IntHandler();
        ArrayList<Object> params = new ArrayList<Object>();
        String projectIdsStr = projectIds.stream().map(Object::toString).collect(Collectors.joining(",", "(", ")"));
        StringBuilder historyTotalSql = new StringBuilder("SELECT COUNT(1) FROM execution_flows ef, projects p WHERE ef.project_id = p.id AND ef.project_id IN " + projectIdsStr);
        boolean first = false;
        if (null != filterMap.get("userContains")) {
            first = this.wrapperSqlParam(first, filterMap, "userContains", null, "submit_user", "like", historyTotalSql, params);
        }
        if (null != filterMap.get("flowContains")) {
            first = this.wrapperSqlParam(first, filterMap, "flowContains", null, "flow_id", "like", historyTotalSql, params);
            first = this.wrapperSqlParam(first, filterMap, "userName", null, "submit_user", "=", historyTotalSql, params);
        }
        if (null != filterMap.get("filterContains")) {
            if (filterMap.get("projContain") != null && !filterMap.get("projContain").isEmpty()) {
                first = this.wrapperSqlParam(first, filterMap, "projContain", null, "p.name", "like", historyTotalSql, params);
            }
            if (filterMap.get("flowContain") != null && !filterMap.get("flowContain").isEmpty()) {
                first = this.wrapperSqlParam(first, filterMap, "flowContain", null, "flow_id", "like", historyTotalSql, params);
            }
            if (Integer.valueOf(filterMap.get("status")) != 0) {
                first = this.wrapperSqlParam(first, filterMap, "status", "int", "status", "=", historyTotalSql, params);
            }
            if (!"-1".equals(filterMap.get("beginTime"))) {
                first = this.wrapperSqlParam(first, filterMap, "beginTime", "long", "start_time", ">", historyTotalSql, params);
            }
            if (!"-1".equals(filterMap.get("endTime"))) {
                first = this.wrapperSqlParam(first, filterMap, "endTime", "long", "end_time", "<", historyTotalSql, params);
            }
            if (null != filterMap.get("userContain") && !filterMap.get("userContain").isEmpty()) {
                first = this.wrapperSqlParam(first, filterMap, "userContain", null, "submit_user", "like", historyTotalSql, params);
            }
            if (!"-1".equals(filterMap.get("flowType"))) {
                first = this.wrapperSqlParam(first, filterMap, "flowType", "int", "flow_type", "like", historyTotalSql, params);
            }
        }
        try {
            return (Integer)this.dbOperator.query(historyTotalSql.toString(), (ResultSetHandler)intHandler, params.toArray());
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error fetching num executions", e);
        }
    }

    public int getMaintainedExecHistoryTotal(String username, List<Integer> projectIds) throws ExecutorManagerException {
        String projectIdsStr = projectIds.stream().map(Object::toString).collect(Collectors.joining(",", "(", ")"));
        String querySQL = "SELECT COUNT(1) FROM execution_flows ef, projects p WHERE ef.project_id = p.id AND ef.project_id IN " + projectIdsStr;
        try {
            ResultSetHandler handler = rs -> rs.next() ? rs.getInt(1) : 0;
            return (Integer)this.dbOperator.query(querySQL, handler);
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error fetching num executions", e);
        }
    }

    public int getExecHistoryQuickSerachTotal(Map<String, String> filterMap) throws ExecutorManagerException {
        IntHandler intHandler = new IntHandler();
        ArrayList<String> params = new ArrayList<String>();
        String historyTotalSql = "SELECT COUNT(1) FROM execution_flows ef JOIN projects p ON ef.project_id = p.id";
        boolean first = true;
        if (null != filterMap.get("flowContains")) {
            if (first) {
                historyTotalSql = historyTotalSql + " WHERE ";
                first = false;
            } else {
                historyTotalSql = historyTotalSql + " AND ";
            }
            historyTotalSql = historyTotalSql + " (exec_id LIKE ? OR flow_id LIKE ? OR name LIKE ?  OR submit_user LIKE ? ) ";
            params.add('%' + filterMap.get("flowContains") + '%');
            params.add('%' + filterMap.get("flowContains") + '%');
            params.add('%' + filterMap.get("flowContains") + '%');
            params.add('%' + filterMap.get("flowContains") + '%');
            first = false;
            if (null != filterMap.get("flowUser")) {
                historyTotalSql = historyTotalSql + " AND submit_user = ?";
                params.add(filterMap.get("flowUser"));
                first = false;
            }
        }
        try {
            return (Integer)this.dbOperator.query(historyTotalSql, (ResultSetHandler)intHandler, params.toArray());
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error fetching num executions", e);
        }
    }

    public int getMaintainedFlowsQuickSearchTotal(String username, Map<String, String> filterMap, List<Integer> projectIds) throws ExecutorManagerException {
        IntHandler intHandler = new IntHandler();
        ArrayList<String> params = new ArrayList<String>();
        String projectIdsStr = projectIds.stream().map(Object::toString).collect(Collectors.joining(",", "(", ")"));
        String historyTotalSql = "SELECT COUNT(1) FROM execution_flows ef, projects p WHERE ef.project_id = p.id AND ef.project_id IN " + projectIdsStr + " ";
        boolean first = false;
        if (null != filterMap.get("flowContains")) {
            if (first) {
                historyTotalSql = historyTotalSql + " WHERE ";
                first = false;
            } else {
                historyTotalSql = historyTotalSql + " AND ";
            }
            historyTotalSql = historyTotalSql + " (ef.exec_id LIKE ? OR ef.flow_id LIKE ? OR p.name LIKE ?  OR ef.submit_user LIKE ? ) ";
            params.add('%' + filterMap.get("flowContains") + '%');
            params.add('%' + filterMap.get("flowContains") + '%');
            params.add('%' + filterMap.get("flowContains") + '%');
            params.add('%' + filterMap.get("flowContains") + '%');
            first = false;
            if (null != filterMap.get("flowUser")) {
                historyTotalSql = historyTotalSql + " AND submit_user = ?";
                params.add(filterMap.get("flowUser"));
                first = false;
            }
        }
        try {
            return (Integer)this.dbOperator.query(historyTotalSql, (ResultSetHandler)intHandler, params.toArray());
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error fetching num executions", e);
        }
    }

    public int getUserExecHistoryTotal(Map<String, String> filterMap) throws ExecutorManagerException {
        IntHandler intHandler = new IntHandler();
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder historyTotalSql = new StringBuilder("SELECT COUNT(1) FROM execution_flows ef, projects p, project_permissions pp WHERE ef.project_id = p.id AND ef.project_id = pp.project_id AND pp.name=? ");
        params.add(filterMap.get("userName"));
        boolean first = false;
        if (null != filterMap.get("userContains")) {
            this.wrapperSqlParam(first, filterMap, "userContains", null, "submit_user", "=", historyTotalSql, params);
        }
        if (null != filterMap.get("flowContains")) {
            this.wrapperSqlParam(first, filterMap, "flowContains", null, "flow_id", "like", historyTotalSql, params);
            if (null != filterMap.get("userName")) {
                this.wrapperSqlParam(first, filterMap, "userName", null, "submit_user", "=", historyTotalSql, params);
            }
        }
        if (null != filterMap.get("execIdContain")) {
            this.wrapperSqlParam(first, filterMap, "execIdContain", null, "exec_id", "like", historyTotalSql, params);
            if (null != filterMap.get("userName")) {
                this.wrapperSqlParam(first, filterMap, "userName", null, "submit_user", "=", historyTotalSql, params);
            }
        }
        if (null != filterMap.get("filterContains")) {
            if (filterMap.get("projContain") != null && !filterMap.get("projContain").isEmpty()) {
                this.wrapperSqlParam(first, filterMap, "projContain", null, "p.name", "like", historyTotalSql, params);
            }
            if (filterMap.get("flowContain") != null && !filterMap.get("flowContain").isEmpty()) {
                this.wrapperSqlParam(first, filterMap, "flowContain", null, "flow_id", "like", historyTotalSql, params);
            }
            if (Integer.valueOf(filterMap.get("status")) != 0) {
                this.wrapperSqlParam(first, filterMap, "status", "int", "status", "=", historyTotalSql, params);
            }
            if (!"-1".equals(filterMap.get("beginTime"))) {
                this.wrapperSqlParam(first, filterMap, "beginTime", "long", "start_time", ">", historyTotalSql, params);
            }
            if (!"-1".equals(filterMap.get("endTime"))) {
                this.wrapperSqlParam(first, filterMap, "endTime", "long", "end_time", "<", historyTotalSql, params);
            }
            if (null != filterMap.get("userContain") && !filterMap.get("userContain").isEmpty()) {
                this.wrapperSqlParam(first, filterMap, "userContain", null, "submit_user", "like", historyTotalSql, params);
            }
            if (!"-1".equals(filterMap.get("flowType"))) {
                this.wrapperSqlParam(first, filterMap, "flowType", "int", "flow_type", "=", historyTotalSql, params);
            }
        }
        try {
            return (Integer)this.dbOperator.query(historyTotalSql.toString(), (ResultSetHandler)intHandler, params.toArray());
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error fetching num executions", e);
        }
    }

    private boolean wrapperSqlParam(boolean firstParam, Map<String, String> filterMap, String param, String parseType, String dbColumnName, String action, StringBuilder querySql, List<Object> params) {
        if (firstParam) {
            querySql.append(" WHERE ");
            firstParam = false;
        } else {
            querySql.append(" AND ");
        }
        querySql.append(" ").append(dbColumnName).append(" ").append(action).append(" ?");
        if (action.equalsIgnoreCase("like")) {
            params.add('%' + filterMap.get(param) + '%');
        } else if (parseType == null) {
            params.add(filterMap.get(param));
        } else if ("int".equalsIgnoreCase(parseType)) {
            params.add(Integer.valueOf(filterMap.get(param)));
        } else if ("long".equalsIgnoreCase(parseType)) {
            params.add(Long.valueOf(filterMap.get(param)));
        }
        return firstParam;
    }

    public int getUserExecHistoryQuickSerachTotal(Map<String, String> filterMap) throws ExecutorManagerException {
        IntHandler intHandler = new IntHandler();
        ArrayList<String> params = new ArrayList<String>();
        String historyTotalSql = "SELECT COUNT(1) FROM execution_flows ef, projects p, project_permissions pp WHERE ef.project_id = p.id AND ef.project_id = pp.project_id AND pp.name=? ";
        params.add(filterMap.get("userName"));
        boolean first = false;
        if (null != filterMap.get("flowContains")) {
            if (first) {
                historyTotalSql = historyTotalSql + " WHERE ";
                first = false;
            } else {
                historyTotalSql = historyTotalSql + " AND ";
            }
            historyTotalSql = historyTotalSql + " (ef.exec_id LIKE ? OR ef.flow_id LIKE ? OR p.name LIKE ? OR ef.submit_user LIKE ? ) ";
            params.add('%' + filterMap.get("flowContains") + '%');
            params.add('%' + filterMap.get("flowContains") + '%');
            params.add('%' + filterMap.get("flowContains") + '%');
            params.add('%' + filterMap.get("flowContains") + '%');
            first = false;
            if (null != filterMap.get("flowUser")) {
                historyTotalSql = historyTotalSql + " AND submit_user = ?";
                params.add(filterMap.get("flowUser"));
                first = false;
            }
        }
        try {
            return (Integer)this.dbOperator.query(historyTotalSql, (ResultSetHandler)intHandler, params.toArray());
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error fetching num executions", e);
        }
    }

    private static class IntHandler
    implements ResultSetHandler<Integer> {
        private static final String NUM_EXECUTIONS = "SELECT COUNT(1) FROM execution_recover_flows WHERE recover_status=30 ";
        private static final String USER_NUM_EXECUTIONS = "SELECT COUNT(DISTINCT e.recover_id) FROM execution_recover_flows e  LEFT JOIN project_permissions p ON e.project_id = p.`project_id`  WHERE recover_status=30 AND p.name = ?";

        private IntHandler() {
        }

        public Integer handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return 0;
            }
            return rs.getInt(1);
        }
    }

    public static class FetchExecutionRecoverFlows
    implements ResultSetHandler<List<ExecutionRecover>> {
        static String LIST_BASE_EXECUTABLE_RECOVER_FLOW_QUERY = "SELECT recover_id, recover_status, enc_type, recover_data FROM execution_recover_flows WHERE recover_status=30 ";
        static String LIST_EXECUTABLE_RECOVER_FLOW_BY_ID = "SELECT recover_id, recover_status, enc_type, recover_data FROM execution_recover_flows WHERE recover_id=?";
        static String LIST_ALL_EXECUTABLE_RECOVER_FLOW_HISTORY = "SELECT recover_id, recover_status, enc_type, recover_data FROM execution_recover_flows ORDER BY exec_id DESC LIMIT ?, ?";
        static String LIST_EXECUTABLE_FLOW_HISTORY = "SELECT exec_id, recover_status, enc_type, flow_data FROM execution_recover_flows WHERE project_id=? AND flow_id=? ORDER BY exec_id DESC LIMIT ?, ?";
        static String LIST_EXECUTABLE_FLOW_BY_STATUS = "SELECT exec_id, recover_status, enc_type, flow_data FROM execution_recover_flows WHERE project_id=? AND flow_id=? AND status=? ORDER BY exec_id DESC LIMIT ?, ?";
        static String LIST_USER_EXECUTABLE_RECOVER_FLOW_HISTORY = "SELECT recover_id, recover_status, recover_data FROM execution_recover_flows WHERE submit_user=? ORDER BY recover_id DESC LIMIT ?, ?";
        private static String IS_NOT_FINISH_RECOVER = "SELECT recover_id, recover_status, enc_type, recover_data FROM execution_recover_flows WHERE recover_status in (20,30)";

        public List<ExecutionRecover> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyList();
            }
            ArrayList<ExecutionRecover> execFlows = new ArrayList<ExecutionRecover>();
            do {
                int id = rs.getInt(1);
                int status = rs.getInt(2);
                int encodingType = rs.getInt(3);
                byte[] data = rs.getBytes(4);
                if (data == null) continue;
                EncodingType encType = EncodingType.fromInteger((int)encodingType);
                try {
                    Object flowObj;
                    String jsonString;
                    if (encType == EncodingType.GZIP) {
                        jsonString = GZIPUtils.unGzipString(data, "UTF-8");
                        flowObj = JSONUtils.parseJSONFromString((String)jsonString);
                    } else {
                        jsonString = new String(data, "UTF-8");
                        flowObj = JSONUtils.parseJSONFromString((String)jsonString);
                    }
                    ExecutionRecover exFlow = ExecutionRecover.createExecutionRecoverFromObject(flowObj);
                    exFlow.setRecoverStatus(Status.fromInteger(status));
                    execFlows.add(exFlow);
                }
                catch (IOException e) {
                    throw new SQLException("Error retrieving History Recover data " + id, e);
                }
            } while (rs.next());
            return execFlows;
        }
    }

    public static class FetchExecutionRecoverFlowsWithSubmitInfo
    implements ResultSetHandler<List<ExecutionRecover>> {
        private static String IS_NOT_FINISH_RECOVER_WITH_SUBMIT_TIME = "SELECT recover_id, recover_status, enc_type, recover_data, submit_time, recover_start_time, recover_end_time  FROM execution_recover_flows  WHERE recover_status in (20,30)";
        private static String RUNNING_PAGE_KILL_RECOVER_DATA = "SELECT recover_id, recover_status, enc_type, recover_data, submit_time, recover_start_time, recover_end_time  FROM execution_recover_flows where recover_id = ?";

        public List<ExecutionRecover> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyList();
            }
            ArrayList<ExecutionRecover> execFlows = new ArrayList<ExecutionRecover>();
            do {
                int id = rs.getInt(1);
                int status = rs.getInt(2);
                int encodingType = rs.getInt(3);
                byte[] data = rs.getBytes(4);
                long submitTime = rs.getLong(5);
                long recoverStartTime = rs.getLong(6);
                long recoverEndTime = rs.getLong(7);
                if (data == null) continue;
                EncodingType encType = EncodingType.fromInteger((int)encodingType);
                try {
                    Object flowObj;
                    String jsonString;
                    if (encType == EncodingType.GZIP) {
                        jsonString = GZIPUtils.unGzipString(data, "UTF-8");
                        flowObj = JSONUtils.parseJSONFromString((String)jsonString);
                    } else {
                        jsonString = new String(data, "UTF-8");
                        flowObj = JSONUtils.parseJSONFromString((String)jsonString);
                    }
                    ExecutionRecover exFlow = ExecutionRecover.createExecutionRecoverFromObject(flowObj);
                    exFlow.setRecoverStatus(Status.fromInteger(status));
                    exFlow.setRecoverStartTime(recoverStartTime);
                    exFlow.setRecoverEndTime(recoverEndTime);
                    exFlow.setSubmitTime(submitTime);
                    execFlows.add(exFlow);
                }
                catch (IOException e) {
                    throw new SQLException("Error retrieving History Recover data " + id, e);
                }
            } while (rs.next());
            return execFlows;
        }
    }
}

