/*
 * Decompiled with CFR 0.152.
 */
package azkaban.flow;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableFlowBase;
import azkaban.executor.ExecutableNode;
import azkaban.executor.Status;
import azkaban.flow.Flow;
import azkaban.project.Project;
import azkaban.project.ProjectManager;
import azkaban.utils.Props;
import com.google.gson.Gson;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowUtils {
    private static final Logger logger = LoggerFactory.getLogger(FlowUtils.class);

    public static Props addCommonFlowProperties(Props parentProps, ExecutableFlowBase flow) {
        Props props = new Props(parentProps);
        props.put("azkaban.flow.flowid", flow.getFlowId());
        props.put("azkaban.flow.execid", Integer.valueOf(flow.getExecutionId()));
        props.put("azkaban.flow.projectid", Integer.valueOf(flow.getProjectId()));
        props.put("azkaban.flow.projectname", flow.getProjectName());
        props.put("azkaban.flow.projectversion", Integer.valueOf(flow.getVersion()));
        props.put("azkaban.flow.uuid", UUID.randomUUID().toString());
        props.put("azkaban.flow.projectlastchangedby", flow.getLastModifiedByUser());
        props.put("azkaban.flow.projectlastchangeddate", Long.valueOf(flow.getLastModifiedTimestamp()));
        props.put("azkaban.flow.submituser", flow.getExecutableFlow().getSubmitUser());
        DateTime loadTime = new DateTime();
        props.put("azkaban.flow.start.timestamp", loadTime.toString());
        props.put("azkaban.flow.start.year", loadTime.toString("yyyy"));
        props.put("azkaban.flow.start.month", loadTime.toString("MM"));
        props.put("azkaban.flow.start.day", loadTime.toString("dd"));
        props.put("azkaban.flow.start.hour", loadTime.toString("HH"));
        props.put("azkaban.flow.start.minute", loadTime.toString("mm"));
        props.put("azkaban.flow.start.second", loadTime.toString("ss"));
        props.put("azkaban.flow.start.milliseconds", loadTime.toString("SSS"));
        props.put("azkaban.flow.start.timezone", loadTime.toString("ZZZZ"));
        return props;
    }

    public static void applyDisabledJobs(List<Object> disabledJobs, ExecutableFlowBase exflow) {
        for (Object disabled : disabledJobs) {
            if (disabled instanceof String) {
                String nodeName = (String)disabled;
                ExecutableNode node = exflow.getExecutableNode(nodeName);
                if (node == null) continue;
                node.setStatus(Status.DISABLED);
                continue;
            }
            if (!(disabled instanceof Map)) continue;
            Map nestedDisabled = (Map)disabled;
            String nodeName = (String)nestedDisabled.get("id");
            List subDisabledJobs = (List)nestedDisabled.get("children");
            if (nodeName == null || subDisabledJobs == null) {
                return;
            }
            ExecutableNode node = exflow.getExecutableNode(nodeName);
            if (node == null || !(node instanceof ExecutableFlowBase)) continue;
            FlowUtils.applyDisabledJobs(subDisabledJobs, (ExecutableFlowBase)node);
        }
    }

    public static void resetJobDisabled(List<Object> disabledJobs, ExecutableFlowBase exflow) {
        for (Object disabled : disabledJobs) {
            if (disabled instanceof String) {
                String nodeName = (String)disabled;
                ExecutableNode node = exflow.getExecutableNode(nodeName);
                if (node == null || !node.getStatus().equals((Object)Status.CANCELLED)) continue;
                logger.info("reset job {} status {} to DISABLED.", (Object)node.getNestedId(), (Object)node.getStatus());
                node.setStatus(Status.DISABLED);
                node.setEndTime(-1L);
                node.setStartTime(-1L);
                node.setUpdateTime(System.currentTimeMillis());
                continue;
            }
            if (!(disabled instanceof Map)) continue;
            Map nestedDisabled = (Map)disabled;
            String nodeName = (String)nestedDisabled.get("id");
            List subDisabledJobs = (List)nestedDisabled.get("children");
            if (nodeName == null || subDisabledJobs == null) {
                return;
            }
            ExecutableNode node = exflow.getExecutableNode(nodeName);
            if (node == null || !(node instanceof ExecutableFlowBase)) continue;
            FlowUtils.resetJobDisabled(subDisabledJobs, (ExecutableFlowBase)node);
        }
    }

    public static Project getProject(ProjectManager projectManager, int projectId) {
        Project project = projectManager.getProject(projectId);
        if (project == null) {
            throw new RuntimeException("Error finding the project to execute " + projectId);
        }
        return project;
    }

    public static Flow getFlow(Project project, String flowName) {
        Project nonNullProj = Objects.requireNonNull(project);
        Flow flow = nonNullProj.getFlow(flowName);
        if (flow == null) {
            throw new RuntimeException("Error finding the flow to execute " + flowName);
        }
        return flow;
    }

    public static ExecutableFlow createExecutableFlow(Project project, Flow flow) {
        ExecutableFlow exflow = new ExecutableFlow(project, flow);
        exflow.addAllProxyUsers(project.getProxyUsers());
        return exflow;
    }

    public static String toJson(Project proj) {
        Gson gson = new Gson();
        String jsonStr = gson.toJson((Object)proj);
        return jsonStr;
    }

    public static Project toProject(String json) {
        Gson gson = new Gson();
        return (Project)gson.fromJson(json, Project.class);
    }

    public static Props addRepeatCommonFlowProperties(Props parentProps, long repeatTime, ExecutableFlowBase flow) {
        Props props = new Props(parentProps);
        props.put("azkaban.flow.flowid", flow.getFlowId());
        props.put("azkaban.flow.execid", Integer.valueOf(flow.getExecutionId()));
        props.put("azkaban.flow.projectid", Integer.valueOf(flow.getProjectId()));
        props.put("azkaban.flow.projectname", flow.getProjectName());
        props.put("azkaban.flow.projectversion", Integer.valueOf(flow.getVersion()));
        props.put("azkaban.flow.uuid", UUID.randomUUID().toString());
        props.put("azkaban.flow.projectlastchangedby", flow.getLastModifiedByUser());
        props.put("azkaban.flow.projectlastchangeddate", Long.valueOf(flow.getLastModifiedTimestamp()));
        props.put("azkaban.flow.submituser", flow.getExecutableFlow().getSubmitUser());
        DateTime loadTime = new DateTime(repeatTime);
        props.put("azkaban.flow.start.timestamp", loadTime.toString());
        props.put("azkaban.flow.start.year", loadTime.toString("yyyy"));
        props.put("azkaban.flow.start.month", loadTime.toString("MM"));
        props.put("azkaban.flow.start.day", loadTime.toString("dd"));
        props.put("azkaban.flow.start.hour", loadTime.toString("HH"));
        props.put("azkaban.flow.start.minute", loadTime.toString("mm"));
        props.put("azkaban.flow.start.second", loadTime.toString("ss"));
        props.put("azkaban.flow.start.milliseconds", loadTime.toString("SSS"));
        props.put("azkaban.flow.start.timezone", loadTime.toString("ZZZZ"));
        return props;
    }

    public static void getAllFailedNodeList(ExecutableFlowBase node, List<ExecutableNode> executableNodeList) {
        for (ExecutableNode execNode : node.getExecutableNodes()) {
            if (execNode instanceof ExecutableFlowBase) {
                FlowUtils.getAllFailedNodeList((ExecutableFlowBase)execNode, executableNodeList);
                continue;
            }
            if (!(execNode instanceof ExecutableNode) || !Status.isFailed(execNode.getStatus())) continue;
            executableNodeList.add(execNode);
        }
    }

    public static List<String> getAllFailedNodeNestIdSortByEndTime(List<ExecutableNode> nodeList) {
        return nodeList.stream().sorted(new Comparator<ExecutableNode>(){

            @Override
            public int compare(ExecutableNode o1, ExecutableNode o2) {
                if (o1.getEndTime() < o2.getEndTime()) {
                    return -1;
                }
                if (o1.getEndTime() == o2.getEndTime()) {
                    return 0;
                }
                return 1;
            }
        }).map(x -> x.getNestedId()).collect(Collectors.toList());
    }

    public static List<String> getThreeFailedNodeNestId(List<String> list) {
        if (list.size() > 3) {
            return list.subList(0, 3);
        }
        return list;
    }
}

