/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor.selector;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.Executor;
import azkaban.executor.ExecutorInfo;
import azkaban.executor.selector.CandidateFilter;
import azkaban.executor.selector.FactorFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class ExecutorFilter
extends CandidateFilter<Executor, ExecutableFlow> {
    private static final String STATICREMAININGFLOWSIZE_FILTER_NAME = "StaticRemainingFlowSize";
    private static final String MINIMUMFREEMEMORY_FILTER_NAME = "MinimumFreeMemory";
    private static final String CPUSTATUS_FILTER_NAME = "CpuStatus";
    private static Map<String, FactorFilter<Executor, ExecutableFlow>> filterRepository = null;

    public ExecutorFilter(Collection<String> filterList) {
        if (null == filterList || filterList.size() == 0) {
            logger.error("failed to initialize executor filter as the passed filter list is invalid or empty.");
            throw new IllegalArgumentException("filterList");
        }
        for (String filterName : filterList) {
            if (filterRepository.containsKey(filterName)) {
                this.registerFactorFilter(filterRepository.get(filterName));
                continue;
            }
            logger.error(String.format("failed to initialize executor filter as the filter implementation for requested factor '%s' doesn't exist.", filterName));
            throw new IllegalArgumentException("filterList");
        }
    }

    public static Set<String> getAvailableFilterNames() {
        return filterRepository.keySet();
    }

    private static FactorFilter<Executor, ExecutableFlow> getStaticRemainingFlowSizeFilter() {
        return FactorFilter.create(STATICREMAININGFLOWSIZE_FILTER_NAME, (filteringTarget, referencingObject) -> {
            if (null == filteringTarget) {
                logger.debug(String.format("%s : filtering out the target as it is null.", STATICREMAININGFLOWSIZE_FILTER_NAME));
                return false;
            }
            ExecutorInfo stats = filteringTarget.getExecutorInfo();
            if (null == stats) {
                logger.debug(String.format("%s : filtering out %s as it's stats is unavailable.", STATICREMAININGFLOWSIZE_FILTER_NAME, filteringTarget.toString()));
                return false;
            }
            return stats.getRemainingFlowCapacity() > 0;
        });
    }

    private static FactorFilter<Executor, ExecutableFlow> getMinimumReservedMemoryFilter() {
        return FactorFilter.create(MINIMUMFREEMEMORY_FILTER_NAME, new FactorFilter.Filter<Executor, ExecutableFlow>(){
            private static final int MINIMUM_FREE_MEMORY = 6144;

            @Override
            public boolean filterTarget(Executor filteringTarget, ExecutableFlow referencingObject) {
                if (null == filteringTarget) {
                    CandidateFilter.logger.debug(String.format("%s : filtering out the target as it is null.", ExecutorFilter.MINIMUMFREEMEMORY_FILTER_NAME));
                    return false;
                }
                ExecutorInfo stats = filteringTarget.getExecutorInfo();
                if (null == stats) {
                    CandidateFilter.logger.debug(String.format("%s : filtering out %s as it's stats is unavailable.", ExecutorFilter.MINIMUMFREEMEMORY_FILTER_NAME, filteringTarget.toString()));
                    return false;
                }
                return stats.getRemainingMemoryInMB() > 6144L;
            }
        });
    }

    private static FactorFilter<Executor, ExecutableFlow> getCpuStatusFilter() {
        return FactorFilter.create(CPUSTATUS_FILTER_NAME, new FactorFilter.Filter<Executor, ExecutableFlow>(){
            private static final int MAX_CPU_CURRENT_USAGE = 95;

            @Override
            public boolean filterTarget(Executor filteringTarget, ExecutableFlow referencingObject) {
                if (null == filteringTarget) {
                    CandidateFilter.logger.debug(String.format("%s : filtering out the target as it is null.", ExecutorFilter.CPUSTATUS_FILTER_NAME));
                    return false;
                }
                ExecutorInfo stats = filteringTarget.getExecutorInfo();
                if (null == stats) {
                    CandidateFilter.logger.debug(String.format("%s : filtering out %s as it's stats is unavailable.", ExecutorFilter.CPUSTATUS_FILTER_NAME, filteringTarget.toString()));
                    return false;
                }
                return stats.getCpuUsage() < 95.0;
            }
        });
    }

    @Override
    public String getName() {
        return "ExecutorFilter";
    }

    static {
        filterRepository = new HashMap<String, FactorFilter<Executor, ExecutableFlow>>();
        filterRepository.put(STATICREMAININGFLOWSIZE_FILTER_NAME, ExecutorFilter.getStaticRemainingFlowSizeFilter());
        filterRepository.put(MINIMUMFREEMEMORY_FILTER_NAME, ExecutorFilter.getMinimumReservedMemoryFilter());
        filterRepository.put(CPUSTATUS_FILTER_NAME, ExecutorFilter.getCpuStatusFilter());
    }
}

