/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor.selector;

import azkaban.executor.selector.FactorFilter;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CandidateFilter<T, V> {
    protected static final Logger logger = LoggerFactory.getLogger(CandidateFilter.class);
    private final Map<String, FactorFilter<T, V>> factorFilterList = new ConcurrentHashMap<String, FactorFilter<T, V>>();

    public abstract String getName();

    protected void registerFactorFilter(FactorFilter<T, V> filter) {
        if (null == filter) {
            throw new IllegalArgumentException("unable to register factor filter. The passed comaractor is null or has an invalid weight value.");
        }
        this.factorFilterList.put(filter.getFactorName(), filter);
        logger.debug(String.format("Factor filter added for '%s'.", filter.getFactorName()));
    }

    public boolean filterTarget(T filteringTarget, V referencingObject) {
        logger.debug(String.format("start filtering '%s' with factor filter for '%s'", filteringTarget == null ? "(null)" : filteringTarget.toString(), this.getName()));
        Collection<FactorFilter<T, V>> filterList = this.factorFilterList.values();
        boolean result = true;
        for (FactorFilter<T, V> filter : filterList) {
            logger.debug(String.format("[Factor: %s] filter result : %s ", filter.getFactorName(), result &= filter.filterTarget(filteringTarget, referencingObject)));
            if (result) continue;
            break;
        }
        logger.debug(String.format("Final filtering result : %s ", result));
        return result;
    }
}

