/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor.mail;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutionOptions;
import azkaban.executor.Executor;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.Status;
import azkaban.executor.mail.MailCreator;
import azkaban.utils.EmailMessage;
import azkaban.utils.Utils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;

public class DefaultMailCreator
implements MailCreator {
    public static final String DEFAULT_MAIL_CREATOR = "default";
    private static final DateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss z");
    private static final HashMap<String, MailCreator> registeredCreators = new HashMap();
    private static final MailCreator defaultCreator = new DefaultMailCreator();

    public static void registerCreator(String name, MailCreator creator) {
        registeredCreators.put(name, creator);
    }

    public static MailCreator getCreator(String name) {
        MailCreator creator = registeredCreators.get(name);
        if (creator == null) {
            creator = defaultCreator;
        }
        return creator;
    }

    private static String convertMSToString(long timeInMS) {
        if (timeInMS < 0L) {
            return "N/A";
        }
        return DATE_FORMATTER.format(new Date(timeInMS));
    }

    private static List<String> findFailedJobs(ExecutableFlow flow) {
        ArrayList<String> failedJobs = new ArrayList<String>();
        for (ExecutableNode node : flow.getExecutableNodes()) {
            if (node.getStatus() != Status.FAILED) continue;
            failedJobs.add(node.getId());
        }
        return failedJobs;
    }

    @Override
    public boolean createFirstErrorMessage(ExecutableFlow flow, EmailMessage message, String azkabanName, String scheme, String clientHostname, String clientPortNumber, String ... vars) {
        ExecutionOptions option = flow.getExecutionOptions();
        List<String> emailList = option.getFailureEmails();
        int execId = flow.getExecutionId();
        if (emailList != null && !emailList.isEmpty()) {
            message.addAllToAddress(emailList);
            message.setMimeType("text/html;charset=UTF-8");
            message.setSubject("\u5de5\u4f5c\u6d41 '" + flow.getFlowId() + "' \u6267\u884c\u5931\u8d25 " + azkabanName);
            message.println("<h2 style=\"color:#FF0000\"> \u6267\u884cID '" + flow.getExecutionId() + "' \u5de5\u4f5c\u6d41\u540d\uff1a '" + flow.getFlowId() + "' \u9879\u76ee\u540d\uff1a '" + flow.getProjectName() + "' \u6267\u884c\u5931\u8d25\uff0c\u7cfb\u7edf\u540d\uff1a " + azkabanName + "</h2>");
            if (option.getFailureAction() == ExecutionOptions.FailureAction.CANCEL_ALL) {
                message.println("\u8fd9\u4e2a\u5de5\u4f5c\u6d41\u8bbe\u7f6e\u51fa\u9519\u65f6\u7ec8\u6b62\u6240\u6709\u6b63\u5728\u8fd0\u884c\u7684\u4efb\u52a1.");
            } else if (option.getFailureAction() == ExecutionOptions.FailureAction.FINISH_ALL_POSSIBLE) {
                message.println("\u8fd9\u4e2a\u5de5\u4f5c\u6d41\u8bbe\u7f6e\u51fa\u9519\u65f6\u5b8c\u6210\u6240\u6709\u53ef\u4ee5\u6267\u884c\u7684\u4efb\u52a1.");
            } else {
                message.println("\u8fd9\u4e2a\u5de5\u4f5c\u6d41\u8bbe\u7f6e\u5b8c\u6210\u5f53\u524d\u6b63\u5728\u8fd0\u884c\u7684\u4efb\u52a1.");
            }
            message.println("<table>");
            message.println("<tr><td>\u5f00\u59cb\u65f6\u95f4</td><td>" + DefaultMailCreator.convertMSToString(flow.getStartTime()) + "</td></tr>");
            message.println("<tr><td>\u7ed3\u675f\u65f6\u95f4</td><td>" + DefaultMailCreator.convertMSToString(flow.getEndTime()) + "</td></tr>");
            message.println("<tr><td>\u6267\u884c\u65f6\u957f</td><td>" + Utils.formatDuration((long)flow.getStartTime(), (long)flow.getEndTime()) + "</td></tr>");
            message.println("<tr><td>\u6267\u884c\u72b6\u6001</td><td>" + (Object)((Object)flow.getStatus()) + "</td></tr>");
            message.println("</table>");
            message.println("");
            String executionUrl = scheme + "://" + clientHostname + ":" + clientPortNumber + "/executor?execid=" + execId;
            message.println("<a href=\"" + executionUrl + "\">" + flow.getFlowId() + " \u6267\u884c\u94fe\u63a5</a>");
            message.println("");
            message.println("<h3>Reason</h3>");
            List<String> failedJobs = DefaultMailCreator.findFailedJobs(flow);
            message.println("<ul>");
            for (String jobId : failedJobs) {
                message.println("<li><a href=\"" + executionUrl + "&job=" + jobId + "\"> \u9519\u8bef\u7684\u4efb\u52a1 '" + jobId + "' \u94fe\u63a5</a></li>");
            }
            message.println("</ul>");
            return true;
        }
        return false;
    }

    @Override
    public boolean createErrorEmail(ExecutableFlow flow, EmailMessage message, String azkabanName, String scheme, String clientHostname, String clientPortNumber, String ... vars) {
        ExecutionOptions option = flow.getExecutionOptions();
        List<String> emailList = option.getFailureEmails();
        int execId = flow.getExecutionId();
        if (emailList != null && !emailList.isEmpty()) {
            message.addAllToAddress(emailList);
            message.setMimeType("text/html;charset=UTF-8");
            message.setSubject("\u5de5\u4f5c\u6d41 '" + flow.getFlowId() + "' \u6267\u884c\u5931\u8d25 " + azkabanName);
            message.println("<h2 style=\"color:#FF0000\"> \u6267\u884cID '" + execId + "' \u5de5\u4f5c\u6d41\u540d '" + flow.getFlowId() + "' \u9879\u76ee\u540d '" + flow.getProjectName() + "' \u6267\u884c\u5931\u8d25\uff0c\u7cfb\u7edf\u540d " + azkabanName + "</h2>");
            message.println("<table>");
            message.println("<tr><td>\u5f00\u59cb\u65f6\u95f4</td><td>" + DefaultMailCreator.convertMSToString(flow.getStartTime()) + "</td></tr>");
            message.println("<tr><td>\u7ed3\u675f\u65f6\u95f4</td><td>" + DefaultMailCreator.convertMSToString(flow.getEndTime()) + "</td></tr>");
            message.println("<tr><td>\u6267\u884c\u65f6\u957f</td><td>" + Utils.formatDuration((long)flow.getStartTime(), (long)flow.getEndTime()) + "</td></tr>");
            message.println("<tr><td>\u6267\u884c\u72b6\u6001</td><td>" + (Object)((Object)flow.getStatus()) + "</td></tr>");
            message.println("</table>");
            message.println("");
            String executionUrl = scheme + "://" + clientHostname + ":" + clientPortNumber + "/executor?execid=" + execId;
            message.println("<a href=\"" + executionUrl + "\">" + flow.getFlowId() + " \u6267\u884c\u94fe\u63a5</a>");
            message.println("");
            message.println("<h3>Reason</h3>");
            List<String> failedJobs = DefaultMailCreator.findFailedJobs(flow);
            message.println("<ul>");
            for (String jobId : failedJobs) {
                message.println("<li><a href=\"" + executionUrl + "&job=" + jobId + "\"> \u9519\u8bef\u7684\u4efb\u52a1 '" + jobId + "' \u94fe\u63a5</a></li>");
            }
            for (String reasons : vars) {
                message.println("<li>" + reasons + "</li>");
            }
            message.println("</ul>");
            return true;
        }
        return false;
    }

    @Override
    public boolean createSuccessEmail(ExecutableFlow flow, EmailMessage message, String azkabanName, String scheme, String clientHostname, String clientPortNumber, String ... vars) {
        ExecutionOptions option = flow.getExecutionOptions();
        List<String> emailList = option.getSuccessEmails();
        int execId = flow.getExecutionId();
        if (emailList != null && !emailList.isEmpty()) {
            message.addAllToAddress(emailList);
            message.setMimeType("text/html;charset=UTF-8");
            message.setSubject("\u5de5\u4f5c\u6d41 '" + flow.getFlowId() + "' \u6267\u884c\u6210\u529f " + azkabanName);
            message.println("<h2> \u6267\u884cID '" + flow.getExecutionId() + "' \u5de5\u4f5c\u6d41\u540d '" + flow.getFlowId() + "' \u9879\u76ee\u540d '" + flow.getProjectName() + "' \u6267\u884c\u6210\u529f\uff0c\u7cfb\u7edf\u540d " + azkabanName + "</h2>");
            message.println("<table>");
            message.println("<tr><td>\u5f00\u59cb\u65f6\u95f4</td><td>" + DefaultMailCreator.convertMSToString(flow.getStartTime()) + "</td></tr>");
            message.println("<tr><td>\u7ed3\u675f\u65f6\u95f4</td><td>" + DefaultMailCreator.convertMSToString(flow.getEndTime()) + "</td></tr>");
            message.println("<tr><td>\u6267\u884c\u65f6\u957f</td><td>" + Utils.formatDuration((long)flow.getStartTime(), (long)flow.getEndTime()) + "</td></tr>");
            message.println("<tr><td>\u6267\u884c\u72b6\u6001</td><td>" + (Object)((Object)flow.getStatus()) + "</td></tr>");
            message.println("</table>");
            message.println("");
            String executionUrl = scheme + "://" + clientHostname + ":" + clientPortNumber + "/executor?execid=" + execId;
            message.println("<a href=\"" + executionUrl + "\">" + flow.getFlowId() + " \u6267\u884c\u94fe\u63a5</a>");
            return true;
        }
        return false;
    }

    @Override
    public boolean createFailedUpdateMessage(List<ExecutableFlow> flows, Executor executor, ExecutorManagerException updateException, EmailMessage message, String azkabanName, String scheme, String clientHostname, String clientPortNumber) {
        ExecutionOptions option = flows.get(0).getExecutionOptions();
        List<String> emailList = option.getFailureEmails();
        if (emailList != null && !emailList.isEmpty()) {
            message.addAllToAddress(emailList);
            message.setMimeType("text/html");
            message.setSubject("Flow status could not be updated from " + executor.getHost() + " on " + azkabanName);
            message.println("<h2 style=\"color:#FF0000\"> Flow status could not be updated from " + executor.getHost() + " on " + azkabanName + "</h2>");
            message.println("The actual status of these executions is unknown, because getting status update from azkaban executor is failing");
            message.println("");
            message.println("<h3>Error detail</h3>");
            message.println("<pre>" + ExceptionUtils.getStackTrace((Throwable)updateException) + "</pre>");
            message.println("");
            message.println("<h3>Affected executions</h3>");
            message.println("<ul>");
            for (ExecutableFlow flow : flows) {
                int execId = flow.getExecutionId();
                String executionUrl = scheme + "://" + clientHostname + ":" + clientPortNumber + "/executor?execid=" + execId;
                message.println("<li>Execution '" + flow.getExecutionId() + "' of flow '" + flow.getFlowId() + "' of project '" + flow.getProjectName() + "' -  <a href=\"" + executionUrl + "\">Execution Link</a></li>");
            }
            message.println("</ul>");
            return true;
        }
        return false;
    }

    static {
        DefaultMailCreator.registerCreator(DEFAULT_MAIL_CREATOR, defaultCreator);
    }
}

