/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;

public enum Status {
    READY(10),
    PREPARING(20),
    RUNNING(30),
    PAUSED(40),
    RETRIED_SUCCEEDED(45),
    SUCCEEDED(50),
    KILLING(55),
    KILLED(60),
    FAILED(70),
    FAILED_WAITING(75),
    FAILED_FINISHING(80),
    FAILED_RETRYING(85),
    SKIPPED(90),
    FAILED_SKIPPED(95),
    DISABLED(100),
    QUEUED(110),
    FAILED_SUCCEEDED(120),
    CANCELLED(125);

    private static final ImmutableMap<Integer, Status> numValMap;
    private final int numVal;

    private Status(int numVal) {
        this.numVal = numVal;
    }

    public static Status fromInteger(int x) {
        return (Status)((Object)numValMap.getOrDefault((Object)x, (Object)READY));
    }

    public static boolean isStatusFinished(Status status) {
        switch (status) {
            case FAILED: 
            case KILLED: 
            case SUCCEEDED: 
            case SKIPPED: 
            case FAILED_SUCCEEDED: 
            case CANCELLED: 
            case FAILED_SKIPPED: 
            case RETRIED_SUCCEEDED: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStatusRunning(Status status) {
        switch (status) {
            case RUNNING: 
            case FAILED_FINISHING: 
            case QUEUED: 
            case FAILED_RETRYING: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStatusFailed(Status status) {
        switch (status) {
            case FAILED: 
            case KILLED: 
            case CANCELLED: {
                return true;
            }
        }
        return false;
    }

    public static boolean isFailed(Status status) {
        switch (status) {
            case FAILED: 
            case FAILED_SKIPPED: 
            case FAILED_WAITING: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStatusSucceeded(Status status) {
        switch (status) {
            case SUCCEEDED: 
            case SKIPPED: 
            case FAILED_SUCCEEDED: 
            case FAILED_SKIPPED: 
            case RETRIED_SUCCEEDED: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSucceeded(Status status) {
        switch (status) {
            case SUCCEEDED: 
            case RETRIED_SUCCEEDED: {
                return true;
            }
        }
        return false;
    }

    public int getNumVal() {
        return this.numVal;
    }

    static {
        numValMap = (ImmutableMap)Arrays.stream(Status.values()).collect(ImmutableMap.toImmutableMap(status -> status.getNumVal(), status -> status));
    }
}

