/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableFlowPriorityComparator;
import azkaban.executor.ExecutionReference;
import azkaban.executor.ExecutorManagerException;
import azkaban.utils.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueuedExecutions {
    private static final Logger logger = LoggerFactory.getLogger(QueuedExecutions.class);
    final long capacity;
    private final ConcurrentHashMap<Integer, Pair<ExecutionReference, ExecutableFlow>> queuedFlowMap;
    private final BlockingQueue<Pair<ExecutionReference, ExecutableFlow>> queuedFlowList;

    public QueuedExecutions(long capacity) {
        this.capacity = capacity;
        this.queuedFlowMap = new ConcurrentHashMap();
        this.queuedFlowList = new PriorityBlockingQueue<Pair<ExecutionReference, ExecutableFlow>>(10, new ExecutableFlowPriorityComparator());
    }

    public Pair<ExecutionReference, ExecutableFlow> fetchHead() throws InterruptedException {
        Pair<ExecutionReference, ExecutableFlow> pair = this.queuedFlowList.take();
        if (pair != null && pair.getFirst() != null) {
            this.queuedFlowMap.remove(pair.getFirst().getExecId());
        }
        return pair;
    }

    public void dequeue(int executionId) {
        if (this.queuedFlowMap.containsKey(executionId)) {
            this.queuedFlowList.remove(this.queuedFlowMap.get(executionId));
            this.queuedFlowMap.remove(executionId);
        }
    }

    public void enqueue(ExecutableFlow exflow, ExecutionReference ref) throws ExecutorManagerException {
        if (this.hasExecution(exflow.getExecutionId())) {
            String errMsg = "Flow already in queue " + exflow.getExecutionId();
            throw new ExecutorManagerException(errMsg);
        }
        Pair<ExecutionReference, ExecutableFlow> pair = new Pair<ExecutionReference, ExecutableFlow>(ref, exflow);
        try {
            this.queuedFlowMap.put(exflow.getExecutionId(), pair);
            this.queuedFlowList.put(pair);
        }
        catch (InterruptedException e) {
            String errMsg = "Failed to insert flow " + exflow.getExecutionId();
            logger.error(errMsg, (Throwable)e);
            throw new ExecutorManagerException(errMsg);
        }
    }

    public void enqueueAll(Collection<Pair<ExecutionReference, ExecutableFlow>> collection) throws ExecutorManagerException {
        for (Pair<ExecutionReference, ExecutableFlow> pair : collection) {
            this.enqueue(pair.getSecond(), pair.getFirst());
        }
    }

    public Collection<Pair<ExecutionReference, ExecutableFlow>> getAllEntries() {
        return Collections.unmodifiableCollection(this.queuedFlowMap.values());
    }

    public boolean hasExecution(int executionId) {
        return this.queuedFlowMap.containsKey(executionId);
    }

    public ExecutableFlow getFlow(int executionId) {
        if (this.hasExecution(executionId)) {
            return this.queuedFlowMap.get(executionId).getSecond();
        }
        return null;
    }

    public ExecutionReference getReference(int executionId) {
        if (this.hasExecution(executionId)) {
            return this.queuedFlowMap.get(executionId).getFirst();
        }
        return null;
    }

    public long size() {
        return this.queuedFlowList.size();
    }

    public boolean isFull() {
        return this.size() >= this.capacity;
    }

    public boolean isEmpty() {
        return this.queuedFlowList.isEmpty() && this.queuedFlowMap.isEmpty();
    }

    public void clear() {
        for (Pair<ExecutionReference, ExecutableFlow> pair : this.queuedFlowMap.values()) {
            this.dequeue(pair.getFirst().getExecId());
        }
    }
}

