/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.executor.ActiveExecutingFlowsDao;
import azkaban.executor.AssignExecutorDao;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableJobInfo;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutionFlowDao;
import azkaban.executor.ExecutionJobDao;
import azkaban.executor.ExecutionReference;
import azkaban.executor.Executor;
import azkaban.executor.ExecutorDao;
import azkaban.executor.ExecutorEventsDao;
import azkaban.executor.ExecutorLoader;
import azkaban.executor.ExecutorLogEvent;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.FetchActiveFlowDao;
import azkaban.executor.NumExecutionsDao;
import azkaban.executor.Status;
import azkaban.history.ExecutionRecover;
import azkaban.history.ExecutionRecoverDao;
import azkaban.history.RecoverTrigger;
import azkaban.utils.FileIOUtils;
import azkaban.utils.Pair;
import azkaban.utils.Props;
import com.webank.wedatasphere.schedulis.common.executor.DepartmentGroup;
import com.webank.wedatasphere.schedulis.common.executor.DepartmentGroupDao;
import com.webank.wedatasphere.schedulis.common.executor.ExecutionCycle;
import com.webank.wedatasphere.schedulis.common.executor.ExecutionCycleDao;
import com.webank.wedatasphere.schedulis.common.executor.ExecutionLogsAdapter;
import com.webank.wedatasphere.schedulis.common.executor.UserVariable;
import com.webank.wedatasphere.schedulis.common.executor.UserVariableDao;
import com.webank.wedatasphere.schedulis.common.log.LogFilterDao;
import com.webank.wedatasphere.schedulis.common.log.LogFilterEntity;
import com.webank.wedatasphere.schedulis.common.system.entity.WtssUser;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JdbcExecutorLoader
implements ExecutorLoader {
    private static Logger logger = LoggerFactory.getLogger(JdbcExecutorLoader.class);
    private final ExecutionFlowDao executionFlowDao;
    private final ExecutorDao executorDao;
    private final ExecutionJobDao executionJobDao;
    private final ExecutionLogsAdapter executionLogsDao;
    private final ExecutorEventsDao executorEventsDao;
    private final ActiveExecutingFlowsDao activeExecutingFlowsDao;
    private final FetchActiveFlowDao fetchActiveFlowDao;
    private final AssignExecutorDao assignExecutorDao;
    private final NumExecutionsDao numExecutionsDao;
    private final ExecutionRecoverDao executionRecoverDao;
    private final LogFilterDao logFilterDao;
    private final DepartmentGroupDao departmentGroupDao;
    private final UserVariableDao userVariableDao;
    private final ExecutionCycleDao executionCycleDao;

    @Inject
    public JdbcExecutorLoader(ExecutionFlowDao executionFlowDao, ExecutorDao executorDao, ExecutionJobDao executionJobDao, ExecutionLogsAdapter executionLogsDao, ExecutorEventsDao executorEventsDao, ActiveExecutingFlowsDao activeExecutingFlowsDao, FetchActiveFlowDao fetchActiveFlowDao, AssignExecutorDao assignExecutorDao, NumExecutionsDao numExecutionsDao, ExecutionRecoverDao executionRecoverDao, LogFilterDao logFilterDao, DepartmentGroupDao departmentGroupDao, UserVariableDao userVariableDao, ExecutionCycleDao executionCycleDao) {
        this.executionFlowDao = executionFlowDao;
        this.executorDao = executorDao;
        this.executionJobDao = executionJobDao;
        this.executionLogsDao = executionLogsDao;
        this.executorEventsDao = executorEventsDao;
        this.activeExecutingFlowsDao = activeExecutingFlowsDao;
        this.fetchActiveFlowDao = fetchActiveFlowDao;
        this.numExecutionsDao = numExecutionsDao;
        this.assignExecutorDao = assignExecutorDao;
        this.executionRecoverDao = executionRecoverDao;
        this.logFilterDao = logFilterDao;
        this.departmentGroupDao = departmentGroupDao;
        this.userVariableDao = userVariableDao;
        this.executionCycleDao = executionCycleDao;
    }

    @Override
    public synchronized void uploadExecutableFlow(ExecutableFlow flow) throws ExecutorManagerException {
        this.executionFlowDao.uploadExecutableFlow(flow);
    }

    @Override
    public void updateExecutableFlow(ExecutableFlow flow) throws ExecutorManagerException {
        this.executionFlowDao.updateExecutableFlow(flow);
    }

    @Override
    public ExecutableFlow fetchExecutableFlow(int id) throws ExecutorManagerException {
        return this.executionFlowDao.fetchExecutableFlow(id);
    }

    @Override
    public List<ExecutableFlow> fetchExecutableFlowByRepeatId(int repeatId) throws ExecutorManagerException {
        return this.executionFlowDao.fetchExecutableFlowByRepeatId(repeatId);
    }

    @Override
    public List<Pair<ExecutionReference, ExecutableFlow>> fetchQueuedFlows() throws ExecutorManagerException {
        return this.executionFlowDao.fetchQueuedFlows();
    }

    @Override
    public List<ExecutableFlow> fetchRecentlyFinishedFlows(Duration maxAge) throws ExecutorManagerException {
        return this.executionFlowDao.fetchRecentlyFinishedFlows(maxAge);
    }

    @Override
    public Map<Integer, Pair<ExecutionReference, ExecutableFlow>> fetchActiveFlows() throws ExecutorManagerException {
        return this.fetchActiveFlowDao.fetchActiveFlows();
    }

    @Override
    public Map<Integer, Pair<ExecutionReference, ExecutableFlow>> fetchUnfinishedFlows() throws ExecutorManagerException {
        return this.fetchActiveFlowDao.fetchUnfinishedFlows();
    }

    @Override
    public List<ExecutableFlow> fetchAllUnfinishedFlows() throws ExecutorManagerException {
        return this.fetchActiveFlowDao.fetchAllUnFinishFlows();
    }

    @Override
    public Map<Integer, Pair<ExecutionReference, ExecutableFlow>> fetchUnfinishedFlowsMetadata() throws ExecutorManagerException {
        return this.fetchActiveFlowDao.fetchUnfinishedFlowsMetadata();
    }

    @Override
    public Pair<ExecutionReference, ExecutableFlow> fetchActiveFlowByExecId(int execId) throws ExecutorManagerException {
        return this.fetchActiveFlowDao.fetchActiveFlowByExecId(execId);
    }

    @Override
    public int fetchNumExecutableFlows() throws ExecutorManagerException {
        return this.numExecutionsDao.fetchNumExecutableFlows();
    }

    @Override
    public int fetchNumExecutableFlows(int projectId, String flowId) throws ExecutorManagerException {
        return this.numExecutionsDao.fetchNumExecutableFlows(projectId, flowId);
    }

    @Override
    public int fetchNumExecutableNodes(int projectId, String jobId) throws ExecutorManagerException {
        return this.numExecutionsDao.fetchNumExecutableNodes(projectId, jobId);
    }

    @Override
    public List<ExecutableFlow> fetchFlowHistory(int projectId, String flowId, int skip, int num) throws ExecutorManagerException {
        return this.executionFlowDao.fetchFlowHistory(projectId, flowId, skip, num);
    }

    public List<ExecutableFlow> fetchFlowHistory(int projectId, String flowId, long startTime) throws ExecutorManagerException {
        return this.executionFlowDao.fetchFlowHistory(projectId, flowId, startTime);
    }

    @Override
    public List<ExecutableFlow> fetchFlowHistory(int projectId, String flowId, int skip, int num, Status status) throws ExecutorManagerException {
        return this.executionFlowDao.fetchFlowHistory(projectId, flowId, skip, num, status);
    }

    @Override
    public List<ExecutableFlow> fetchFlowHistory(int skip, int num) throws ExecutorManagerException {
        return this.executionFlowDao.fetchFlowHistory(skip, num);
    }

    @Override
    public List<ExecutableFlow> fetchMaintainedFlowHistory(String username, List<Integer> projectIds, int skip, int size) throws ExecutorManagerException {
        return this.executionFlowDao.fetchMaintainedFlowHistory(username, projectIds, skip, size);
    }

    @Override
    public List<ExecutableFlow> fetchFlowHistory(String projContain, String flowContains, String execIdContain, String userNameContains, String status, long startTime, long endTime, int skip, int num, int flowType) throws ExecutorManagerException {
        return this.executionFlowDao.fetchFlowHistory(projContain, flowContains, execIdContain, userNameContains, status, startTime, endTime, skip, num, flowType);
    }

    @Override
    public List<ExecutableFlow> fetchMaintainedFlowHistory(String projContain, String flowContains, String execIdContain, String userNameContains, String status, long startTime, long endTime, int skip, int num, int flowType, String username, List<Integer> projectIds) throws ExecutorManagerException {
        return this.executionFlowDao.fetchMaintainedFlowHistory(projContain, flowContains, execIdContain, userNameContains, status, startTime, endTime, skip, num, flowType, username, projectIds);
    }

    @Override
    public List<ExecutableFlow> fetchFlowHistoryQuickSearch(String searchContains, String userNameContains, int skip, int num) throws ExecutorManagerException {
        return this.executionFlowDao.fetchFlowHistoryQuickSearch(searchContains, userNameContains, skip, num);
    }

    @Override
    public List<ExecutableFlow> fetchFlowHistoryQuickSearch(String searchContains, String username, int skip, int num, List<Integer> projectIds) throws ExecutorManagerException {
        return this.executionFlowDao.fetchFlowHistoryQuickSearch(searchContains, username, skip, num, projectIds);
    }

    @Override
    public List<ExecutableFlow> fetchFlowAllHistory(int projectId, String flowId, String user) throws ExecutorManagerException {
        return this.executionFlowDao.fetchFlowAllHistory(projectId, flowId, user);
    }

    @Override
    public void addActiveExecutableReference(ExecutionReference reference) throws ExecutorManagerException {
        this.activeExecutingFlowsDao.addActiveExecutableReference(reference);
    }

    @Override
    public void removeActiveExecutableReference(int execid) throws ExecutorManagerException {
        this.activeExecutingFlowsDao.removeActiveExecutableReference(execid);
    }

    @Override
    public boolean updateExecutableReference(int execId, long updateTime) throws ExecutorManagerException {
        return this.activeExecutingFlowsDao.updateExecutableReference(execId, updateTime);
    }

    @Override
    public void uploadExecutableNode(ExecutableNode node, Props inputProps) throws ExecutorManagerException {
        this.executionJobDao.uploadExecutableNode(node, inputProps);
    }

    @Override
    public void updateExecutableNode(ExecutableNode node) throws ExecutorManagerException {
        this.executionJobDao.updateExecutableNode(node);
    }

    @Override
    public List<ExecutableJobInfo> fetchJobInfoAttempts(int execId, String jobId) throws ExecutorManagerException {
        return this.executionJobDao.fetchJobInfoAttempts(execId, jobId);
    }

    @Override
    public ExecutableJobInfo fetchJobInfo(int execId, String jobId, int attempts) throws ExecutorManagerException {
        return this.executionJobDao.fetchJobInfo(execId, jobId, attempts);
    }

    @Override
    public Props fetchExecutionJobInputProps(int execId, String jobId) throws ExecutorManagerException {
        return this.executionJobDao.fetchExecutionJobInputProps(execId, jobId);
    }

    @Override
    public Props fetchExecutionJobOutputProps(int execId, String jobId) throws ExecutorManagerException {
        return this.executionJobDao.fetchExecutionJobOutputProps(execId, jobId);
    }

    @Override
    public Pair<Props, Props> fetchExecutionJobProps(int execId, String jobId) throws ExecutorManagerException {
        return this.executionJobDao.fetchExecutionJobProps(execId, jobId);
    }

    @Override
    public List<ExecutableJobInfo> fetchJobHistory(int projectId, String jobId, int skip, int size) throws ExecutorManagerException {
        return this.executionJobDao.fetchJobHistory(projectId, jobId, skip, size);
    }

    @Override
    public List<ExecutableJobInfo> fetchJobAllHistory(int projectId, String jobId) throws ExecutorManagerException {
        return this.executionJobDao.fetchJobAllHistory(projectId, jobId);
    }

    @Override
    public Long getJobLogOffset(int execId, String jobName, int attempt, Long length) throws ExecutorManagerException {
        Long maxSize = this.executionLogsDao.getJobLogMaxSize(execId, jobName, attempt);
        return maxSize - length > 0L ? maxSize - length : 0L;
    }

    @Override
    public FileIOUtils.LogData fetchLogs(int execId, String name, int attempt, int startByte, int length) throws ExecutorManagerException {
        return this.executionLogsDao.fetchLogs(execId, name, attempt, startByte, length);
    }

    @Override
    public List<Object> fetchAttachments(int execId, String jobId, int attempt) throws ExecutorManagerException {
        return this.executionJobDao.fetchAttachments(execId, jobId, attempt);
    }

    @Override
    public void uploadLogFile(int execId, String name, int attempt, File ... files) throws ExecutorManagerException {
        this.executionLogsDao.uploadLogFile(execId, name, attempt, files);
    }

    @Override
    public void uploadAttachmentFile(ExecutableNode node, File file) throws ExecutorManagerException {
        this.executionJobDao.uploadAttachmentFile(node, file);
    }

    @Override
    public List<Executor> fetchAllExecutors() throws ExecutorManagerException {
        return this.executorDao.fetchAllExecutors();
    }

    @Override
    public List<Executor> fetchActiveExecutors() throws ExecutorManagerException {
        return this.executorDao.fetchActiveExecutors();
    }

    @Override
    public Executor fetchExecutor(String host, int port) throws ExecutorManagerException {
        return this.executorDao.fetchExecutor(host, port);
    }

    @Override
    public Executor fetchExecutor(int executorId) throws ExecutorManagerException {
        return this.executorDao.fetchExecutor(executorId);
    }

    @Override
    public void updateExecutor(Executor executor) throws ExecutorManagerException {
        this.executorDao.updateExecutor(executor);
    }

    @Override
    public Executor addExecutor(String host, int port) throws ExecutorManagerException {
        return this.executorDao.addExecutor(host, port);
    }

    @Override
    public void removeExecutor(String host, int port) throws ExecutorManagerException {
        this.executorDao.removeExecutor(host, port);
    }

    @Override
    public void postExecutorEvent(Executor executor, ExecutorLogEvent.EventType type, String user, String message) throws ExecutorManagerException {
        this.executorEventsDao.postExecutorEvent(executor, type, user, message);
    }

    @Override
    public List<ExecutorLogEvent> getExecutorEvents(Executor executor, int num, int offset) throws ExecutorManagerException {
        return this.executorEventsDao.getExecutorEvents(executor, num, offset);
    }

    @Override
    public void assignExecutor(int executorId, int executionId) throws ExecutorManagerException {
        this.assignExecutorDao.assignExecutor(executorId, executionId);
    }

    @Override
    public Executor fetchExecutorByExecutionId(int executionId) throws ExecutorManagerException {
        return this.executorDao.fetchExecutorByExecutionId(executionId);
    }

    @Override
    public int removeExecutionLogsByTime(long millis) throws ExecutorManagerException {
        return this.executionLogsDao.removeExecutionLogsByTime(millis);
    }

    @Override
    public void unassignExecutor(int executionId) throws ExecutorManagerException {
        this.assignExecutorDao.unassignExecutor(executionId);
    }

    @Override
    public int selectAndUpdateExecution(int executorId, boolean isActive) throws ExecutorManagerException {
        return this.executionFlowDao.selectAndUpdateExecution(executorId, isActive);
    }

    @Override
    public void unsetExecutorIdForExecution(int executionId) throws ExecutorManagerException {
        this.executionFlowDao.unsetExecutorIdForExecution(executionId);
    }

    @Override
    public List<ExecutableFlow> fetchUserFlowHistory(int skip, int num, String user) throws ExecutorManagerException {
        return this.executionFlowDao.fetchUserFlowHistory(skip, num, user);
    }

    @Override
    public List<ExecutableFlow> fetchUserFlowHistoryByAdvanceFilter(String projContain, String flowContains, String execIdContain, String userNameContains, String status, long startTime, long endTime, int skip, int num, int flowType) throws ExecutorManagerException {
        return this.executionFlowDao.fetchUserFlowHistoryByAdvanceFilter(projContain, flowContains, execIdContain, userNameContains, status, startTime, endTime, skip, num, flowType);
    }

    @Override
    public List<ExecutableFlow> fetchHistoryRecoverFlows(String userNameContains) throws ExecutorManagerException {
        return this.executionFlowDao.fetchHistoryRecoverFlows(userNameContains);
    }

    @Override
    public List<ExecutableFlow> fetchHistoryRecoverFlowByRepeatId(String repeatId) throws ExecutorManagerException {
        return this.executionFlowDao.fetchHistoryRecoverFlowByRepeatId(repeatId);
    }

    @Override
    public List<ExecutableFlow> fetchHistoryRecoverFlowByFlowId(String flowId, String projectId) throws ExecutorManagerException {
        return this.executionFlowDao.fetchHistoryRecoverFlowByFlowId(flowId, projectId);
    }

    @Override
    public List<ExecutionRecover> listHistoryRecoverFlows(Map paramMap, int skip, int num) throws ExecutorManagerException {
        return this.executionRecoverDao.listHistoryRecoverFlows(paramMap, skip, num);
    }

    @Override
    public List<ExecutionRecover> listMaintainedHistoryRecoverFlows(String username, List<Integer> projectIds, int skip, int num) throws ExecutorManagerException {
        return this.executionRecoverDao.listMaintainedHistoryRecoverFlows(username, projectIds, skip, num);
    }

    @Override
    public Integer saveHistoryRecoverFlow(ExecutionRecover executionRecover) throws ExecutorManagerException {
        return this.executionRecoverDao.uploadExecutableRecoverFlow(executionRecover);
    }

    @Override
    public void updateHistoryRecover(ExecutionRecover executionRecover) throws ExecutorManagerException {
        this.executionRecoverDao.updateExecutableRecoverFlow(executionRecover);
    }

    @Override
    public ExecutionRecover getHistoryRecoverFlow(Integer recoverId) throws ExecutorManagerException {
        return this.executionRecoverDao.getHistoryRecoverFlows(recoverId);
    }

    @Override
    public ExecutionRecover getHistoryRecoverFlowByPidAndFid(String projectId, String flowId) throws ExecutorManagerException {
        return this.executionRecoverDao.getHistoryRecoverFlowByPidAndFid(projectId, flowId);
    }

    @Override
    public List<ExecutionRecover> listHistoryRecoverRunnning(Integer loadSize) throws ExecutorManagerException {
        ArrayList<ExecutionRecover> allWaitRunning = new ArrayList<ExecutionRecover>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("recoverStatus", Status.RUNNING.getNumVal() + "");
        paramMap.put("limitNum", loadSize + "");
        allWaitRunning.addAll(this.executionRecoverDao.listHistoryRecover(paramMap));
        paramMap.put("recoverStatus", Status.PREPARING.getNumVal() + "");
        allWaitRunning.addAll(this.executionRecoverDao.listHistoryRecover(paramMap));
        return allWaitRunning;
    }

    @Override
    public int getExecutionCycleTotal(Optional<String> usernameOp) throws ExecutorManagerException {
        return this.executionCycleDao.getCycleFlowsTotal(usernameOp);
    }

    @Override
    public int getExecutionCycleTotal(String username, List<Integer> projectIds) throws ExecutorManagerException {
        return this.executionCycleDao.getCycleFlowsTotal(username, projectIds);
    }

    @Override
    public List<ExecutionCycle> listExecutionCycleFlows(Optional<String> username, int offset, int length) throws ExecutorManagerException {
        return this.executionCycleDao.listCycleFlows(username, offset, length);
    }

    @Override
    public List<ExecutionCycle> listExecutionCycleFlows(String username, List<Integer> projectIds, int offset, int length) throws ExecutorManagerException {
        return this.executionCycleDao.listCycleFlows(username, projectIds, offset, length);
    }

    @Override
    public int saveExecutionCycleFlow(ExecutionCycle cycleFlow) throws ExecutorManagerException {
        return this.executionCycleDao.uploadCycleFlow(cycleFlow);
    }

    @Override
    public ExecutionCycle getExecutionCycleFlow(String projectId, String flowId) throws ExecutorManagerException {
        return this.executionCycleDao.getExecutionCycleFlow(projectId, flowId);
    }

    @Override
    public ExecutionCycle getExecutionCycleFlow(int id) throws ExecutorManagerException {
        return this.executionCycleDao.getExecutionCycleFlow(id);
    }

    @Override
    public int updateExecutionFlow(ExecutionCycle cycleFlow) throws ExecutorManagerException {
        return this.executionCycleDao.updateCycleFlow(cycleFlow);
    }

    @Override
    public int stopAllCycleFlows() throws ExecutorManagerException {
        return this.executionCycleDao.stopAllCycleFlows();
    }

    @Override
    public List<ExecutionCycle> getAllRunningCycleFlows() throws ExecutorManagerException {
        return this.executionCycleDao.getAllRunningCycleFlows();
    }

    @Override
    public int getHistoryRecoverTotal() throws ExecutorManagerException {
        return this.executionRecoverDao.getHistoryRecoverTotal();
    }

    @Override
    public ExecutableFlow getProjectLastExecutableFlow(int projectId, String flowId) throws ExecutorManagerException {
        List<ExecutableFlow> flows = this.executionFlowDao.getProjectLastExecutableFlow(projectId, flowId);
        if (flows.size() > 0) {
            return flows.get(0);
        }
        return null;
    }

    @Override
    public int getUserRecoverHistoryTotal(String userName) throws ExecutorManagerException {
        return this.executionRecoverDao.getUserHistoryRecoverTotal(userName);
    }

    @Override
    public int getMaintainedHistoryRecoverTotal(String username, List<Integer> maintainedProjectIds) throws ExecutorManagerException {
        return this.executionRecoverDao.getMaintainedHistoryRecoverTotal(username, maintainedProjectIds);
    }

    @Override
    public FileIOUtils.LogData fetchAllLogs(int execId, String name, int attempt) throws ExecutorManagerException {
        return this.executionLogsDao.fetchAllLogs(execId, name, attempt);
    }

    @Override
    public Executor addExecutorFixed(int id, String host, int port) throws ExecutorManagerException {
        return this.executorDao.addExecutorFixed(id, host, port);
    }

    @Override
    public List<LogFilterEntity> listAllLogFilter() throws ExecutorManagerException {
        return this.logFilterDao.listAllLogFilter();
    }

    @Override
    public int getExecHistoryTotal(Map<String, String> filterMap) throws ExecutorManagerException {
        return this.executionRecoverDao.getExecHistoryTotal(filterMap);
    }

    @Override
    public int getExecHistoryTotal(String username, Map<String, String> filterMap, List<Integer> projectIds) throws ExecutorManagerException {
        return this.executionRecoverDao.getExecHistoryTotal(username, filterMap, projectIds);
    }

    @Override
    public int getMaintainedExecHistoryTotal(String username, List<Integer> projectIds) throws ExecutorManagerException {
        return this.executionRecoverDao.getMaintainedExecHistoryTotal(username, projectIds);
    }

    @Override
    public int getExecHistoryQuickSerachTotal(Map<String, String> filterMap) throws ExecutorManagerException {
        return this.executionRecoverDao.getExecHistoryQuickSerachTotal(filterMap);
    }

    @Override
    public int getMaintainedFlowsQuickSearchTotal(String username, Map<String, String> filterMap, List<Integer> projectIds) throws ExecutorManagerException {
        return this.executionRecoverDao.getMaintainedFlowsQuickSearchTotal(username, filterMap, projectIds);
    }

    @Override
    public List<ExecutableFlow> fetchUserFlowHistoryByProjectIdAndFlowId(int projectId, String flowId, int skip, int num, String userName) throws ExecutorManagerException {
        return this.executionFlowDao.fetchUserFlowHistoryByProjectIdAndFlowId(projectId, flowId, skip, num, userName);
    }

    @Override
    public int fetchNumUserExecutableFlowsByProjectIdAndFlowId(int projectId, String flowId, String userName) throws ExecutorManagerException {
        return this.numExecutionsDao.fetchNumUserExecutableFlowsByProjectIdAndFlowId(projectId, flowId, userName);
    }

    @Override
    public int getUserExecHistoryTotal(Map<String, String> filterMap) throws ExecutorManagerException {
        return this.executionRecoverDao.getUserExecHistoryTotal(filterMap);
    }

    @Override
    public int getUserExecHistoryQuickSerachTotal(Map<String, String> filterMap) throws ExecutorManagerException {
        return this.executionRecoverDao.getUserExecHistoryQuickSerachTotal(filterMap);
    }

    @Override
    public List<ExecutableFlow> fetchUserFlowHistory(String loginUser, String projContain, String flowContains, String execIdContain, String userNameContains, String status, long startTime, long endTime, int skip, int num, int flowType) throws ExecutorManagerException {
        return this.executionFlowDao.fetchUserFlowHistory(loginUser, projContain, flowContains, execIdContain, userNameContains, status, startTime, endTime, skip, num, flowType);
    }

    @Override
    public List<ExecutableFlow> getTodayExecutableFlowData(String userName) throws ExecutorManagerException {
        return this.executionFlowDao.getTodayExecutableFlowData(userName);
    }

    @Override
    public List<ExecutableFlow> getRealTimeExecFlowData(String userName) throws ExecutorManagerException {
        return this.executionFlowDao.getRealTimeExecFlowDataDao(userName);
    }

    @Override
    public List<ExecutableFlow> getTodayExecutableFlowDataNew(String userName) throws ExecutorManagerException {
        return this.executionFlowDao.getTodayExecutableFlowDataNew(userName);
    }

    @Override
    public Integer getTodayFlowRunTimesByFlowId(String projectId, String flowId, String usename) throws ExecutorManagerException {
        return this.executionFlowDao.getTodayFlowRunTimesByFlowId(projectId, flowId, usename);
    }

    @Override
    public List<ExecutionRecover> fetchHistoryRecoverFlows() throws ExecutorManagerException {
        return this.executionRecoverDao.fetchHistoryRecover();
    }

    @Override
    public List<RecoverTrigger> fetchHistoryRecoverTriggers() {
        List<RecoverTrigger> recoverTriggers = new ArrayList<RecoverTrigger>();
        try {
            recoverTriggers = this.executionRecoverDao.fetchHistoryRecover().stream().map(x -> new RecoverTrigger((ExecutionRecover)x)).collect(Collectors.toList());
        }
        catch (ExecutorManagerException eme) {
            logger.error("fetch history recover trigger failed.", (Throwable)eme);
        }
        return recoverTriggers;
    }

    @Override
    public List<Integer> getExecutorIdsBySubmitUser(String submitUser) throws ExecutorManagerException {
        return this.departmentGroupDao.fetchExecutorsIdSBySubmitUser(submitUser);
    }

    @Override
    public List<DepartmentGroup> fetchAllDepartmentGroup() throws ExecutorManagerException {
        return this.departmentGroupDao.fetchAllDepartmentGroup();
    }

    @Override
    public void addDepartmentGroup(DepartmentGroup departmentGroup) throws ExecutorManagerException {
        this.departmentGroupDao.addDepartmentGroup(departmentGroup);
    }

    @Override
    public boolean checkGroupNameIsExist(DepartmentGroup departmentGroup) throws ExecutorManagerException {
        return this.departmentGroupDao.checkGroupNameIsExist(departmentGroup);
    }

    @Override
    public boolean checkExecutorIsUsed(int executorId) throws ExecutorManagerException {
        return this.departmentGroupDao.checkExecutorIsUsed(executorId);
    }

    @Override
    public int deleteDepartmentGroup(DepartmentGroup departmentGroup) throws ExecutorManagerException {
        return this.departmentGroupDao.deleteDepartmentGroup(departmentGroup);
    }

    @Override
    public int updateDepartmentGroup(DepartmentGroup departmentGroup) throws ExecutorManagerException {
        return this.departmentGroupDao.updateDepartmentGroup(departmentGroup);
    }

    @Override
    public DepartmentGroup fetchDepartmentGroupById(Integer id) throws ExecutorManagerException {
        return this.departmentGroupDao.fetchDepartmentGroupById(id);
    }

    @Override
    public int groupIdIsExist(DepartmentGroup departmentGroup) throws ExecutorManagerException {
        return this.departmentGroupDao.groupIdIsExist(departmentGroup);
    }

    @Override
    public void addUserVariable(UserVariable userVariable) throws ExecutorManagerException {
        this.userVariableDao.addUserVariable(userVariable);
    }

    @Override
    public int deleteUserVariable(UserVariable variable) throws ExecutorManagerException {
        return this.userVariableDao.deleteUserVariable(variable);
    }

    @Override
    public int updateUserVariable(UserVariable userVariable) throws ExecutorManagerException {
        return this.userVariableDao.updateUserVariable(userVariable);
    }

    @Override
    public List<UserVariable> fetchAllUserVariable(UserVariable userVariable) throws ExecutorManagerException {
        return this.userVariableDao.fetchAllUserVariable(userVariable);
    }

    @Override
    public UserVariable getUserVariableById(Integer id) throws ExecutorManagerException {
        return this.userVariableDao.getUserVariableById(id);
    }

    @Override
    public Map<String, String> getUserVariableByName(String userName) throws ExecutorManagerException {
        return this.userVariableDao.getUserVariableByName(userName);
    }

    @Override
    public Integer findWtssUserByName(String name) throws ExecutorManagerException {
        return this.userVariableDao.findWtssUserByName(name);
    }

    @Override
    public Integer getWtssUserTotal() throws ExecutorManagerException {
        return this.userVariableDao.getWtssUserTotal();
    }

    @Override
    public List<WtssUser> findAllWtssUserPageList(String searchName, int pageNum, int pageSize) throws ExecutorManagerException {
        return this.userVariableDao.findAllWtssUserPageList(searchName, pageNum, pageSize);
    }

    @Override
    public List<UserVariable> fetchAllUserVariableByOwnerDepartment(Integer departmentId) throws ExecutorManagerException {
        return this.userVariableDao.fetchAllUserVariableByOwnerDepartment(departmentId);
    }
}

