/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableJobInfo;
import azkaban.executor.Executor;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.Status;
import azkaban.history.ExecutionRecover;
import azkaban.project.Project;
import azkaban.user.User;
import azkaban.utils.FileIOUtils;
import azkaban.utils.Pair;
import azkaban.utils.Props;
import com.webank.wedatasphere.schedulis.common.executor.ExecutionCycle;
import com.webank.wedatasphere.schedulis.common.log.LogFilterEntity;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface ExecutorManagerAdapter {
    public List<Integer> fetchPermissionsProjectId(String var1);

    public Props getAzkabanProps();

    public boolean isFlowRunning(int var1, String var2) throws ExecutorManagerException;

    public ExecutableFlow getExecutableFlow(int var1) throws ExecutorManagerException;

    public List<ExecutableFlow> getExecutableFlowByRepeatId(int var1) throws ExecutorManagerException;

    public List<Integer> getRunningFlows(int var1, String var2);

    public List<ExecutableFlow> getRunningFlows();

    public long getQueuedFlowSize();

    public List<Pair<ExecutableFlow, Optional<Executor>>> getActiveFlowsWithExecutor() throws IOException;

    public List<ExecutableFlow> getRecentlyFinishedFlows();

    public List<ExecutableFlow> getExecutableFlows(Project var1, String var2, int var3, int var4) throws ExecutorManagerException;

    public List<ExecutableFlow> getExecutableFlows(int var1, int var2) throws ExecutorManagerException;

    public List<ExecutableFlow> getMaintainedExecutableFlows(String var1, List<Integer> var2, int var3, int var4) throws ExecutorManagerException;

    public List<ExecutableFlow> getExecutableFlowsQuickSearch(String var1, int var2, int var3) throws ExecutorManagerException;

    public List<ExecutableFlow> getMaintainedFlowsQuickSearch(String var1, int var2, int var3, String var4, List<Integer> var5) throws ExecutorManagerException;

    public List<ExecutableFlow> getExecutableFlows(String var1, String var2, String var3, String var4, String var5, long var6, long var8, int var10, int var11, int var12) throws ExecutorManagerException;

    public List<ExecutableFlow> getMaintainedExecutableFlows(String var1, String var2, String var3, String var4, String var5, long var6, long var8, int var10, int var11, int var12, String var13, List<Integer> var14) throws ExecutorManagerException;

    public int getExecutableFlows(int var1, String var2, int var3, int var4, List<ExecutableFlow> var5) throws ExecutorManagerException;

    public List<ExecutableFlow> getExecutableFlows(int var1, String var2, int var3, int var4, Status var5) throws ExecutorManagerException;

    public List<ExecutableJobInfo> getExecutableJobs(Project var1, String var2, int var3, int var4) throws ExecutorManagerException;

    public long getExecutableJobsMoyenneRunTime(Project var1, String var2) throws ExecutorManagerException;

    public int getNumberOfJobExecutions(Project var1, String var2) throws ExecutorManagerException;

    public int getNumberOfExecutions(Project var1, String var2) throws ExecutorManagerException;

    public FileIOUtils.LogData getExecutableFlowLog(ExecutableFlow var1, int var2, int var3) throws ExecutorManagerException;

    public FileIOUtils.LogData getExecutionJobLog(ExecutableFlow var1, String var2, int var3, int var4, int var5) throws ExecutorManagerException;

    public Long getLatestLogOffset(ExecutableFlow var1, String var2, Long var3, int var4, User var5) throws ExecutorManagerException;

    public List<Object> getExecutionJobStats(ExecutableFlow var1, String var2, int var3) throws ExecutorManagerException;

    public String getJobLinkUrl(ExecutableFlow var1, String var2, int var3);

    public FileIOUtils.JobMetaData getExecutionJobMetaData(ExecutableFlow var1, String var2, int var3, int var4, int var5) throws ExecutorManagerException;

    public void cancelFlow(ExecutableFlow var1, String var2) throws ExecutorManagerException;

    public void resumeFlow(ExecutableFlow var1, String var2) throws ExecutorManagerException;

    public void setFlowFailed(ExecutableFlow var1, String var2, List<Pair<String, String>> var3) throws Exception;

    public String retryFailedJobs(ExecutableFlow var1, String var2, String var3) throws Exception;

    public String setJobDisabled(ExecutableFlow var1, String var2, String var3) throws Exception;

    public String skipFailedJobs(ExecutableFlow var1, String var2, String var3) throws Exception;

    public void pauseFlow(ExecutableFlow var1, String var2) throws ExecutorManagerException;

    public void pauseExecutingJobs(ExecutableFlow var1, String var2, String ... var3) throws ExecutorManagerException;

    public void resumeExecutingJobs(ExecutableFlow var1, String var2, String ... var3) throws ExecutorManagerException;

    public void retryFailures(ExecutableFlow var1, String var2) throws ExecutorManagerException;

    public void skipAllFailures(ExecutableFlow var1, String var2) throws ExecutorManagerException;

    public void retryExecutingJobs(ExecutableFlow var1, String var2, String ... var3) throws ExecutorManagerException;

    public void disableExecutingJobs(ExecutableFlow var1, String var2, String ... var3) throws ExecutorManagerException;

    public void enableExecutingJobs(ExecutableFlow var1, String var2, String ... var3) throws ExecutorManagerException;

    public void cancelExecutingJobs(ExecutableFlow var1, String var2, String ... var3) throws ExecutorManagerException;

    public String submitExecutableFlow(ExecutableFlow var1, String var2) throws ExecutorManagerException;

    public Map<String, Object> callExecutorStats(int var1, String var2, Pair<String, String> ... var3) throws IOException, ExecutorManagerException;

    public Map<String, Object> callExecutorJMX(String var1, String var2, String var3) throws IOException;

    public void start() throws ExecutorManagerException;

    public void shutdown();

    public Set<String> getAllActiveExecutorServerHosts();

    public Thread.State getExecutorManagerThreadState();

    public boolean isExecutorManagerThreadActive();

    public long getLastExecutorManagerThreadCheckTime();

    public Set<? extends String> getPrimaryServerHosts();

    public Collection<Executor> getAllActiveExecutors();

    public Executor fetchExecutor(int var1) throws ExecutorManagerException;

    public void setupExecutors() throws ExecutorManagerException;

    public void enableQueueProcessorThread() throws ExecutorManagerException;

    public void disableQueueProcessorThread() throws ExecutorManagerException;

    public String getAllExecutionJobLog(ExecutableFlow var1, String var2, int var3) throws ExecutorManagerException;

    public List<ExecutableFlow> getUserExecutableFlows(int var1, int var2, String var3) throws ExecutorManagerException;

    public List<ExecutableFlow> getUserExecutableFlowsByAdvanceFilter(String var1, String var2, String var3, String var4, String var5, long var6, long var8, int var10, int var11, int var12) throws ExecutorManagerException;

    public List<ExecutableFlow> getUserExecutableFlowsQuickSearch(String var1, String var2, int var3, int var4) throws ExecutorManagerException;

    public List<ExecutableFlow> getHistoryRecoverExecutableFlows(String var1) throws ExecutorManagerException;

    public ExecutableFlow getHistoryRecoverExecutableFlowsByRepeatId(String var1) throws ExecutorManagerException;

    public void stopHistoryRecoverExecutableFlowByRepeatId(String var1) throws ExecutorManagerException;

    public ExecutableFlow getHistoryRecoverExecutableFlowsByFlowId(String var1, String var2) throws ExecutorManagerException;

    public List<ExecutionRecover> listHistoryRecoverFlows(Map var1, int var2, int var3) throws ExecutorManagerException;

    public List<ExecutionRecover> listMaintainedHistoryRecoverFlows(String var1, List<Integer> var2, int var3, int var4) throws ExecutorManagerException;

    public Integer saveHistoryRecoverFlow(ExecutionRecover var1) throws ExecutorManagerException;

    public void updateHistoryRecover(ExecutionRecover var1) throws ExecutorManagerException;

    public ExecutionRecover getHistoryRecoverFlow(Integer var1) throws ExecutorManagerException;

    public ExecutionRecover getHistoryRecoverFlowByPidAndFid(String var1, String var2) throws ExecutorManagerException;

    public List<ExecutionRecover> listHistoryRecoverRunnning(Integer var1) throws ExecutorManagerException;

    public int getHistoryRecoverTotal() throws ExecutorManagerException;

    public ExecutableFlow getProjectLastExecutableFlow(int var1, String var2) throws ExecutorManagerException;

    public int getUserHistoryRecoverTotal(String var1) throws ExecutorManagerException;

    public int getMaintainedHistoryRecoverTotal(String var1, List<Integer> var2) throws ExecutorManagerException;

    public String getDownLoadAllExecutionLog(ExecutableFlow var1) throws ExecutorManagerException;

    public String getJobLogByJobId(int var1, String var2) throws ExecutorManagerException;

    public List<LogFilterEntity> listAllLogFilter() throws ExecutorManagerException;

    public int getExecHistoryTotal(Map<String, String> var1) throws ExecutorManagerException;

    public int getExecHistoryTotal(String var1, Map<String, String> var2, List<Integer> var3) throws ExecutorManagerException;

    public int getMaintainedExecHistoryTotal(String var1, List<Integer> var2) throws ExecutorManagerException;

    public int getExecHistoryQuickSerachTotal(Map<String, String> var1) throws ExecutorManagerException;

    public int getMaintainedFlowsQuickSearchTotal(String var1, Map<String, String> var2, List<Integer> var3) throws ExecutorManagerException;

    public int getUserExecutableFlowsTotalByProjectIdAndFlowId(int var1, String var2, int var3, int var4, List<ExecutableFlow> var5, String var6) throws ExecutorManagerException;

    public long getExecutableFlowsMoyenneRunTime(int var1, String var2, String var3) throws ExecutorManagerException;

    public int getUserExecHistoryTotal(Map<String, String> var1) throws ExecutorManagerException;

    public int getUserExecHistoryQuickSerachTotal(Map<String, String> var1) throws ExecutorManagerException;

    public List<ExecutableFlow> getUserExecutableFlows(String var1, String var2, String var3, String var4, String var5, String var6, long var7, long var9, int var11, int var12, int var13) throws ExecutorManagerException;

    public List<ExecutableFlow> getTodayExecutableFlowData(String var1) throws ExecutorManagerException;

    public List<ExecutableFlow> getTodayExecutableFlowDataNew(String var1) throws ExecutorManagerException;

    public Integer getTodayFlowRunTimesByFlowId(String var1, String var2, String var3) throws ExecutorManagerException;

    public List<ExecutableFlow> getRealTimeExecFlowData(String var1) throws ExecutorManagerException;

    public ExecutableFlow getRecentExecutableFlow(int var1, String var2) throws ExecutorManagerException;

    public List<Map<String, String>> getExectingFlowsData() throws IOException;

    public int getExecutionCycleTotal(Optional<String> var1) throws ExecutorManagerException;

    public int getExecutionCycleTotal(String var1, List<Integer> var2) throws ExecutorManagerException;

    public List<ExecutionCycle> listExecutionCycleFlows(Optional<String> var1, int var2, int var3) throws ExecutorManagerException;

    public List<ExecutionCycle> listExecutionCycleFlows(String var1, List<Integer> var2, int var3, int var4) throws ExecutorManagerException;

    public int saveExecutionCycleFlow(ExecutionCycle var1) throws ExecutorManagerException;

    public ExecutionCycle getExecutionCycleFlow(String var1, String var2) throws ExecutorManagerException;

    public ExecutionCycle getExecutionCycleFlow(int var1) throws ExecutorManagerException;

    public int updateExecutionFlow(ExecutionCycle var1) throws ExecutorManagerException;

    public int stopAllCycleFlows() throws ExecutorManagerException;

    public List<ExecutionCycle> getAllRunningCycleFlows() throws ExecutorManagerException;
}

