/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutionReference;
import azkaban.executor.Executor;
import azkaban.executor.ExecutorApiClient;
import azkaban.executor.ExecutorManagerException;
import azkaban.utils.JSONUtils;
import azkaban.utils.Pair;
import azkaban.utils.Props;
import com.google.inject.Inject;
import com.webank.wedatasphere.schedulis.common.utils.JwtTokenUtils;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.codehaus.jackson.map.ObjectMapper;

@Singleton
public class ExecutorApiGateway {
    private final ExecutorApiClient apiClient;
    private final Props azkProps;

    @Inject
    public ExecutorApiGateway(ExecutorApiClient apiClient, Props azkProps) {
        this.apiClient = apiClient;
        this.azkProps = azkProps;
    }

    public Map<String, Object> callWithExecutable(ExecutableFlow exflow, Executor executor, String action) throws ExecutorManagerException {
        return this.callWithExecutionId(executor.getHost(), executor.getPort(), action, exflow.getExecutionId(), null, null);
    }

    public Map<String, Object> callWithReference(ExecutionReference ref, String action, Pair<String, String> ... params) throws ExecutorManagerException {
        Executor executor = ref.getExecutor().get();
        return this.callWithExecutionId(executor.getHost(), executor.getPort(), action, ref.getExecId(), null, params);
    }

    public Map<String, Object> callWithReferenceByUser(ExecutionReference ref, String action, String user, Pair<String, String> ... params) throws ExecutorManagerException {
        Executor executor = ref.getExecutor().get();
        return this.callWithExecutionId(executor.getHost(), executor.getPort(), action, ref.getExecId(), user, params);
    }

    public Map<String, Object> callWithExecutionId(String host, int port, String action, Integer executionId, String user, Pair<String, String> ... params) throws ExecutorManagerException {
        try {
            ArrayList<Pair<String, String>> paramList = new ArrayList<Pair<String, String>>();
            if (params != null) {
                paramList.addAll(Arrays.asList(params));
            }
            paramList.add(new Pair<String, String>("action", action));
            paramList.add(new Pair<String, String>("execid", String.valueOf(executionId)));
            paramList.add(new Pair<String, String>("user", user));
            if (this.azkProps.getBoolean("azkaban.ip.whiteList.enabled", false)) {
                String dss_secret = this.azkProps.getString("dss.secret", "dws-wtss|WeBankBDPWTSS&DWS@2019");
                String token = JwtTokenUtils.getToken(null, false, dss_secret, 300);
                paramList.add(new Pair<String, String>("token", token));
            }
            return this.callForJsonObjectMap(host, port, "/executor", paramList);
        }
        catch (IOException e) {
            throw new ExecutorManagerException(e);
        }
    }

    public <T> T callForJsonType(String host, int port, String path, List<Pair<String, String>> paramList, Class<T> valueType) throws IOException {
        String responseString = this.callForJsonString(host, port, path, paramList);
        if (null == responseString || responseString.length() == 0) {
            return null;
        }
        return (T)new ObjectMapper().readValue(responseString, valueType);
    }

    public Map<String, Object> callForJsonObjectMap(String host, int port, String path, List<Pair<String, String>> paramList) throws IOException {
        String responseString = this.callForJsonString(host, port, path, paramList);
        Map jsonResponse = (Map)JSONUtils.parseJSONFromString((String)responseString);
        String error = (String)jsonResponse.get("error");
        if (error != null) {
            throw new IOException(error);
        }
        return jsonResponse;
    }

    private String callForJsonString(String host, int port, String path, List<Pair<String, String>> paramList) throws IOException {
        if (paramList == null) {
            paramList = new ArrayList<Pair<String, String>>();
        }
        URI uri = ExecutorApiClient.buildUri(host, port, path, true, new Pair[0]);
        if (this.azkProps.getBoolean("azkaban.ip.whiteList.enabled", false)) {
            String dss_secret = this.azkProps.getString("dss.secret", "dws-wtss|WeBankBDPWTSS&DWS@2019");
            String token = JwtTokenUtils.getToken(null, false, dss_secret, 300);
            paramList.add(new Pair<String, String>("token", token));
        }
        return (String)this.apiClient.httpPost(uri, paramList);
    }

    public Map<String, Object> updateExecutions(Executor executor, List<ExecutableFlow> executions) throws ExecutorManagerException {
        ArrayList<Long> updateTimesList = new ArrayList<Long>();
        ArrayList<Integer> executionIdsList = new ArrayList<Integer>();
        for (ExecutableFlow flow : executions) {
            executionIdsList.add(flow.getExecutionId());
            updateTimesList.add(flow.getUpdateTime());
        }
        Pair<String, String> updateTimes = new Pair<String, String>("updatetime", JSONUtils.toJSON(updateTimesList));
        Pair<String, String> executionIds = new Pair<String, String>("executionId", JSONUtils.toJSON(executionIdsList));
        return this.callWithExecutionId(executor.getHost(), executor.getPort(), "update", null, null, executionIds, updateTimes);
    }

    public String httpPost(String actionUrl, String json) throws Exception {
        MediaType applicationJson = MediaType.parse((String)"application/json;charset=utf-8");
        RequestBody requestBody = RequestBody.create((MediaType)applicationJson, (String)json);
        OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).build();
        Request request = new Request.Builder().url(actionUrl).post(requestBody).build();
        Call call = okHttpClient.newCall(request);
        String ret = null;
        try (Response response = null;){
            response = call.execute();
            if (response.isSuccessful()) {
                ret = response.body().string();
            }
        }
        return ret;
    }
}

