/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.alert.Alerter;
import azkaban.executor.AlerterHolder;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutionOptions;
import azkaban.executor.ExecutorLoader;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.Status;
import azkaban.sla.SlaOption;
import com.webank.wedatasphere.schedulis.common.executor.ExecutionCycle;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionControllerUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionControllerUtils.class);

    public static void finalizeFlow(ExecutorLoader executorLoader, AlerterHolder alerterHolder, ExecutableFlow flow, String reason, @Nullable Throwable originalError) {
        boolean alertUser = true;
        try {
            ExecutableFlow dsFlow;
            if (ExecutionControllerUtils.isFinished(flow)) {
                dsFlow = flow;
            } else {
                dsFlow = executorLoader.fetchExecutableFlow(flow.getExecutionId());
                if (!ExecutionControllerUtils.isFinished(dsFlow)) {
                    ExecutionControllerUtils.failEverything(dsFlow);
                    executorLoader.updateExecutableFlow(dsFlow);
                }
            }
            if (flow.getEndTime() == -1L) {
                flow.setEndTime(System.currentTimeMillis());
                executorLoader.updateExecutableFlow(dsFlow);
            }
        }
        catch (ExecutorManagerException e) {
            alertUser = false;
            logger.error("Failed to finalize flow " + flow.getExecutionId() + ", do not alert user.", (Throwable)e);
        }
        if (alertUser) {
            ExecutionControllerUtils.alertUserOnFlowFinished(flow, alerterHolder, ExecutionControllerUtils.getFinalizeFlowReasons(reason, originalError));
        }
    }

    public static void alertUserOnFlowFinished(ExecutableFlow flow, AlerterHolder alerterHolder, String[] extraReasons) {
        ExecutionOptions options = flow.getExecutionOptions();
        Alerter mailAlerter = alerterHolder.get("email");
        if (null == mailAlerter) {
            mailAlerter = alerterHolder.get("default");
        }
        if (flow.getStatus() != Status.SUCCEEDED) {
            if (options.getFailureEmails() != null && !options.getFailureEmails().isEmpty()) {
                try {
                    mailAlerter.alertOnError(flow, extraReasons);
                }
                catch (Exception e) {
                    logger.error("Failed to alert on error for execution " + flow.getExecutionId(), (Throwable)e);
                }
            }
            if (options.getFlowParameters().containsKey("alert.type")) {
                Alerter alerter;
                String alertType = options.getFlowParameters().get("alert.type");
                Alerter alerter2 = alerter = alerterHolder.get(alertType) == null ? alerterHolder.get("default") : alerterHolder.get(alertType);
                if (alerter != null) {
                    try {
                        alerter.alertOnError(flow, extraReasons);
                    }
                    catch (Exception e) {
                        logger.error("Failed to alert on error by " + alertType + " for execution " + flow.getExecutionId(), (Throwable)e);
                    }
                } else {
                    logger.error("Alerter type " + alertType + " doesn't exist. Failed to alert.");
                }
            }
            ExecutionControllerUtils.handleFlowFinishAlert(flow, alerterHolder);
        } else {
            if (options.getSuccessEmails() != null && !options.getSuccessEmails().isEmpty()) {
                try {
                    mailAlerter.alertOnSuccess(flow);
                }
                catch (Exception e) {
                    logger.error("Failed to alert on success for execution " + flow.getExecutionId(), (Throwable)e);
                }
            }
            if (options.getFlowParameters().containsKey("alert.type")) {
                Alerter alerter;
                String alertType = options.getFlowParameters().get("alert.type");
                Alerter alerter3 = alerter = alerterHolder.get(alertType) == null ? alerterHolder.get("default") : alerterHolder.get(alertType);
                if (alerter != null) {
                    try {
                        alerter.alertOnSuccess(flow);
                    }
                    catch (Exception e) {
                        logger.error("Failed to alert on success by " + alertType + " for execution " + flow.getExecutionId(), (Throwable)e);
                    }
                } else {
                    logger.error("Alerter type " + alertType + " doesn't exist. Failed to alert.");
                }
            }
            ExecutionControllerUtils.handleFlowFinishAlert(flow, alerterHolder);
        }
    }

    public static void alertUserOnFirstError(ExecutableFlow flow, AlerterHolder alerterHolder) {
        ExecutionOptions options = flow.getExecutionOptions();
        List<String> emails = options.getFailureEmails();
        if (options.getNotifyOnFirstFailure() && emails.size() != 0) {
            logger.info("Alert on first error of execution " + flow.getExecutionId());
            Alerter mailAlerter = alerterHolder.get("email");
            if (null == mailAlerter) {
                mailAlerter = alerterHolder.get("default");
            }
            try {
                mailAlerter.alertOnFirstError(flow);
            }
            catch (Exception e) {
                logger.error("Failed to send first error email." + e.getMessage(), (Throwable)e);
            }
            if (options.getFlowParameters().containsKey("alert.type")) {
                Alerter alerter;
                String alertType = options.getFlowParameters().get("alert.type");
                Alerter alerter2 = alerter = alerterHolder.get(alertType) == null ? alerterHolder.get("default") : alerterHolder.get(alertType);
                if (alerter != null) {
                    try {
                        alerter.alertOnFirstError(flow);
                    }
                    catch (Exception e) {
                        logger.error("Failed to alert by " + alertType, (Throwable)e);
                    }
                } else {
                    logger.error("Alerter type " + alertType + " doesn't exist. Failed to alert.");
                }
            }
        }
        ExecutionControllerUtils.handleFlowFailedRunningAlert(flow, alerterHolder);
    }

    public static void handleFlowFailedRunningAlert(ExecutableFlow exflow, AlerterHolder alerterHolder) {
        List<SlaOption> slaOptionList = exflow.getSlaOptions();
        if (null != slaOptionList) {
            Alerter mailAlerter = alerterHolder.get("email");
            if (null == mailAlerter) {
                mailAlerter = alerterHolder.get("default");
            }
            for (SlaOption slaOption : slaOptionList) {
                String FlowName = ObjectUtils.toString((Object)slaOption.getInfo().get("FlowName"));
                String flowId = exflow.getFlowId();
                if (flowId.equals(FlowName) && "FlowFailureEmails".equals(slaOption.getType()) && exflow.getStatus() == Status.FAILED_FINISHING) {
                    logger.info("\u4efb\u52a1Flow\uff1a" + FlowName + " \u6267\u884cFAILED_FINISHING \u5f00\u59cb\u53d1\u9001 \u544a\u8b66");
                    try {
                        mailAlerter.alertOnFinishSla(slaOption, exflow);
                        alerterHolder.getFlowAlerterFlag().put(exflow.getExecutionId(), true);
                    }
                    catch (Exception e) {
                        logger.error("4\u3001\u53d1\u9001sla\u544a\u8b66\u5931\u8d25", (Throwable)e);
                    }
                    continue;
                }
                if (!flowId.equals(FlowName) || !"FlowFinishEmails".equals(slaOption.getType())) continue;
                logger.info("\u4efb\u52a1Flow\uff1a" + FlowName + " \u6267\u884c\u5b8c\u6210 \u5f00\u59cb\u53d1\u9001 \u544a\u8b66");
                try {
                    mailAlerter.alertOnFinishSla(slaOption, exflow);
                    alerterHolder.getFlowAlerterFlag().put(exflow.getExecutionId(), true);
                }
                catch (Exception e) {
                    logger.error("5\u3001\u53d1\u9001sla\u544a\u8b66\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    public static String[] getFinalizeFlowReasons(String reason, Throwable originalError) {
        LinkedList<String> reasons = new LinkedList<String>();
        reasons.add(reason);
        if (originalError != null) {
            reasons.add(ExceptionUtils.getStackTrace((Throwable)originalError));
        }
        return reasons.toArray(new String[reasons.size()]);
    }

    public static void failEverything(ExecutableFlow exFlow) {
        long time = System.currentTimeMillis();
        block4: for (ExecutableNode node : exFlow.getExecutableNodes()) {
            switch (node.getStatus()) {
                case SUCCEEDED: 
                case FAILED: 
                case KILLED: 
                case SKIPPED: 
                case DISABLED: 
                case FAILED_SKIPPED: 
                case RETRIED_SUCCEEDED: {
                    continue block4;
                }
                case READY: {
                    node.setStatus(Status.KILLING);
                    break;
                }
                default: {
                    node.setStatus(Status.FAILED);
                }
            }
            if (node.getStartTime() == -1L) {
                node.setStartTime(time);
            }
            if (node.getEndTime() != -1L) continue;
            node.setEndTime(time);
        }
        if (exFlow.getEndTime() == -1L) {
            exFlow.setEndTime(time);
        }
        exFlow.setStatus(Status.FAILED);
    }

    public static boolean isFinished(ExecutableFlow flow) {
        switch (flow.getStatus()) {
            case SUCCEEDED: 
            case FAILED: 
            case KILLED: 
            case RETRIED_SUCCEEDED: {
                return true;
            }
        }
        return false;
    }

    public static void handleFlowFinishAlert(ExecutableFlow exflow, AlerterHolder alerterHolder) {
        List<SlaOption> slaOptionList = exflow.getSlaOptions();
        if (null != slaOptionList) {
            Alerter mailAlerter = alerterHolder.get("email");
            if (null == mailAlerter) {
                mailAlerter = alerterHolder.get("default");
            }
            for (SlaOption slaOption : slaOptionList) {
                String FlowName = ObjectUtils.toString((Object)slaOption.getInfo().get("FlowName"));
                String flowId = exflow.getFlowId();
                if (flowId.equals(FlowName) && "FlowFailureEmails".equals(slaOption.getType()) && exflow.getStatus() == Status.FAILED && BooleanUtils.isNotTrue((Boolean)alerterHolder.getFlowAlerterFlag().get(exflow.getExecutionId()))) {
                    logger.info("\u4efb\u52a1Flow\uff1a" + FlowName + " \u6267\u884c\u5931\u8d25 \u5f00\u59cb\u53d1\u9001 \u544a\u8b66");
                    try {
                        mailAlerter.alertOnFinishSla(slaOption, exflow);
                    }
                    catch (Exception e) {
                        logger.error("1\u3001\u53d1\u9001sla\u544a\u8b66\u5931\u8d25", (Throwable)e);
                    }
                    continue;
                }
                if (flowId.equals(FlowName) && "FlowSuccessEmails".equals(slaOption.getType()) && exflow.getStatus() == Status.SUCCEEDED) {
                    logger.info("\u4efb\u52a1Flow\uff1a" + FlowName + " \u6267\u884c\u6210\u529f \u5f00\u59cb\u53d1\u9001 \u544a\u8b66");
                    try {
                        mailAlerter.alertOnFinishSla(slaOption, exflow);
                    }
                    catch (Exception e) {
                        logger.error("2\u3001\u53d1\u9001sla\u544a\u8b66\u5931\u8d25", (Throwable)e);
                    }
                    continue;
                }
                if (!flowId.equals(FlowName) || !"FlowFinishEmails".equals(slaOption.getType()) || !BooleanUtils.isNotTrue((Boolean)alerterHolder.getFlowAlerterFlag().get(exflow.getExecutionId()))) continue;
                logger.info("\u4efb\u52a1Flow\uff1a" + FlowName + " \u6267\u884c\u5b8c\u6210 \u5f00\u59cb\u53d1\u9001 \u544a\u8b66");
                try {
                    mailAlerter.alertOnFinishSla(slaOption, exflow);
                }
                catch (Exception e) {
                    logger.error("3\u3001\u53d1\u9001sla\u544a\u8b66\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    public static void handleFlowPausedAlert(ExecutableFlow exflow, AlerterHolder alerterHolder, String nodePath) {
        ExecutionOptions options = exflow.getExecutionOptions();
        Alerter mailAlerter = alerterHolder.get("email");
        if (null == mailAlerter) {
            mailAlerter = alerterHolder.get("default");
        }
        try {
            if (options.getNotifyOnFirstFailure() && options.getFailureEmails() != null && !options.getFailureEmails().isEmpty()) {
                mailAlerter.alertOnFlowPaused(exflow, nodePath);
            } else {
                logger.info("\u6ca1\u6709\u8bbe\u7f6e\u901a\u7528\u544a\u8b66;");
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u5931\u8d25\u6682\u505c\u544a\u8b66\uff0c\u5931\u8d25", (Throwable)e);
        }
        List<SlaOption> slaOptionList = exflow.getSlaOptions();
        if (null != slaOptionList) {
            for (SlaOption slaOption : slaOptionList) {
                if (!"FlowFailureEmails".equals(slaOption.getType())) continue;
                String FlowName = ObjectUtils.toString((Object)slaOption.getInfo().get("FlowName"));
                String flowId = exflow.getFlowId();
                if (!flowId.equals(FlowName)) continue;
                logger.info("\u4efb\u52a1Flow\uff1a" + FlowName + " \u6267\u884c\u5931\u8d25 \u4efb\u52a1\u5df2\u7ecf\u6682\u505c \u5f00\u59cb\u53d1\u9001 \u544a\u8b66");
                try {
                    mailAlerter.alertOnFlowPausedSla(slaOption, exflow, nodePath);
                }
                catch (Exception e) {
                    logger.error("\u53d1\u9001sla\u544a\u8b66\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    public static void alertOnCycleFlowInterrupt(ExecutableFlow flow, ExecutionCycle cycleFlow, AlerterHolder alerterHolder) {
        try {
            Alerter mailAlerter = alerterHolder.get("email");
            if (null == mailAlerter) {
                mailAlerter = alerterHolder.get("default");
            }
            String extraReasons = "cycle flow, project name : %s, flow name : is terminate!!!";
            Map<String, String> cycleOption = flow.getCycleOption();
            String cycleFlowInterruptEmails = cycleOption.get("cycleFlowInterruptEmails");
            if (cycleFlowInterruptEmails == null || cycleFlowInterruptEmails.isEmpty()) {
                cycleFlowInterruptEmails = flow.getSubmitUser();
            }
            List<String> failureEmails = Arrays.asList(cycleFlowInterruptEmails.split("\\s*,\\s*|\\s*;\\s*|\\s+"));
            String alertLevel = cycleOption.getOrDefault("cycleFlowInterruptAlertLevel", "MAJOR");
            cycleFlow.setStatus(Status.FAILED);
            mailAlerter.alertOnCycleFlowInterrupt(flow, cycleFlow, failureEmails, alertLevel, extraReasons);
        }
        catch (Exception e) {
            logger.error("Failed to alert on error for execution " + flow.getExecutionId(), (Throwable)e);
        }
    }
}

