/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableFlowBase;
import azkaban.executor.ExecutionAttempt;
import azkaban.executor.Status;
import azkaban.flow.ConditionOnJobStatus;
import azkaban.flow.Node;
import azkaban.utils.Props;
import azkaban.utils.PropsUtils;
import azkaban.utils.TypedMapWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutableNode {
    public static final String ID_PARAM = "id";
    public static final String STATUS_PARAM = "status";
    public static final String STARTTIME_PARAM = "startTime";
    public static final String ENDTIME_PARAM = "endTime";
    public static final String UPDATETIME_PARAM = "updateTime";
    public static final String INNODES_PARAM = "inNodes";
    public static final String OUTNODES_PARAM = "outNodes";
    public static final String TYPE_PARAM = "type";
    public static final String OUTER_PARAM = "outer";
    public static final String CONDITION_PARAM = "condition";
    public static final String CONDITION_ON_JOB_STATUS_PARAM = "conditionOnJobStatus";
    public static final String PROPS_SOURCE_PARAM = "propSource";
    public static final String JOB_SOURCE_PARAM = "jobSource";
    public static final String OUTPUT_PROPS_PARAM = "outputProps";
    public static final String ATTEMPT_PARAM = "attempt";
    public static final String PASTATTEMPTS_PARAM = "pastAttempts";
    private final AtomicInteger attempt = new AtomicInteger(0);
    private String id;
    private String type = null;
    private String outer = null;
    private volatile Status status = Status.READY;
    private volatile long startTime = -1L;
    private volatile long endTime = -1L;
    private long updateTime = -1L;
    private volatile boolean killedBySLA = false;
    private String jobSource;
    private String propsSource;
    private Set<String> inNodes = new HashSet<String>();
    private Set<String> outNodes = new HashSet<String>();
    private Props inputProps;
    private Props outputProps;
    private long delayExecution = 0L;
    private ArrayList<ExecutionAttempt> pastAttempts = null;
    private String condition;
    private ConditionOnJobStatus conditionOnJobStatus = ConditionOnJobStatus.ALL_SUCCESS;
    private ExecutableFlowBase parentFlow;
    private boolean isDependentlinkFailed = false;

    public ExecutableNode(Node node) {
        this.id = node.getId();
        this.jobSource = node.getJobSource();
        this.propsSource = node.getPropsSource();
    }

    public ExecutableNode(Node node, ExecutableFlowBase parent) {
        this(node.getId(), node.getType(), node.getOuter(), node.getCondition(), node.getConditionOnJobStatus(), node.getJobSource(), node.getPropsSource(), parent);
    }

    public ExecutableNode(String id, String type, String outer, String condition, ConditionOnJobStatus conditionOnJobStatus, String jobSource, String propsSource, ExecutableFlowBase parent) {
        this.id = id;
        this.jobSource = jobSource;
        this.propsSource = propsSource;
        this.type = type;
        this.outer = outer;
        this.condition = condition;
        this.conditionOnJobStatus = conditionOnJobStatus;
        this.setParentFlow(parent);
    }

    public ExecutableNode() {
    }

    public ExecutableFlow getExecutableFlow() {
        if (this.parentFlow == null) {
            return null;
        }
        return this.parentFlow.getExecutableFlow();
    }

    public ExecutableFlowBase getParentFlow() {
        return this.parentFlow;
    }

    public void setParentFlow(ExecutableFlowBase flow) {
        this.parentFlow = flow;
    }

    public boolean isDependentlinkFailed() {
        return this.isDependentlinkFailed;
    }

    public void setDependentlinkFailed(boolean dependentlinkFailed) {
        this.isDependentlinkFailed = dependentlinkFailed;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOuter() {
        return this.outer;
    }

    public void setOuter(String outer) {
        this.outer = outer;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public boolean isKilledBySLA() {
        return this.killedBySLA;
    }

    public void setKilledBySLA(boolean killedBySLA) {
        this.killedBySLA = killedBySLA;
    }

    public void addOutNode(String exNode) {
        this.outNodes.add(exNode);
    }

    public void addInNode(String exNode) {
        this.inNodes.add(exNode);
    }

    public Set<String> getOutNodes() {
        return this.outNodes;
    }

    public Set<String> getInNodes() {
        return this.inNodes;
    }

    public boolean hasJobSource() {
        return this.jobSource != null;
    }

    public boolean hasPropsSource() {
        return this.propsSource != null;
    }

    public String getJobSource() {
        return this.jobSource;
    }

    public String getPropsSource() {
        return this.propsSource;
    }

    public Props getInputProps() {
        return this.inputProps;
    }

    public void setInputProps(Props input) {
        this.inputProps = input;
    }

    public Props getOutputProps() {
        return this.outputProps;
    }

    public void setOutputProps(Props output) {
        this.outputProps = output;
    }

    public long getDelayedExecution() {
        return this.delayExecution;
    }

    public void setDelayedExecution(long delayMs) {
        this.delayExecution = delayMs;
    }

    public List<ExecutionAttempt> getPastAttemptList() {
        return this.pastAttempts;
    }

    public int getAttempt() {
        return this.attempt.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetForRetry() {
        ExecutionAttempt pastAttempt = new ExecutionAttempt(this.attempt.get(), this);
        this.attempt.incrementAndGet();
        ExecutableNode executableNode = this;
        synchronized (executableNode) {
            if (this.pastAttempts == null) {
                this.pastAttempts = new ArrayList();
            }
            this.pastAttempts.add(pastAttempt);
        }
        this.setStartTime(-1L);
        this.setEndTime(-1L);
        this.setUpdateTime(System.currentTimeMillis());
        this.setStatus(Status.READY);
        this.setKilledBySLA(false);
    }

    public List<Object> getAttemptObjects() {
        ArrayList<Object> array = new ArrayList<Object>();
        for (ExecutionAttempt attempt : this.pastAttempts) {
            array.add(attempt.toObject());
        }
        return array;
    }

    public String getNestedId() {
        return this.getPrintableId(":");
    }

    public String getPrintableId(String delimiter) {
        if (this.getParentFlow() == null || this.getParentFlow() instanceof ExecutableFlow) {
            return this.getId();
        }
        return this.getParentFlow().getPrintableId(delimiter) + delimiter + this.getId();
    }

    public Map<String, Object> toObject() {
        HashMap<String, Object> mapObj = new HashMap<String, Object>();
        this.fillMapFromExecutable(mapObj);
        return mapObj;
    }

    protected void fillMapFromExecutable(Map<String, Object> objMap) {
        objMap.put(ID_PARAM, this.id);
        objMap.put(STATUS_PARAM, this.status.toString());
        objMap.put(STARTTIME_PARAM, this.startTime);
        objMap.put(ENDTIME_PARAM, this.endTime);
        objMap.put(UPDATETIME_PARAM, this.updateTime);
        objMap.put(TYPE_PARAM, this.type);
        objMap.put(OUTER_PARAM, this.outer);
        objMap.put(CONDITION_PARAM, this.condition);
        if (this.conditionOnJobStatus != null) {
            objMap.put(CONDITION_ON_JOB_STATUS_PARAM, this.conditionOnJobStatus.toString());
        }
        objMap.put(ATTEMPT_PARAM, this.attempt);
        if (this.inNodes != null && !this.inNodes.isEmpty()) {
            objMap.put(INNODES_PARAM, this.inNodes);
        }
        if (this.outNodes != null && !this.outNodes.isEmpty()) {
            objMap.put(OUTNODES_PARAM, this.outNodes);
        }
        if (this.hasPropsSource()) {
            objMap.put(PROPS_SOURCE_PARAM, this.propsSource);
        }
        if (this.hasJobSource()) {
            objMap.put(JOB_SOURCE_PARAM, this.jobSource);
        }
        if (this.outputProps != null && this.outputProps.size() > 0) {
            objMap.put(OUTPUT_PROPS_PARAM, PropsUtils.toStringMap((Props)this.outputProps, (boolean)true));
        }
        if (this.pastAttempts != null) {
            ArrayList<Map<String, Object>> attemptsList = new ArrayList<Map<String, Object>>(this.pastAttempts.size());
            for (ExecutionAttempt attempts : this.pastAttempts) {
                attemptsList.add(attempts.toObject());
            }
            objMap.put(PASTATTEMPTS_PARAM, attemptsList);
        }
    }

    public void fillExecutableFromMapObject(TypedMapWrapper<String, Object> wrappedMap) {
        Collection pastAttempts;
        this.id = wrappedMap.getString(ID_PARAM);
        this.type = wrappedMap.getString(TYPE_PARAM);
        this.outer = wrappedMap.getString(OUTER_PARAM);
        this.condition = wrappedMap.getString(CONDITION_PARAM);
        this.conditionOnJobStatus = ConditionOnJobStatus.fromString(wrappedMap.getString(CONDITION_ON_JOB_STATUS_PARAM));
        this.status = Status.valueOf(wrappedMap.getString(STATUS_PARAM));
        this.startTime = wrappedMap.getLong(STARTTIME_PARAM);
        this.endTime = wrappedMap.getLong(ENDTIME_PARAM);
        this.updateTime = wrappedMap.getLong(UPDATETIME_PARAM);
        this.attempt.set(wrappedMap.getInt(ATTEMPT_PARAM, 0));
        this.inNodes = new HashSet<String>();
        this.inNodes.addAll(wrappedMap.getStringCollection(INNODES_PARAM, Collections.emptySet()));
        this.outNodes = new HashSet<String>();
        this.outNodes.addAll(wrappedMap.getStringCollection(OUTNODES_PARAM, Collections.emptySet()));
        this.propsSource = wrappedMap.getString(PROPS_SOURCE_PARAM);
        this.jobSource = wrappedMap.getString(JOB_SOURCE_PARAM);
        Map outputProps = wrappedMap.getMap(OUTPUT_PROPS_PARAM);
        if (outputProps != null) {
            this.outputProps = new Props(null, new Map[]{outputProps});
        }
        if ((pastAttempts = wrappedMap.getCollection(PASTATTEMPTS_PARAM)) != null) {
            ArrayList<ExecutionAttempt> attempts = new ArrayList<ExecutionAttempt>();
            for (Object attemptObj : pastAttempts) {
                ExecutionAttempt attempt = ExecutionAttempt.fromObject(attemptObj);
                attempts.add(attempt);
            }
            this.pastAttempts = attempts;
        }
    }

    public void fillExecutableFromMapObject(Map<String, Object> objMap) {
        TypedMapWrapper<String, Object> wrapper = new TypedMapWrapper<String, Object>(objMap);
        this.fillExecutableFromMapObject(wrapper);
    }

    public Map<String, Object> toUpdateObject() {
        HashMap<String, Object> updatedNodeMap = new HashMap<String, Object>();
        updatedNodeMap.put(ID_PARAM, this.getId());
        updatedNodeMap.put(STATUS_PARAM, this.getStatus().getNumVal());
        updatedNodeMap.put(STARTTIME_PARAM, this.getStartTime());
        updatedNodeMap.put(ENDTIME_PARAM, this.getEndTime());
        updatedNodeMap.put(UPDATETIME_PARAM, this.getUpdateTime());
        updatedNodeMap.put(ATTEMPT_PARAM, this.getAttempt());
        if (this.getAttempt() > 0) {
            ArrayList<Map<String, Object>> pastAttempts = new ArrayList<Map<String, Object>>();
            for (ExecutionAttempt attempt : this.getPastAttemptList()) {
                pastAttempts.add(attempt.toObject());
            }
            updatedNodeMap.put(PASTATTEMPTS_PARAM, pastAttempts);
        }
        return updatedNodeMap;
    }

    public void applyUpdateObject(TypedMapWrapper<String, Object> updateData) {
        this.status = Status.fromInteger(updateData.getInt(STATUS_PARAM, this.status.getNumVal()));
        this.startTime = updateData.getLong(STARTTIME_PARAM);
        this.updateTime = updateData.getLong(UPDATETIME_PARAM);
        this.endTime = updateData.getLong(ENDTIME_PARAM);
        if (updateData.containsKey(ATTEMPT_PARAM)) {
            this.attempt.set(updateData.getInt(ATTEMPT_PARAM));
            if (this.attempt.get() > 0) {
                this.updatePastAttempts(updateData.getList(PASTATTEMPTS_PARAM, Collections.emptyList()));
            }
        }
    }

    public void applyUpdateObject(Map<String, Object> updateData) {
        TypedMapWrapper<String, Object> wrapper = new TypedMapWrapper<String, Object>(updateData);
        this.applyUpdateObject(wrapper);
    }

    public void cancelNode(long cancelTime) {
        if (this.status == Status.DISABLED) {
            this.skipNode(cancelTime);
        } else {
            this.setStatus(Status.CANCELLED);
            this.setStartTime(cancelTime);
            this.setEndTime(cancelTime);
            this.setUpdateTime(cancelTime);
        }
    }

    public void skipNode(long skipTime) {
        this.setStatus(Status.SKIPPED);
        this.setStartTime(skipTime);
        this.setEndTime(skipTime);
        this.setUpdateTime(skipTime);
    }

    public void faliedSkipedNode(long failedSkipedTime) {
        this.setStatus(Status.FAILED_SKIPPED);
        this.setStartTime(failedSkipedTime);
        this.setEndTime(failedSkipedTime);
        this.setUpdateTime(failedSkipedTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePastAttempts(List<Object> pastAttemptsList) {
        if (pastAttemptsList == null) {
            return;
        }
        ExecutableNode executableNode = this;
        synchronized (executableNode) {
            if (this.pastAttempts == null) {
                this.pastAttempts = new ArrayList();
            }
            if (pastAttemptsList.size() <= this.pastAttempts.size()) {
                return;
            }
            Object[] pastAttemptArray = pastAttemptsList.toArray();
            for (int i = this.pastAttempts.size(); i < pastAttemptArray.length; ++i) {
                ExecutionAttempt attempt = ExecutionAttempt.fromObject(pastAttemptArray[i]);
                this.pastAttempts.add(attempt);
            }
        }
    }

    public int getRetries() {
        return this.inputProps.getInt("retries", 0);
    }

    public long getRetryBackoff() {
        return this.inputProps.getLong("retry.backoff", 0L);
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public ConditionOnJobStatus getConditionOnJobStatus() {
        return this.conditionOnJobStatus == null ? ConditionOnJobStatus.ALL_SUCCESS : this.conditionOnJobStatus;
    }

    public void setConditionOnJobStatus(ConditionOnJobStatus conditionOnJobStatus) {
        this.conditionOnJobStatus = conditionOnJobStatus;
    }
}

