/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutionOptions;
import azkaban.executor.ExecutionReference;
import azkaban.utils.Pair;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutableFlowPriorityComparator
implements Comparator<Pair<ExecutionReference, ExecutableFlow>> {
    private static final Logger logger = LoggerFactory.getLogger(ExecutableFlowPriorityComparator.class);

    @Override
    public int compare(Pair<ExecutionReference, ExecutableFlow> pair1, Pair<ExecutionReference, ExecutableFlow> pair2) {
        ExecutableFlow exflow1 = null;
        ExecutableFlow exflow2 = null;
        if (pair1 != null && pair1.getSecond() != null) {
            exflow1 = pair1.getSecond();
        }
        if (pair2 != null && pair2.getSecond() != null) {
            exflow2 = pair2.getSecond();
        }
        if (exflow1 == null && exflow2 == null) {
            return 0;
        }
        if (exflow1 == null) {
            return -1;
        }
        if (exflow2 == null) {
            return 1;
        }
        int diff = this.getPriority(exflow2) - this.getPriority(exflow1);
        if (diff == 0) {
            diff = Long.compare(exflow1.getUpdateTime(), exflow2.getUpdateTime());
        }
        if (diff == 0) {
            diff = exflow1.getExecutionId() - exflow2.getExecutionId();
        }
        return diff;
    }

    private int getPriority(ExecutableFlow exflow) {
        ExecutionOptions options = exflow.getExecutionOptions();
        int priority = 5;
        if (options != null && options.getFlowParameters() != null && options.getFlowParameters().containsKey("flowPriority")) {
            try {
                priority = Integer.valueOf(options.getFlowParameters().get("flowPriority"));
            }
            catch (NumberFormatException ex) {
                priority = 5;
                logger.error("Failed to parse flow priority for exec_id = " + exflow.getExecutionId(), (Throwable)ex);
            }
        }
        return priority;
    }
}

