/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.executor.ExecutableFlowBase;
import azkaban.executor.ExecutionOptions;
import azkaban.executor.Status;
import azkaban.flow.Flow;
import azkaban.project.Project;
import azkaban.sla.SlaOption;
import azkaban.utils.TypedMapWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class ExecutableFlow
extends ExecutableFlowBase {
    public static final String EXECUTIONID_PARAM = "executionId";
    public static final String EXECUTIONPATH_PARAM = "executionPath";
    public static final String EXECUTIONOPTIONS_PARAM = "executionOptions";
    public static final String PROJECTID_PARAM = "projectId";
    public static final String SCHEDULEID_PARAM = "scheduleId";
    public static final String SUBMITUSER_PARAM = "submitUser";
    public static final String SUBMITTIME_PARAM = "submitTime";
    public static final String VERSION_PARAM = "version";
    public static final String PROXYUSERS_PARAM = "proxyUsers";
    public static final String PROJECTNAME_PARAM = "projectName";
    public static final String LASTMODIFIEDTIME_PARAM = "lastModfiedTime";
    public static final String LASTMODIFIEDUSER_PARAM = "lastModifiedUser";
    public static final String SLAOPTIONS_PARAM = "slaOptions";
    public static final String AZKABANFLOWVERSION_PARAM = "azkabanFlowVersion";
    public static final String REPEATOPTIONS_PARAM = "repeatOptions";
    public static final String CYCLEOPTIONS_PARAM = "cycleOptions";
    public static final String FLOWTYPE_PARAM = "flowType";
    public static final String OTHEROPTIONS_PARAM = "otherOptions";
    public static final String USERPROPS_PARAM = "userProps";
    public static final String FLOW_FAILED_RETRY_PARAM = "flowFailedRetry";
    public static final String EXECUTOR_IDS_PARAM = "executorIds";
    public static final String FLOW_FALIED_SKIPED_PARAM = "flowFailedSkiped";
    public static final String JOB_OUTPUT_GLOBAL_PARAM = "jobOutputGlobalParam";
    public static final String RUN_DATE_PARAM = "runDate";
    public static final String NS_WTSS_PARAM = "nsWtss";
    public static final String LAST_NS_WTSS_PARAM = "lastNsWtss";
    public static final String COMMENT_PARAM = "comment";
    public static final String REPEAT_ID_PARAM = "repeatId";
    private final HashSet<String> proxyUsers = new HashSet();
    private int executionId = -1;
    private int scheduleId = -1;
    private int projectId;
    private String projectName;
    private String lastModifiedUser;
    private int version;
    private long submitTime = -1L;
    private long lastModifiedTimestamp;
    private String submitUser;
    private String executionPath;
    private ExecutionOptions executionOptions;
    private List<SlaOption> slaOptions = new ArrayList<SlaOption>();
    private double azkabanFlowVersion;
    private Map<String, String> repeatOption = new HashMap<String, String>();
    private Map<String, String> cycleOption = new HashMap<String, String>();
    private int flowType = 0;
    private Map<String, Object> otherOption = new HashMap<String, Object>();
    private List<Integer> executorIds = new ArrayList<Integer>();
    private Map<String, String> userProps = new HashMap<String, String>();
    private Map<String, String> flowFailedRetry = new HashMap<String, String>();
    private boolean failedSkipedAllJobs = false;
    private ConcurrentHashMap<String, String> jobOutputGlobalParam = new ConcurrentHashMap();
    private String runDate;
    private boolean nsWtss = true;
    private boolean lastNsWtss = true;
    private String comment = "";
    private Integer repeatId;

    public ExecutableFlow(Project project, Flow flow) {
        this.projectId = project.getId();
        this.projectName = project.getName();
        this.version = project.getVersion();
        this.scheduleId = -1;
        this.lastModifiedTimestamp = project.getLastModifiedTimestamp();
        this.lastModifiedUser = project.getLastModifiedUser();
        this.setAzkabanFlowVersion(flow.getAzkabanFlowVersion());
        this.setFlow(project, flow);
    }

    public ExecutableFlow() {
    }

    public static ExecutableFlow createExecutableFlowFromObject(Object obj) {
        ExecutableFlow exFlow = new ExecutableFlow();
        HashMap flowObj = (HashMap)obj;
        exFlow.fillExecutableFromMapObject(flowObj);
        return exFlow;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public String getId() {
        return this.getFlowId();
    }

    @Override
    public ExecutableFlow getExecutableFlow() {
        return this;
    }

    public void addAllProxyUsers(Collection<String> proxyUsers) {
        this.proxyUsers.addAll(proxyUsers);
    }

    public Set<String> getProxyUsers() {
        return new HashSet<String>(this.proxyUsers);
    }

    public ExecutionOptions getExecutionOptions() {
        return this.executionOptions;
    }

    public boolean getLastNsWtss() {
        return this.lastNsWtss;
    }

    public void setLastNsWtss(boolean lastNsWtss) {
        this.lastNsWtss = lastNsWtss;
    }

    public boolean getNsWtss() {
        return this.nsWtss;
    }

    public void setNsWtss(boolean nsWtss) {
        this.nsWtss = nsWtss;
    }

    public String getRunDate() {
        return this.runDate;
    }

    public void setRunDate(String runDate) {
        this.runDate = runDate;
    }

    public void setExecutionOptions(ExecutionOptions options) {
        this.executionOptions = options;
    }

    public List<SlaOption> getSlaOptions() {
        return this.slaOptions;
    }

    public void setSlaOptions(List<SlaOption> slaOptions) {
        this.slaOptions = slaOptions;
    }

    public Integer getRepeatId() {
        return this.repeatId;
    }

    public void setRepeatId(Integer repeatId) {
        this.repeatId = repeatId;
    }

    @Override
    protected void setFlow(Project project, Flow flow) {
        super.setFlow(project, flow);
        this.executionOptions = new ExecutionOptions();
        this.executionOptions.setMailCreator(flow.getMailCreator());
        if (flow.getSuccessEmails() != null) {
            this.executionOptions.setSuccessEmails(flow.getSuccessEmails());
        }
        if (flow.getFailureEmails() != null) {
            this.executionOptions.setFailureEmails(flow.getFailureEmails());
        }
    }

    @Override
    public int getExecutionId() {
        return this.executionId;
    }

    public List<Integer> getExecutorIds() {
        return this.executorIds;
    }

    public void setExecutorIds(List<Integer> executorIds) {
        this.executorIds = executorIds;
    }

    public void setExecutionId(int executionId) {
        this.executionId = executionId;
    }

    @Override
    public long getLastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public void setLastModifiedTimestamp(long lastModifiedTimestamp) {
        this.lastModifiedTimestamp = lastModifiedTimestamp;
    }

    @Override
    public String getLastModifiedByUser() {
        return this.lastModifiedUser;
    }

    public void setLastModifiedByUser(String lastModifiedUser) {
        this.lastModifiedUser = lastModifiedUser;
    }

    @Override
    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    public int getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(int scheduleId) {
        this.scheduleId = scheduleId;
    }

    public String getExecutionPath() {
        return this.executionPath;
    }

    public void setExecutionPath(String executionPath) {
        this.executionPath = executionPath;
    }

    public String getSubmitUser() {
        return this.submitUser;
    }

    public void setSubmitUser(String submitUser) {
        this.submitUser = submitUser;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public long getSubmitTime() {
        return this.submitTime;
    }

    public void setSubmitTime(long submitTime) {
        this.submitTime = submitTime;
    }

    public double getAzkabanFlowVersion() {
        return this.azkabanFlowVersion;
    }

    public void setAzkabanFlowVersion(double azkabanFlowVersion) {
        this.azkabanFlowVersion = azkabanFlowVersion;
    }

    public Map<String, String> getRepeatOption() {
        return this.repeatOption;
    }

    public Map<String, String> getCycleOption() {
        return this.cycleOption;
    }

    public void setRepeatOption(Map<String, String> repeatOption) {
        this.repeatOption = repeatOption;
    }

    public void setCycleOption(Map<String, String> cycleOption) {
        this.cycleOption = cycleOption;
    }

    public int getFlowType() {
        return this.flowType;
    }

    public void setFlowType(int flowType) {
        this.flowType = flowType;
    }

    public Map<String, Object> getOtherOption() {
        return this.otherOption;
    }

    public void setOtherOption(Map<String, Object> otherOption) {
        this.otherOption = otherOption;
    }

    @Override
    public Map<String, Object> toObject() {
        HashMap<String, Object> flowObj = new HashMap<String, Object>();
        this.fillMapFromExecutable(flowObj);
        flowObj.put(EXECUTIONID_PARAM, this.executionId);
        flowObj.put(EXECUTIONPATH_PARAM, this.executionPath);
        flowObj.put(PROJECTID_PARAM, this.projectId);
        flowObj.put(PROJECTNAME_PARAM, this.projectName);
        if (this.scheduleId >= 0) {
            flowObj.put(SCHEDULEID_PARAM, this.scheduleId);
        }
        flowObj.put(SUBMITUSER_PARAM, this.submitUser);
        flowObj.put(VERSION_PARAM, this.version);
        flowObj.put(LASTMODIFIEDTIME_PARAM, this.lastModifiedTimestamp);
        flowObj.put(LASTMODIFIEDUSER_PARAM, this.lastModifiedUser);
        flowObj.put(AZKABANFLOWVERSION_PARAM, this.azkabanFlowVersion);
        flowObj.put(EXECUTIONOPTIONS_PARAM, this.executionOptions.toObject());
        ArrayList<String> proxyUserList = new ArrayList<String>(this.proxyUsers);
        flowObj.put(PROXYUSERS_PARAM, proxyUserList);
        flowObj.put(SUBMITTIME_PARAM, this.submitTime);
        ArrayList slaOptions = new ArrayList();
        this.getSlaOptions().stream().forEach(slaOption -> slaOptions.add(slaOption.toObject()));
        flowObj.put(SLAOPTIONS_PARAM, slaOptions);
        Map<String, String> repeatOption = this.getRepeatOption();
        flowObj.put(REPEATOPTIONS_PARAM, repeatOption);
        Map<String, String> cycleOptions = this.getCycleOption();
        flowObj.put(CYCLEOPTIONS_PARAM, cycleOptions);
        flowObj.put(FLOWTYPE_PARAM, this.flowType);
        Map<String, Object> otherOption = this.getOtherOption();
        flowObj.put(OTHEROPTIONS_PARAM, otherOption);
        Map<String, String> userProps = this.getUserProps();
        flowObj.put(USERPROPS_PARAM, userProps);
        Map<String, String> flowFailedRetry = this.getFlowFailedRetry();
        flowObj.put(FLOW_FAILED_RETRY_PARAM, flowFailedRetry);
        flowObj.put(FLOW_FALIED_SKIPED_PARAM, this.getFailedSkipedAllJobs());
        List<Integer> executorIds = this.getExecutorIds();
        flowObj.put(EXECUTOR_IDS_PARAM, executorIds);
        ConcurrentHashMap<String, String> jobOutputGlobalParam = this.getJobOutputGlobalParam();
        flowObj.put(JOB_OUTPUT_GLOBAL_PARAM, jobOutputGlobalParam);
        String runDate = this.getRunDate();
        if (runDate != null) {
            flowObj.put(RUN_DATE_PARAM, runDate);
        }
        flowObj.put(NS_WTSS_PARAM, this.getNsWtss());
        flowObj.put(LAST_NS_WTSS_PARAM, this.getLastNsWtss());
        flowObj.put(COMMENT_PARAM, this.getComment());
        flowObj.put(REPEAT_ID_PARAM, this.getRepeatId());
        return flowObj;
    }

    @Override
    public void fillExecutableFromMapObject(TypedMapWrapper<String, Object> flowObj) {
        super.fillExecutableFromMapObject(flowObj);
        this.executionId = flowObj.getInt(EXECUTIONID_PARAM);
        this.executionPath = flowObj.getString(EXECUTIONPATH_PARAM);
        this.projectId = flowObj.getInt(PROJECTID_PARAM);
        this.projectName = flowObj.getString(PROJECTNAME_PARAM);
        this.scheduleId = flowObj.getInt(SCHEDULEID_PARAM);
        this.submitUser = flowObj.getString(SUBMITUSER_PARAM);
        this.version = flowObj.getInt(VERSION_PARAM);
        this.lastModifiedTimestamp = flowObj.getLong(LASTMODIFIEDTIME_PARAM);
        this.lastModifiedUser = flowObj.getString(LASTMODIFIEDUSER_PARAM);
        this.submitTime = flowObj.getLong(SUBMITTIME_PARAM);
        this.azkabanFlowVersion = flowObj.getDouble(AZKABANFLOWVERSION_PARAM);
        this.executionOptions = flowObj.containsKey(EXECUTIONOPTIONS_PARAM) ? ExecutionOptions.createFromObject(flowObj.getObject(EXECUTIONOPTIONS_PARAM)) : ExecutionOptions.createFromObject(flowObj);
        if (flowObj.containsKey(PROXYUSERS_PARAM)) {
            List<String> proxyUserList = flowObj.getList(PROXYUSERS_PARAM);
            this.addAllProxyUsers(proxyUserList);
        }
        if (flowObj.containsKey(SLAOPTIONS_PARAM)) {
            List<SlaOption> slaOptions = flowObj.getList(SLAOPTIONS_PARAM).stream().map(SlaOption::fromObject).collect(Collectors.toList());
            this.setSlaOptions(slaOptions);
        }
        if (flowObj.containsKey(REPEATOPTIONS_PARAM)) {
            Map<String, String> repeatOption = flowObj.getMap(REPEATOPTIONS_PARAM);
            this.setRepeatOption(repeatOption);
        }
        if (flowObj.containsKey(CYCLEOPTIONS_PARAM)) {
            Map<String, String> cycleOption = flowObj.getMap(CYCLEOPTIONS_PARAM);
            this.setCycleOption(cycleOption);
        }
        this.setFlowType(flowObj.getInt(FLOWTYPE_PARAM));
        if (flowObj.containsKey(OTHEROPTIONS_PARAM)) {
            Map<String, Object> otherOptions = flowObj.getMap(OTHEROPTIONS_PARAM);
            this.setOtherOption(otherOptions);
        }
        if (flowObj.containsKey(USERPROPS_PARAM)) {
            Map<String, String> userProps = flowObj.getMap(USERPROPS_PARAM);
            this.setUserProps(userProps);
        }
        if (flowObj.containsKey(FLOW_FAILED_RETRY_PARAM)) {
            Map<String, String> flowFailedRetry = flowObj.getMap(FLOW_FAILED_RETRY_PARAM);
            this.setFlowFailedRetry(flowFailedRetry);
        }
        if (flowObj.containsKey(EXECUTOR_IDS_PARAM)) {
            ArrayList executorIds = (ArrayList)flowObj.getList(EXECUTOR_IDS_PARAM, new ArrayList());
            this.setExecutorIds(executorIds);
        }
        if (flowObj.containsKey(FLOW_FALIED_SKIPED_PARAM)) {
            boolean flowFailedSkipedAllJobs = flowObj.getBool(FLOW_FALIED_SKIPED_PARAM, false);
            this.setFailedSkipedAllJobs(flowFailedSkipedAllJobs);
        }
        if (flowObj.containsKey(JOB_OUTPUT_GLOBAL_PARAM)) {
            ConcurrentHashMap<String, String> jobOutputGlobalParam = new ConcurrentHashMap<String, String>(flowObj.getMap(JOB_OUTPUT_GLOBAL_PARAM));
            this.setJobOutputGlobalParam(jobOutputGlobalParam);
        }
        if (flowObj.containsKey(RUN_DATE_PARAM)) {
            this.setRunDate(flowObj.getString(RUN_DATE_PARAM));
        }
        this.setNsWtss(flowObj.getBool(NS_WTSS_PARAM, true));
        this.setLastNsWtss(flowObj.getBool(LAST_NS_WTSS_PARAM, true));
        this.setComment(flowObj.getString(COMMENT_PARAM, ""));
        this.setRepeatId(flowObj.getInt(REPEAT_ID_PARAM, null));
    }

    @Override
    public Map<String, Object> toUpdateObject(long lastUpdateTime) {
        Map<String, Object> updateData = super.toUpdateObject(lastUpdateTime);
        updateData.put(EXECUTIONID_PARAM, this.executionId);
        return updateData;
    }

    @Override
    public void resetForRetry() {
        super.resetForRetry();
        this.setStatus(Status.RUNNING);
    }

    public Map<String, String> getUserProps() {
        return this.userProps;
    }

    public void setUserProps(Map<String, String> userProps) {
        this.userProps = userProps;
    }

    public Map<String, String> getFlowFailedRetry() {
        return this.flowFailedRetry;
    }

    public void setFlowFailedRetry(Map<String, String> flowFailedRetry) {
        this.flowFailedRetry = flowFailedRetry;
    }

    public boolean getFailedSkipedAllJobs() {
        return this.failedSkipedAllJobs;
    }

    public void setFailedSkipedAllJobs(boolean failedSkipedAllJobs) {
        this.failedSkipedAllJobs = failedSkipedAllJobs;
    }

    public ConcurrentHashMap<String, String> getJobOutputGlobalParam() {
        return this.jobOutputGlobalParam;
    }

    public void setJobOutputGlobalParam(ConcurrentHashMap<String, String> jobOutputGlobalParam) {
        this.jobOutputGlobalParam = jobOutputGlobalParam;
    }

    public void addJobOutputGlobalParam(ConcurrentHashMap<String, String> jobOutputParam) {
        this.jobOutputGlobalParam.putAll(jobOutputParam);
    }
}

