/*
 * Decompiled with CFR 0.152.
 */
package azkaban.executor;

import azkaban.alert.Alerter;
import azkaban.utils.Emailer;
import azkaban.utils.FileIOUtils;
import azkaban.utils.Props;
import azkaban.utils.PropsUtils;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AlerterHolder {
    private static final Logger logger = LoggerFactory.getLogger(AlerterHolder.class);
    private Map<String, Alerter> alerters;
    private final ConcurrentHashMap<Integer, Boolean> flowAlerterFlag = new ConcurrentHashMap();

    @Inject
    public AlerterHolder(Props props, Emailer mailAlerter) {
        try {
            this.alerters = this.loadAlerters(props, mailAlerter);
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
            this.alerters = new HashMap<String, Alerter>();
        }
    }

    private Map<String, Alerter> loadAlerters(Props props, Emailer mailAlerter) {
        HashMap<String, Alerter> allAlerters = new HashMap<String, Alerter>();
        allAlerters.put("default", mailAlerter);
        String pluginDir = props.getString("alerter.plugin.dir", "plugins/alerter");
        allAlerters.putAll(this.loadPluginAlerters(pluginDir));
        return allAlerters;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Alerter> loadPluginAlerters(String pluginPath) {
        File alerterPluginPath = new File(pluginPath);
        if (!alerterPluginPath.exists()) {
            return Collections.emptyMap();
        }
        HashMap<String, Alerter> installedAlerterPlugins = new HashMap<String, Alerter>();
        ClassLoader parentLoader = this.getClass().getClassLoader();
        File[] pluginDirs = alerterPluginPath.listFiles();
        ArrayList<String> jarPaths = new ArrayList<String>();
        File[] fileArray = pluginDirs;
        int n = fileArray.length;
        int n2 = 0;
        while (true) {
            block22: {
                Props pluginProps;
                File propertiesDir;
                File pluginDir;
                block26: {
                    block24: {
                        File propertiesFile;
                        block25: {
                            block23: {
                                if (n2 >= n) {
                                    return installedAlerterPlugins;
                                }
                                pluginDir = fileArray[n2];
                                if (pluginDir.isDirectory()) break block23;
                                logger.error("The plugin path " + pluginDir + " is not a directory.");
                                break block22;
                            }
                            propertiesDir = new File(pluginDir, "conf");
                            pluginProps = null;
                            if (!propertiesDir.exists() || !propertiesDir.isDirectory()) break block24;
                            propertiesFile = new File(propertiesDir, "plugin.properties");
                            File propertiesOverrideFile = new File(propertiesDir, "override.properties");
                            if (!propertiesFile.exists()) break block25;
                            pluginProps = propertiesOverrideFile.exists() ? PropsUtils.loadProps(null, (File[])new File[]{propertiesFile, propertiesOverrideFile}) : PropsUtils.loadProps(null, (File[])new File[]{propertiesFile});
                            break block26;
                        }
                        logger.error("Plugin conf file " + propertiesFile + " not found.");
                        break block22;
                    }
                    logger.error("Plugin conf path " + propertiesDir + " not found.");
                    break block22;
                }
                String pluginName = pluginProps.getString("alerter.name");
                List extLibClasspath = pluginProps.getStringList("alerter.external.classpaths", (List)null);
                String pluginClass = pluginProps.getString("alerter.class");
                if (pluginClass == null) {
                    logger.error("Alerter class is not set.");
                } else {
                    logger.info("Plugin class " + pluginClass);
                }
                URLClassLoader urlClassLoader = null;
                File libDir = new File(pluginDir, "lib");
                if (!libDir.exists() || !libDir.isDirectory()) {
                    logger.error("Library path " + propertiesDir + " not found.");
                } else {
                    File[] files = libDir.listFiles();
                    ArrayList<URL> urls = new ArrayList<URL>();
                    for (int i = 0; i < files.length; ++i) {
                        try {
                            URL url = files[i].toURI().toURL();
                            urls.add(url);
                            continue;
                        }
                        catch (MalformedURLException e) {
                            logger.error("", (Throwable)e);
                        }
                    }
                    if (extLibClasspath != null) {
                        for (String extLib : extLibClasspath) {
                            try {
                                File file = new File(pluginDir, extLib);
                                URL url = file.toURI().toURL();
                                urls.add(url);
                            }
                            catch (MalformedURLException e) {
                                logger.error("", (Throwable)e);
                            }
                        }
                    }
                    urlClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), parentLoader);
                    Class<?> alerterClass = null;
                    try {
                        alerterClass = urlClassLoader.loadClass(pluginClass);
                    }
                    catch (ClassNotFoundException e) {
                        logger.error("Class " + pluginClass + " not found.");
                        break block22;
                    }
                    String source = FileIOUtils.getSourcePathFromClass(alerterClass);
                    logger.info("Source jar " + source);
                    jarPaths.add("jar:file:" + source);
                    Constructor<?> constructor = null;
                    try {
                        constructor = alerterClass.getConstructor(Props.class);
                    }
                    catch (NoSuchMethodException e) {
                        logger.error("Constructor not found in " + pluginClass);
                        break block22;
                    }
                    Object obj = null;
                    try {
                        obj = constructor.newInstance(pluginProps);
                    }
                    catch (Exception e) {
                        logger.error("", (Throwable)e);
                    }
                    if (!(obj instanceof Alerter)) {
                        logger.error("The object is not an Alerter");
                    } else {
                        Alerter plugin = obj;
                        installedAlerterPlugins.put(pluginName, plugin);
                    }
                }
            }
            ++n2;
        }
    }

    public Alerter get(String alerterType) {
        return this.alerters.get(alerterType);
    }

    public ConcurrentHashMap<Integer, Boolean> getFlowAlerterFlag() {
        return this.flowAlerterFlag;
    }
}

