/*
 * Decompiled with CFR 0.152.
 */
package azkaban.database;

import azkaban.database.AzkabanDataSource;
import azkaban.database.DataSourceUtils;
import azkaban.utils.FileIOUtils;
import azkaban.utils.Props;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class AzkabanDatabaseSetup {
    public static final String DATABASE_CHECK_VERSION = "database.check.version";
    public static final String DATABASE_AUTO_UPDATE_TABLES = "database.auto.update.tables";
    public static final String DATABASE_SQL_SCRIPT_DIR = "database.sql.scripts.dir";
    private static final Logger logger = LoggerFactory.getLogger(AzkabanDatabaseSetup.class);
    private static final String DEFAULT_SCRIPT_PATH = "sql";
    private static final String CREATE_SCRIPT_PREFIX = "create.";
    private static final String UPDATE_SCRIPT_PREFIX = "update.";
    private static final String SQL_SCRIPT_SUFFIX = ".sql";
    private static final String FETCH_PROPERTY_BY_TYPE = "SELECT name, value FROM properties WHERE type=?";
    private static final String INSERT_DB_PROPERTY = "INSERT INTO properties (name, type, value, modified_time) values (?,?,?,?)";
    private static final String UPDATE_DB_PROPERTY = "UPDATE properties SET value=?,modified_time=? WHERE name=? AND type=?";
    private final AzkabanDataSource dataSource;
    private Map<String, String> tables;
    private Map<String, String> installedVersions;
    private Set<String> missingTables;
    private Map<String, List<String>> upgradeList;
    private String version;
    private boolean needsUpdating;
    private String scriptPath = null;

    public AzkabanDatabaseSetup(Props props) {
        this(DataSourceUtils.getDataSource(props));
        this.scriptPath = props.getString(DATABASE_SQL_SCRIPT_DIR, DEFAULT_SCRIPT_PATH);
    }

    public AzkabanDatabaseSetup(AzkabanDataSource ds) {
        this.dataSource = ds;
        if (this.scriptPath == null) {
            this.scriptPath = DEFAULT_SCRIPT_PATH;
        }
    }

    public AzkabanDatabaseSetup(AzkabanDataSource ds, Props props) {
        this.dataSource = ds;
        this.scriptPath = props.getString(DATABASE_SQL_SCRIPT_DIR, DEFAULT_SCRIPT_PATH);
    }

    public void loadTableInfo() throws IOException, SQLException {
        this.tables = new HashMap<String, String>();
        this.installedVersions = new HashMap<String, String>();
        this.missingTables = new HashSet<String>();
        this.upgradeList = new HashMap<String, List<String>>();
        Props dbProps = this.loadDBProps();
        this.version = dbProps.getString("version");
        this.loadInstalledTables();
        this.loadTableVersion();
        this.findMissingTables();
        this.findOutOfDateTables();
        this.needsUpdating = !this.upgradeList.isEmpty() || !this.missingTables.isEmpty();
    }

    public boolean needsUpdating() {
        if (this.version == null) {
            throw new RuntimeException("Uninitialized. Call loadTableInfo first.");
        }
        return this.needsUpdating;
    }

    public void printUpgradePlan() {
        if (!this.tables.isEmpty()) {
            logger.info("The following are installed tables");
            for (Map.Entry<String, String> entry : this.tables.entrySet()) {
                logger.info(" " + entry.getKey() + " version:" + entry.getValue());
            }
        } else {
            logger.info("No installed tables found.");
        }
        if (!this.missingTables.isEmpty()) {
            logger.info("The following are missing tables that need to be installed");
            for (String string : this.missingTables) {
                logger.info(" " + string);
            }
        } else {
            logger.info("There are no missing tables.");
        }
        if (!this.upgradeList.isEmpty()) {
            logger.info("The following tables need to be updated.");
            for (Map.Entry entry : this.upgradeList.entrySet()) {
                String tableInfo = " " + (String)entry.getKey() + " versions:";
                for (String upVersion : (List)entry.getValue()) {
                    tableInfo = tableInfo + upVersion + ",";
                }
                logger.info(tableInfo);
            }
        } else {
            logger.info("No tables need to be updated.");
        }
    }

    public void updateDatabase(boolean createTable, boolean updateTable) throws SQLException, IOException {
        if (!this.needsUpdating()) {
            logger.info("Nothing to be done.");
            return;
        }
        if (createTable && !this.missingTables.isEmpty()) {
            this.createNewTables();
        }
        if (updateTable && !this.upgradeList.isEmpty()) {
            this.updateTables();
        }
    }

    private Props loadDBProps() throws IOException {
        File dbPropsFile = new File(this.scriptPath, "database.properties");
        if (!dbPropsFile.exists()) {
            throw new IOException("Cannot find 'database.properties' file in " + dbPropsFile.getAbsolutePath());
        }
        return new Props(null, dbPropsFile);
    }

    private void loadTableVersion() throws SQLException {
        logger.info("Searching for table versions in the properties table");
        if (this.tables.containsKey("properties")) {
            QueryRunner runner = new QueryRunner((DataSource)((Object)this.dataSource));
            Map map = (Map)runner.query(FETCH_PROPERTY_BY_TYPE, (ResultSetHandler)new PropertiesHandler(), new Object[]{DataSourceUtils.PropertyType.DB.getNumVal()});
            for (String key : map.keySet()) {
                String value = (String)map.get(key);
                if (!key.endsWith(".version")) continue;
                String tableName = key.substring(0, key.length() - ".version".length());
                this.installedVersions.put(tableName, value);
                if (!this.tables.containsKey(tableName)) continue;
                this.tables.put(tableName, value);
            }
        } else {
            logger.info("Properties table doesn't exist.");
        }
    }

    private void loadInstalledTables() throws SQLException {
        logger.info("Searching for installed tables");
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            ResultSet rs = conn.getMetaData().getTables(conn.getCatalog(), null, null, new String[]{"TABLE"});
            while (rs.next()) {
                this.tables.put(rs.getString("TABLE_NAME").toLowerCase(), "2.1");
            }
        }
        finally {
            DbUtils.commitAndCloseQuietly((Connection)conn);
        }
    }

    private void findMissingTables() {
        File directory = new File(this.scriptPath);
        File[] createScripts = directory.listFiles(new FileIOUtils.PrefixSuffixFileFilter(CREATE_SCRIPT_PREFIX, SQL_SCRIPT_SUFFIX));
        if (createScripts != null) {
            for (File script : createScripts) {
                String name = script.getName();
                String[] nameSplit = name.split("\\.");
                String tableName = nameSplit[1];
                if ("quartz-tables-all".equals(tableName) || this.tables.containsKey(tableName)) continue;
                this.missingTables.add(tableName);
            }
        }
    }

    private void findOutOfDateTables() {
        for (String key : this.tables.keySet()) {
            String version;
            List<String> upgradeVersions = this.findOutOfDateTable(key, version = this.tables.get(key));
            if (upgradeVersions == null || upgradeVersions.isEmpty()) continue;
            this.upgradeList.put(key, upgradeVersions);
        }
        for (String key : this.missingTables) {
            List<String> upgradeVersions = this.findOutOfDateTable(key, "");
            if (upgradeVersions == null || upgradeVersions.isEmpty()) continue;
            this.upgradeList.put(key, upgradeVersions);
        }
    }

    private List<String> findOutOfDateTable(String table, String currentVersion) {
        File directory = new File(this.scriptPath);
        ArrayList<String> versions = new ArrayList<String>();
        File[] createScripts = directory.listFiles(new FileIOUtils.PrefixSuffixFileFilter(UPDATE_SCRIPT_PREFIX + table, SQL_SCRIPT_SUFFIX));
        if (createScripts == null || createScripts.length == 0) {
            return null;
        }
        String updateFileNameVersion = UPDATE_SCRIPT_PREFIX + table + "." + currentVersion;
        for (File file : createScripts) {
            String fileName = file.getName();
            if (fileName.compareTo(updateFileNameVersion) <= 0) continue;
            String[] split = fileName.split("\\.");
            String updateScriptVersion = "";
            for (int i = 2; i < split.length - 1; ++i) {
                try {
                    Integer.parseInt(split[i]);
                    updateScriptVersion = updateScriptVersion + split[i] + ".";
                    continue;
                }
                catch (NumberFormatException e) {
                    break;
                }
            }
            if (!updateScriptVersion.endsWith(".") || (updateScriptVersion = updateScriptVersion.substring(0, updateScriptVersion.length() - 1)).compareTo(currentVersion) <= 0 || updateScriptVersion.compareTo(this.version) > 0) continue;
            versions.add(updateScriptVersion);
        }
        Collections.sort(versions);
        return versions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewTables() throws SQLException, IOException {
        conn.setAutoCommit(false);
        try (Connection conn = this.dataSource.getConnection();){
            if (this.missingTables.contains("properties")) {
                this.runTableScripts(conn, "properties", this.version, this.dataSource.getDBType(), false);
            }
            for (String table : this.missingTables) {
                if (table.equals("properties")) continue;
                this.runTableScripts(conn, table, this.version, this.dataSource.getDBType(), false);
                this.installedVersions.put(table, this.version);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTables() throws SQLException, IOException {
        conn.setAutoCommit(false);
        try (Connection conn = this.dataSource.getConnection();){
            if (this.upgradeList.containsKey("properties")) {
                for (String version : this.upgradeList.get("properties")) {
                    this.runTableScripts(conn, "properties", version, this.dataSource.getDBType(), true);
                }
            }
            for (String table : this.upgradeList.keySet()) {
                if (table.equals("properties")) continue;
                for (String version : this.upgradeList.get(table)) {
                    this.runTableScripts(conn, table, version, this.dataSource.getDBType(), true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTableScripts(Connection conn, String table, String version, String dbType, boolean update) throws IOException, SQLException {
        String dbScript;
        String scriptName = "";
        if (update) {
            scriptName = UPDATE_SCRIPT_PREFIX + table + "." + version;
            logger.info("Update table " + table + " to version " + version);
        } else {
            scriptName = CREATE_SCRIPT_PREFIX + table;
            logger.info("Creating new table " + table + " version " + version);
        }
        String dbSpecificScript = scriptName + "." + dbType + SQL_SCRIPT_SUFFIX;
        File script = new File(this.scriptPath, dbSpecificScript);
        if (!script.exists() && !(script = new File(this.scriptPath, dbScript = scriptName + SQL_SCRIPT_SUFFIX)).exists()) {
            throw new IOException("Creation files do not exist for table " + table);
        }
        BufferedInputStream buff = null;
        try {
            buff = new BufferedInputStream(new FileInputStream(script));
            String queryStr = IOUtils.toString((InputStream)buff);
            String[] splitQuery = queryStr.split(";\\s*\n");
            QueryRunner runner = new QueryRunner();
            for (String query : splitQuery) {
                runner.update(conn, query);
            }
            if (table.equals("properties")) {
                conn.commit();
            }
            String propertyName = table + ".version";
            if (!this.installedVersions.containsKey(table)) {
                runner.update(conn, INSERT_DB_PROPERTY, new Object[]{propertyName, DataSourceUtils.PropertyType.DB.getNumVal(), version, System.currentTimeMillis()});
            } else {
                runner.update(conn, UPDATE_DB_PROPERTY, new Object[]{version, System.currentTimeMillis(), propertyName, DataSourceUtils.PropertyType.DB.getNumVal()});
            }
            conn.commit();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(buff);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)buff);
    }

    public static class PropertiesHandler
    implements ResultSetHandler<Map<String, String>> {
        public Map<String, String> handle(ResultSet rs) throws SQLException {
            HashMap<String, String> results = new HashMap<String, String>();
            while (rs.next()) {
                String key = rs.getString(1);
                String value = rs.getString(2);
                results.put(key, value);
            }
            return results;
        }
    }
}

