/*
 * Decompiled with CFR 0.152.
 */
package parquet.bytes;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import parquet.Log;
import parquet.Preconditions;

public class CapacityByteArrayOutputStream
extends OutputStream {
    private static final Log LOG = Log.getLog(CapacityByteArrayOutputStream.class);
    private static final int MINIMUM_SLAB_SIZE = 65536;
    private static final int EXPONENTIAL_SLAB_SIZE_THRESHOLD = 10;
    private int slabSize;
    private List<byte[]> slabs = new ArrayList<byte[]>();
    private byte[] currentSlab;
    private int capacity;
    private int currentSlabIndex;
    private int currentSlabPosition;
    private int size;

    public CapacityByteArrayOutputStream(int initialSize) {
        Preconditions.checkArgument(initialSize > 0, "initialSize must be > 0");
        this.initSlabs(initialSize);
    }

    private void initSlabs(int initialSize) {
        if (Log.DEBUG) {
            LOG.debug(String.format("initial slab of size %d", initialSize));
        }
        this.slabSize = initialSize;
        this.slabs.clear();
        this.capacity = initialSize;
        this.currentSlab = new byte[this.slabSize];
        this.slabs.add(this.currentSlab);
        this.currentSlabIndex = 0;
        this.currentSlabPosition = 0;
        this.size = 0;
    }

    private void addSlab(int minimumSize) {
        ++this.currentSlabIndex;
        if (this.currentSlabIndex < this.slabs.size()) {
            this.currentSlab = this.slabs.get(this.currentSlabIndex);
            if (Log.DEBUG) {
                LOG.debug(String.format("reusing slab of size %d", this.currentSlab.length));
            }
            if (this.currentSlab.length < minimumSize) {
                if (Log.DEBUG) {
                    LOG.debug(String.format("slab size %,d too small for value of size %,d. replacing slab", this.currentSlab.length, minimumSize));
                }
                byte[] newSlab = new byte[minimumSize];
                this.capacity += minimumSize - this.currentSlab.length;
                this.currentSlab = newSlab;
                this.slabs.set(this.currentSlabIndex, newSlab);
            }
        } else {
            if (this.currentSlabIndex > 10) {
                this.slabSize = this.size;
                if (Log.DEBUG) {
                    LOG.debug(String.format("used %d slabs, new slab size %d", this.currentSlabIndex, this.slabSize));
                }
            }
            if (this.slabSize < minimumSize) {
                if (Log.DEBUG) {
                    LOG.debug(String.format("slab size %,d too small for value of size %,d. Bumping up slab size", this.slabSize, minimumSize));
                }
                this.slabSize = minimumSize;
            }
            if (Log.DEBUG) {
                LOG.debug(String.format("new slab of size %d", this.slabSize));
            }
            this.currentSlab = new byte[this.slabSize];
            this.slabs.add(this.currentSlab);
            this.capacity += this.slabSize;
        }
        this.currentSlabPosition = 0;
    }

    @Override
    public void write(int b) {
        if (this.currentSlabPosition == this.currentSlab.length) {
            this.addSlab(1);
        }
        this.currentSlab[this.currentSlabPosition] = (byte)b;
        ++this.currentSlabPosition;
        ++this.size;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.currentSlabPosition + len >= this.currentSlab.length) {
            int length1 = this.currentSlab.length - this.currentSlabPosition;
            System.arraycopy(b, off, this.currentSlab, this.currentSlabPosition, length1);
            int length2 = len - length1;
            this.addSlab(length2);
            System.arraycopy(b, off + length1, this.currentSlab, this.currentSlabPosition, length2);
            this.currentSlabPosition = length2;
        } else {
            System.arraycopy(b, off, this.currentSlab, this.currentSlabPosition, len);
            this.currentSlabPosition += len;
        }
        this.size += len;
    }

    public void writeTo(OutputStream out) throws IOException {
        for (int i = 0; i < this.currentSlabIndex; ++i) {
            byte[] slab = this.slabs.get(i);
            out.write(slab, 0, slab.length);
        }
        out.write(this.currentSlab, 0, this.currentSlabPosition);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void reset() {
        if (this.currentSlabIndex == 0 && this.currentSlabPosition < this.currentSlab.length / 2 && this.currentSlab.length > 65536 || this.currentSlabIndex > 10) {
            this.initSlabs(Math.max(this.size / 5, 65536));
            if (Log.DEBUG) {
                LOG.debug(String.format("used %d slabs, new slab size %d", this.currentSlabIndex + 1, this.slabSize));
            }
        } else if (this.currentSlabIndex < this.slabs.size() - 1) {
            this.slabs = new ArrayList<byte[]>(this.slabs.subList(0, this.currentSlabIndex + 1));
            this.capacity = 0;
            for (byte[] slab : this.slabs) {
                this.capacity += slab.length;
            }
        }
        this.currentSlabIndex = 0;
        this.currentSlabPosition = 0;
        this.currentSlab = this.slabs.get(this.currentSlabIndex);
        this.size = 0;
    }

    public long size() {
        return this.size;
    }

    public long getCurrentIndex() {
        Preconditions.checkArgument(this.size > 0, "This is an empty stream");
        return this.size - 1;
    }

    public void setByte(long index, byte value) {
        Preconditions.checkArgument(index < (long)this.size, "Index: " + index + " is >= the current size of: " + this.size);
        long seen = 0L;
        for (int i = 0; i <= this.currentSlabIndex; ++i) {
            byte[] slab = this.slabs.get(i);
            if (index < seen + (long)slab.length) {
                slab[(int)(index - seen)] = value;
                break;
            }
            seen += (long)slab.length;
        }
    }

    public String memUsageString(String prefix) {
        return String.format("%s %s %d slabs, %,d bytes", prefix, this.getClass().getSimpleName(), this.slabs.size(), this.getCapacity());
    }

    int getSlabCount() {
        return this.slabs.size();
    }
}

