/*
 * Decompiled with CFR 0.152.
 */
package org.csource.client;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.DownloadStream;
import org.csource.fastdfs.FileInfo;
import org.csource.fastdfs.StorageClient1;
import org.csource.fastdfs.UploadStream;
import org.csource.utils.CommonUtil;
import org.csource.utils.FdfsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FdfsClient {
    static Logger log = LoggerFactory.getLogger(FdfsClient.class);
    private static final String DEFAULT_CONFIG = "fdfs.properties";

    public FdfsClient() {
        try {
            ClientGlobal.initByProperties(DEFAULT_CONFIG);
            log.info("fdfs config:{}", (Object)ClientGlobal.configInfo());
        }
        catch (Exception e) {
            log.error("fastdfs \u521d\u59cb\u5316\u914d\u7f6e\u5931\u6557\uff0c\u8bf7\u68c0\u67e5fdfs.properties\u914d\u7f6e", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public FdfsClient(String config) {
        try {
            Properties properties = new Properties();
            properties.load(CommonUtil.loadFile(config));
            ClientGlobal.initByProperties(properties);
            log.info("fdfs config:{}", (Object)ClientGlobal.configInfo());
        }
        catch (Exception e) {
            log.error("fastdfs \u521d\u59cb\u5316\u914d\u7f6e\u5931\u6557\uff0c\u8bf7\u68c0\u67e5" + config + "\u914d\u7f6e", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public StorageClient1 getClient() throws Exception {
        return new StorageClient1();
    }

    public String upload(String group, InputStream input, String fileName) throws Exception {
        String fileExtName = FdfsUtil.getExtension(fileName);
        return this.getClient().upload_file1(group, input.available(), new UploadStream(input, input.available()), fileExtName, null);
    }

    public String uploadAppendFile(String group, InputStream input, String fileName) throws Exception {
        String fileExtName = FdfsUtil.getExtension(fileName);
        return this.getClient().upload_appender_file1(group, input.available(), new UploadStream(input, input.available()), fileExtName, null);
    }

    public void append(InputStream input, String fileId) throws Exception {
        this.getClient().append_file1(fileId, input.available(), new UploadStream(input, input.available()));
    }

    public void modifyFile(InputStream input, Long offset, String fileId) throws Exception {
        this.getClient().modify_file1(fileId, offset, input.available(), new UploadStream(input, input.available()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(String fileId, Long start, Long len, OutputStream out) throws Exception {
        try {
            this.getClient().download_file1(fileId, (long)start, (long)len, new DownloadStream(out));
        }
        finally {
            out.close();
        }
    }

    public String uploadSlave(String masterFileId, InputStream input, String filePrefixName, String fileName) throws Exception {
        String fileExtName = FdfsUtil.getExtension(fileName);
        return this.getClient().upload_file1(masterFileId, filePrefixName, input.available(), new UploadStream(input, input.available()), fileExtName, null);
    }

    public void download(String fileId, OutputStream out) throws Exception {
        try {
            this.getClient().download_file1(fileId, new DownloadStream(out));
        }
        finally {
            out.close();
        }
    }

    public int delete(String fileId) throws Exception {
        return this.getClient().delete_file1(fileId);
    }

    public FileInfo getFileInfo(String fileId) throws Exception {
        return this.getClient().get_file_info1(fileId);
    }
}

