/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.billing;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.billing.CreditBalanceTransaction;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.billing.CreditBalanceTransactionListParams;
import com.stripe.param.billing.CreditBalanceTransactionRetrieveParams;
import java.lang.reflect.Type;

public final class CreditBalanceTransactionService
extends ApiService {
    public CreditBalanceTransactionService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<CreditBalanceTransaction> list(CreditBalanceTransactionListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<CreditBalanceTransaction> list(CreditBalanceTransactionListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/credit_balance_transactions";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<CreditBalanceTransaction>>(){}.getType());
    }

    public CreditBalanceTransaction retrieve(String id, CreditBalanceTransactionRetrieveParams params) throws StripeException {
        return this.retrieve(id, params, null);
    }

    public CreditBalanceTransaction retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, null, options);
    }

    public CreditBalanceTransaction retrieve(String id) throws StripeException {
        return this.retrieve(id, null, null);
    }

    public CreditBalanceTransaction retrieve(String id, CreditBalanceTransactionRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/credit_balance_transactions/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (CreditBalanceTransaction)this.request(request, (Type)((Object)CreditBalanceTransaction.class));
    }
}

