/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.billing;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.Invoice;
import com.stripe.model.StripeObject;
import com.stripe.model.billing.CreditBalanceTransactionCollection;
import com.stripe.model.billing.CreditGrant;
import com.stripe.model.testhelpers.TestClock;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.billing.CreditBalanceTransactionListParams;
import com.stripe.param.billing.CreditBalanceTransactionRetrieveParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class CreditBalanceTransaction
extends ApiResource
implements HasId {
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="credit")
    Credit credit;
    @SerializedName(value="credit_grant")
    ExpandableField<CreditGrant> creditGrant;
    @SerializedName(value="debit")
    Debit debit;
    @SerializedName(value="effective_at")
    Long effectiveAt;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="test_clock")
    ExpandableField<TestClock> testClock;
    @SerializedName(value="type")
    String type;

    public String getCreditGrant() {
        return this.creditGrant != null ? this.creditGrant.getId() : null;
    }

    public void setCreditGrant(String id) {
        this.creditGrant = ApiResource.setExpandableFieldId(id, this.creditGrant);
    }

    public CreditGrant getCreditGrantObject() {
        return this.creditGrant != null ? this.creditGrant.getExpanded() : null;
    }

    public void setCreditGrantObject(CreditGrant expandableObject) {
        this.creditGrant = new ExpandableField<CreditGrant>(expandableObject.getId(), expandableObject);
    }

    public String getTestClock() {
        return this.testClock != null ? this.testClock.getId() : null;
    }

    public void setTestClock(String id) {
        this.testClock = ApiResource.setExpandableFieldId(id, this.testClock);
    }

    public TestClock getTestClockObject() {
        return this.testClock != null ? this.testClock.getExpanded() : null;
    }

    public void setTestClockObject(TestClock expandableObject) {
        this.testClock = new ExpandableField<TestClock>(expandableObject.getId(), expandableObject);
    }

    public static CreditBalanceTransactionCollection list(Map<String, Object> params) throws StripeException {
        return CreditBalanceTransaction.list(params, (RequestOptions)null);
    }

    public static CreditBalanceTransactionCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/credit_balance_transactions";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (CreditBalanceTransactionCollection)CreditBalanceTransaction.getGlobalResponseGetter().request(request, (Type)((Object)CreditBalanceTransactionCollection.class));
    }

    public static CreditBalanceTransactionCollection list(CreditBalanceTransactionListParams params) throws StripeException {
        return CreditBalanceTransaction.list(params, (RequestOptions)null);
    }

    public static CreditBalanceTransactionCollection list(CreditBalanceTransactionListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/credit_balance_transactions";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (CreditBalanceTransactionCollection)CreditBalanceTransaction.getGlobalResponseGetter().request(request, (Type)((Object)CreditBalanceTransactionCollection.class));
    }

    public static CreditBalanceTransaction retrieve(String id) throws StripeException {
        return CreditBalanceTransaction.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static CreditBalanceTransaction retrieve(String id, RequestOptions options) throws StripeException {
        return CreditBalanceTransaction.retrieve(id, (Map<String, Object>)null, options);
    }

    public static CreditBalanceTransaction retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/credit_balance_transactions/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (CreditBalanceTransaction)CreditBalanceTransaction.getGlobalResponseGetter().request(request, (Type)((Object)CreditBalanceTransaction.class));
    }

    public static CreditBalanceTransaction retrieve(String id, CreditBalanceTransactionRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/credit_balance_transactions/%s", ApiResource.urlEncodeId(id));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (CreditBalanceTransaction)CreditBalanceTransaction.getGlobalResponseGetter().request(request, (Type)((Object)CreditBalanceTransaction.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.credit, responseGetter);
        this.trySetResponseGetter(this.creditGrant, responseGetter);
        this.trySetResponseGetter(this.debit, responseGetter);
        this.trySetResponseGetter(this.testClock, responseGetter);
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Credit getCredit() {
        return this.credit;
    }

    @Generated
    public Debit getDebit() {
        return this.debit;
    }

    @Generated
    public Long getEffectiveAt() {
        return this.effectiveAt;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCredit(Credit credit) {
        this.credit = credit;
    }

    @Generated
    public void setDebit(Debit debit) {
        this.debit = debit;
    }

    @Generated
    public void setEffectiveAt(Long effectiveAt) {
        this.effectiveAt = effectiveAt;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreditBalanceTransaction)) {
            return false;
        }
        CreditBalanceTransaction other = (CreditBalanceTransaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$effectiveAt = this.getEffectiveAt();
        Long other$effectiveAt = other.getEffectiveAt();
        if (this$effectiveAt == null ? other$effectiveAt != null : !((Object)this$effectiveAt).equals(other$effectiveAt)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Credit this$credit = this.getCredit();
        Credit other$credit = other.getCredit();
        if (this$credit == null ? other$credit != null : !((Object)this$credit).equals(other$credit)) {
            return false;
        }
        String this$creditGrant = this.getCreditGrant();
        String other$creditGrant = other.getCreditGrant();
        if (this$creditGrant == null ? other$creditGrant != null : !this$creditGrant.equals(other$creditGrant)) {
            return false;
        }
        Debit this$debit = this.getDebit();
        Debit other$debit = other.getDebit();
        if (this$debit == null ? other$debit != null : !((Object)this$debit).equals(other$debit)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$testClock = this.getTestClock();
        String other$testClock = other.getTestClock();
        if (this$testClock == null ? other$testClock != null : !this$testClock.equals(other$testClock)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CreditBalanceTransaction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $effectiveAt = this.getEffectiveAt();
        result = result * 59 + ($effectiveAt == null ? 43 : ((Object)$effectiveAt).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Credit $credit = this.getCredit();
        result = result * 59 + ($credit == null ? 43 : ((Object)$credit).hashCode());
        String $creditGrant = this.getCreditGrant();
        result = result * 59 + ($creditGrant == null ? 43 : $creditGrant.hashCode());
        Debit $debit = this.getDebit();
        result = result * 59 + ($debit == null ? 43 : ((Object)$debit).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $testClock = this.getTestClock();
        result = result * 59 + ($testClock == null ? 43 : $testClock.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class Credit
    extends StripeObject {
        @SerializedName(value="amount")
        Amount amount;
        @SerializedName(value="credits_application_invoice_voided")
        CreditsApplicationInvoiceVoided creditsApplicationInvoiceVoided;
        @SerializedName(value="type")
        String type;

        @Generated
        public Amount getAmount() {
            return this.amount;
        }

        @Generated
        public CreditsApplicationInvoiceVoided getCreditsApplicationInvoiceVoided() {
            return this.creditsApplicationInvoiceVoided;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setAmount(Amount amount) {
            this.amount = amount;
        }

        @Generated
        public void setCreditsApplicationInvoiceVoided(CreditsApplicationInvoiceVoided creditsApplicationInvoiceVoided) {
            this.creditsApplicationInvoiceVoided = creditsApplicationInvoiceVoided;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Credit)) {
                return false;
            }
            Credit other = (Credit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Amount this$amount = this.getAmount();
            Amount other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            CreditsApplicationInvoiceVoided this$creditsApplicationInvoiceVoided = this.getCreditsApplicationInvoiceVoided();
            CreditsApplicationInvoiceVoided other$creditsApplicationInvoiceVoided = other.getCreditsApplicationInvoiceVoided();
            if (this$creditsApplicationInvoiceVoided == null ? other$creditsApplicationInvoiceVoided != null : !((Object)this$creditsApplicationInvoiceVoided).equals(other$creditsApplicationInvoiceVoided)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Credit;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Amount $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            CreditsApplicationInvoiceVoided $creditsApplicationInvoiceVoided = this.getCreditsApplicationInvoiceVoided();
            result = result * 59 + ($creditsApplicationInvoiceVoided == null ? 43 : ((Object)$creditsApplicationInvoiceVoided).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class Amount
        extends StripeObject {
            @SerializedName(value="monetary")
            Monetary monetary;
            @SerializedName(value="type")
            String type;

            @Generated
            public Monetary getMonetary() {
                return this.monetary;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setMonetary(Monetary monetary) {
                this.monetary = monetary;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Amount)) {
                    return false;
                }
                Amount other = (Amount)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Monetary this$monetary = this.getMonetary();
                Monetary other$monetary = other.getMonetary();
                if (this$monetary == null ? other$monetary != null : !((Object)this$monetary).equals(other$monetary)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Amount;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Monetary $monetary = this.getMonetary();
                result = result * 59 + ($monetary == null ? 43 : ((Object)$monetary).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Monetary
            extends StripeObject {
                @SerializedName(value="currency")
                String currency;
                @SerializedName(value="value")
                Long value;

                @Generated
                public String getCurrency() {
                    return this.currency;
                }

                @Generated
                public Long getValue() {
                    return this.value;
                }

                @Generated
                public void setCurrency(String currency) {
                    this.currency = currency;
                }

                @Generated
                public void setValue(Long value) {
                    this.value = value;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Monetary)) {
                        return false;
                    }
                    Monetary other = (Monetary)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$value = this.getValue();
                    Long other$value = other.getValue();
                    if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
                        return false;
                    }
                    String this$currency = this.getCurrency();
                    String other$currency = other.getCurrency();
                    return !(this$currency == null ? other$currency != null : !this$currency.equals(other$currency));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Monetary;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $value = this.getValue();
                    result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
                    String $currency = this.getCurrency();
                    result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
                    return result;
                }
            }
        }

        public static class CreditsApplicationInvoiceVoided
        extends StripeObject {
            @SerializedName(value="invoice")
            ExpandableField<Invoice> invoice;
            @SerializedName(value="invoice_line_item")
            String invoiceLineItem;

            public String getInvoice() {
                return this.invoice != null ? this.invoice.getId() : null;
            }

            public void setInvoice(String id) {
                this.invoice = ApiResource.setExpandableFieldId(id, this.invoice);
            }

            public Invoice getInvoiceObject() {
                return this.invoice != null ? this.invoice.getExpanded() : null;
            }

            public void setInvoiceObject(Invoice expandableObject) {
                this.invoice = new ExpandableField<Invoice>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public String getInvoiceLineItem() {
                return this.invoiceLineItem;
            }

            @Generated
            public void setInvoiceLineItem(String invoiceLineItem) {
                this.invoiceLineItem = invoiceLineItem;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CreditsApplicationInvoiceVoided)) {
                    return false;
                }
                CreditsApplicationInvoiceVoided other = (CreditsApplicationInvoiceVoided)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$invoice = this.getInvoice();
                String other$invoice = other.getInvoice();
                if (this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice)) {
                    return false;
                }
                String this$invoiceLineItem = this.getInvoiceLineItem();
                String other$invoiceLineItem = other.getInvoiceLineItem();
                return !(this$invoiceLineItem == null ? other$invoiceLineItem != null : !this$invoiceLineItem.equals(other$invoiceLineItem));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CreditsApplicationInvoiceVoided;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $invoice = this.getInvoice();
                result = result * 59 + ($invoice == null ? 43 : $invoice.hashCode());
                String $invoiceLineItem = this.getInvoiceLineItem();
                result = result * 59 + ($invoiceLineItem == null ? 43 : $invoiceLineItem.hashCode());
                return result;
            }
        }
    }

    public static class Debit
    extends StripeObject {
        @SerializedName(value="amount")
        Amount amount;
        @SerializedName(value="credits_applied")
        CreditsApplied creditsApplied;
        @SerializedName(value="type")
        String type;

        @Generated
        public Amount getAmount() {
            return this.amount;
        }

        @Generated
        public CreditsApplied getCreditsApplied() {
            return this.creditsApplied;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setAmount(Amount amount) {
            this.amount = amount;
        }

        @Generated
        public void setCreditsApplied(CreditsApplied creditsApplied) {
            this.creditsApplied = creditsApplied;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Debit)) {
                return false;
            }
            Debit other = (Debit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Amount this$amount = this.getAmount();
            Amount other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            CreditsApplied this$creditsApplied = this.getCreditsApplied();
            CreditsApplied other$creditsApplied = other.getCreditsApplied();
            if (this$creditsApplied == null ? other$creditsApplied != null : !((Object)this$creditsApplied).equals(other$creditsApplied)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Debit;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Amount $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            CreditsApplied $creditsApplied = this.getCreditsApplied();
            result = result * 59 + ($creditsApplied == null ? 43 : ((Object)$creditsApplied).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class Amount
        extends StripeObject {
            @SerializedName(value="monetary")
            Monetary monetary;
            @SerializedName(value="type")
            String type;

            @Generated
            public Monetary getMonetary() {
                return this.monetary;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setMonetary(Monetary monetary) {
                this.monetary = monetary;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Amount)) {
                    return false;
                }
                Amount other = (Amount)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Monetary this$monetary = this.getMonetary();
                Monetary other$monetary = other.getMonetary();
                if (this$monetary == null ? other$monetary != null : !((Object)this$monetary).equals(other$monetary)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Amount;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Monetary $monetary = this.getMonetary();
                result = result * 59 + ($monetary == null ? 43 : ((Object)$monetary).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Monetary
            extends StripeObject {
                @SerializedName(value="currency")
                String currency;
                @SerializedName(value="value")
                Long value;

                @Generated
                public String getCurrency() {
                    return this.currency;
                }

                @Generated
                public Long getValue() {
                    return this.value;
                }

                @Generated
                public void setCurrency(String currency) {
                    this.currency = currency;
                }

                @Generated
                public void setValue(Long value) {
                    this.value = value;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Monetary)) {
                        return false;
                    }
                    Monetary other = (Monetary)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$value = this.getValue();
                    Long other$value = other.getValue();
                    if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
                        return false;
                    }
                    String this$currency = this.getCurrency();
                    String other$currency = other.getCurrency();
                    return !(this$currency == null ? other$currency != null : !this$currency.equals(other$currency));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Monetary;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $value = this.getValue();
                    result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
                    String $currency = this.getCurrency();
                    result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
                    return result;
                }
            }
        }

        public static class CreditsApplied
        extends StripeObject {
            @SerializedName(value="invoice")
            ExpandableField<Invoice> invoice;
            @SerializedName(value="invoice_line_item")
            String invoiceLineItem;

            public String getInvoice() {
                return this.invoice != null ? this.invoice.getId() : null;
            }

            public void setInvoice(String id) {
                this.invoice = ApiResource.setExpandableFieldId(id, this.invoice);
            }

            public Invoice getInvoiceObject() {
                return this.invoice != null ? this.invoice.getExpanded() : null;
            }

            public void setInvoiceObject(Invoice expandableObject) {
                this.invoice = new ExpandableField<Invoice>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public String getInvoiceLineItem() {
                return this.invoiceLineItem;
            }

            @Generated
            public void setInvoiceLineItem(String invoiceLineItem) {
                this.invoiceLineItem = invoiceLineItem;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CreditsApplied)) {
                    return false;
                }
                CreditsApplied other = (CreditsApplied)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$invoice = this.getInvoice();
                String other$invoice = other.getInvoice();
                if (this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice)) {
                    return false;
                }
                String this$invoiceLineItem = this.getInvoiceLineItem();
                String other$invoiceLineItem = other.getInvoiceLineItem();
                return !(this$invoiceLineItem == null ? other$invoiceLineItem != null : !this$invoiceLineItem.equals(other$invoiceLineItem));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CreditsApplied;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $invoice = this.getInvoice();
                result = result * 59 + ($invoice == null ? 43 : $invoice.hashCode());
                String $invoiceLineItem = this.getInvoiceLineItem();
                result = result * 59 + ($invoiceLineItem == null ? 43 : $invoiceLineItem.hashCode());
                return result;
            }
        }
    }
}

