/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.fasterxml.jackson.databind.deser.std;

import com.signalfx.shaded.fasterxml.jackson.core.JsonParser;
import com.signalfx.shaded.fasterxml.jackson.core.JsonProcessingException;
import com.signalfx.shaded.fasterxml.jackson.core.JsonToken;
import com.signalfx.shaded.fasterxml.jackson.databind.DeserializationContext;
import com.signalfx.shaded.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.signalfx.shaded.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.signalfx.shaded.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;

@JacksonStdImpl
public class ClassDeserializer
extends StdScalarDeserializer<Class<?>> {
    private static final long serialVersionUID = 1L;
    public static final ClassDeserializer instance = new ClassDeserializer();

    public ClassDeserializer() {
        super(Class.class);
    }

    @Override
    public Class<?> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            try {
                return deserializationContext.findClass(string);
            }
            catch (Exception exception) {
                throw deserializationContext.instantiationException(this._valueClass, ClassUtil.getRootCause(exception));
            }
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }
}

