/*
 * Decompiled with CFR 0.152.
 */
package com.shazam.shazamcrest;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class FieldsIgnorer {
    public static final String MARKER = "!_TO_BE_SORTED_!";

    public static JsonElement findPaths(Gson gson, Object object, Set<String> pathsToFind) {
        JsonParser jsonParser = new JsonParser();
        JsonElement jsonElement = jsonParser.parse(gson.toJson(object));
        JsonElement filteredJson = FieldsIgnorer.findPaths(jsonElement, pathsToFind);
        if (object != null && (Set.class.isAssignableFrom(object.getClass()) || Map.class.isAssignableFrom(object.getClass()))) {
            return FieldsIgnorer.sortArray(filteredJson);
        }
        return filteredJson;
    }

    private static JsonElement findPaths(JsonElement jsonElement, Set<String> pathsToFind) {
        if (pathsToFind.isEmpty()) {
            return jsonElement;
        }
        String pathToFind = FieldsIgnorer.headOf(pathsToFind);
        List<String> pathSegments = Arrays.asList(pathToFind.split(Pattern.quote(".")));
        try {
            FieldsIgnorer.findPath(jsonElement, pathToFind, pathSegments);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(pathToFind + " does not exist");
        }
        return FieldsIgnorer.findPaths(jsonElement, FieldsIgnorer.removePathFromSet(pathsToFind, pathToFind));
    }

    private static Set<String> removePathFromSet(Set<String> setToRemoveFrom, String stringToRemove) {
        HashSet<String> set = new HashSet<String>(setToRemoveFrom);
        set.remove(stringToRemove);
        return set;
    }

    private static void findPath(JsonElement jsonElement, String pathToFind, List<String> pathSegments) {
        String field = FieldsIgnorer.headOf(pathSegments);
        if (jsonElement.isJsonArray()) {
            for (JsonElement arrayElement : jsonElement.getAsJsonArray()) {
                if (arrayElement.isJsonNull()) continue;
                FieldsIgnorer.findPath(arrayElement, pathToFind, pathSegments);
            }
        } else if (pathSegments.size() == 1) {
            FieldsIgnorer.ignorePath(jsonElement, pathToFind);
        } else {
            JsonElement child = jsonElement.getAsJsonObject().get(field);
            if (child == null) {
                child = jsonElement.getAsJsonObject().get(MARKER + field);
                if (child == null) {
                    return;
                }
                List<String> tail = pathSegments.subList(1, pathSegments.size());
                FieldsIgnorer.findPath(child, pathToFind, tail);
                child = FieldsIgnorer.sortArray(child);
                jsonElement.getAsJsonObject().add(MARKER + field, child);
            } else {
                List<String> tail = pathSegments.subList(1, pathSegments.size());
                FieldsIgnorer.findPath(child, pathToFind, tail);
            }
        }
    }

    private static JsonElement sortArray(JsonElement jsonElement) {
        TreeSet orderedSet = Sets.newTreeSet((Comparator)new Comparator<JsonElement>(){

            @Override
            public int compare(JsonElement o1, JsonElement o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        orderedSet.addAll(Lists.newArrayList((Iterator)jsonElement.getAsJsonArray().iterator()));
        JsonArray jsonArray = new JsonArray();
        for (JsonElement element : orderedSet) {
            jsonArray.add(element);
        }
        return jsonArray;
    }

    private static void ignorePath(JsonElement jsonElement, String pathToIgnore) {
        if (!jsonElement.isJsonNull()) {
            if (!jsonElement.isJsonObject()) {
                throw new IllegalArgumentException();
            }
            jsonElement.getAsJsonObject().remove(FieldsIgnorer.getLastSegmentOf(pathToIgnore));
            jsonElement.getAsJsonObject().remove(MARKER + FieldsIgnorer.getLastSegmentOf(pathToIgnore));
        }
    }

    private static String getLastSegmentOf(String fieldPath) {
        String[] paths = fieldPath.split(Pattern.quote("."));
        if (paths.length == 0) {
            return fieldPath;
        }
        return paths[Math.max(0, paths.length - 1)];
    }

    private static String headOf(Collection<String> paths) {
        return paths.iterator().next();
    }
}

