/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.qcloud.cos.utils.StringUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Objects;
import org.apache.hadoop.fs.CosNEncryptionMethods;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class CosNEncryptionSecrets
implements Writable,
Serializable {
    public static final int MAX_SECRET_LENGTH = 2048;
    private static final long serialVersionUID = 1208329045511296375L;
    private String encryptionAlgorithm = "";
    private String encryptionKey = "";
    private String encryptionContext = "";
    private transient CosNEncryptionMethods encryptionMethod = CosNEncryptionMethods.NONE;

    public CosNEncryptionSecrets() {
    }

    public CosNEncryptionSecrets(CosNEncryptionMethods encryptionAlgorithm, String encryptionKey) throws IOException {
        this(encryptionAlgorithm.getMethod(), encryptionKey);
    }

    public CosNEncryptionSecrets(CosNEncryptionMethods encryptionAlgorithm, String encryptionKey, String encryptionContext) throws IOException {
        this(encryptionAlgorithm.getMethod(), encryptionKey, encryptionContext);
    }

    public CosNEncryptionSecrets(String encryptionAlgorithm, String encryptionKey) throws IOException {
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.encryptionKey = encryptionKey;
        this.init();
    }

    public CosNEncryptionSecrets(String encryptionAlgorithm, String encryptionKey, String encryptionContext) throws IOException {
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.encryptionKey = encryptionKey;
        this.encryptionContext = encryptionContext;
        this.init();
    }

    public void write(DataOutput out) throws IOException {
        new LongWritable(1208329045511296375L).write(out);
        Text.writeString((DataOutput)out, (String)this.encryptionAlgorithm);
        Text.writeString((DataOutput)out, (String)this.encryptionKey);
    }

    public void readFields(DataInput in) throws IOException {
        LongWritable version = new LongWritable();
        version.readFields(in);
        if (version.get() != 1208329045511296375L) {
            throw new IOException("Incompatible EncryptionSecrets version");
        }
        this.encryptionAlgorithm = Text.readString((DataInput)in, (int)2048);
        this.encryptionKey = Text.readString((DataInput)in, (int)2048);
        this.init();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    private void init() throws IOException {
        this.encryptionMethod = CosNEncryptionMethods.getMethod(this.encryptionAlgorithm);
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public String getEncryptionContext() {
        return this.encryptionContext;
    }

    public boolean hasEncryptionAlgorithm() {
        return !StringUtils.isNullOrEmpty((String)this.encryptionAlgorithm);
    }

    public boolean hasEncryptionKey() {
        return !StringUtils.isNullOrEmpty((String)this.encryptionKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CosNEncryptionSecrets that = (CosNEncryptionSecrets)o;
        return Objects.equals(this.encryptionAlgorithm, that.encryptionAlgorithm) && Objects.equals(this.encryptionKey, that.encryptionKey);
    }

    public int hashCode() {
        return Objects.hash(this.encryptionAlgorithm, this.encryptionKey);
    }

    public CosNEncryptionMethods getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public String toString() {
        return CosNEncryptionMethods.NONE.equals((Object)this.encryptionMethod) ? "(no encryption)" : this.encryptionMethod.getMethod();
    }
}

