/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import org.apache.hadoop.fs.CosNCopyFileTask;
import org.apache.hadoop.fs.CosNDeleteFileContext;
import org.apache.hadoop.fs.NativeFileSystemStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosNDeleteFileTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(CosNCopyFileTask.class);
    private final NativeFileSystemStore store;
    private final String srcKey;
    private final CosNDeleteFileContext cosDeleteFileContext;

    public CosNDeleteFileTask(NativeFileSystemStore store, String srcKey, CosNDeleteFileContext cosDeleteFileContext) {
        this.store = store;
        this.srcKey = srcKey;
        this.cosDeleteFileContext = cosDeleteFileContext;
    }

    @Override
    public void run() {
        boolean fail = false;
        try {
            LOG.debug("Delete the cos key: {}.", (Object)this.srcKey);
            this.store.delete(this.srcKey);
        }
        catch (IOException e) {
            LOG.warn("Exception thrown when delete file [{}], exception: ", (Object)this.srcKey, (Object)e);
            fail = true;
            this.cosDeleteFileContext.setIOException(e);
        }
        finally {
            this.cosDeleteFileContext.lock();
            if (fail) {
                this.cosDeleteFileContext.setDeleteSuccess(false);
            }
            this.cosDeleteFileContext.incDeletesFinish();
            this.cosDeleteFileContext.signalAll();
            this.cosDeleteFileContext.unlock();
        }
    }
}

