/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.site;

import com.puppycrawl.tools.checkstyle.PropertyType;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.site.ModuleJavadocParsingUtil;
import com.puppycrawl.tools.checkstyle.site.SiteUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.doxia.macro.AbstractMacro;
import org.apache.maven.doxia.macro.Macro;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.module.xdoc.XdocSink;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=Macro.class, hint="properties")
public class PropertiesMacro
extends AbstractMacro {
    public static final String EMPTY = "empty";
    public static final Set<String> NON_BASE_TOKEN_PROPERTIES = Collections.unmodifiableSet(Arrays.stream(new String[]{"AtclauseOrder - target", "DescendantToken - limitedTokens", "IllegalType - memberModifiers", "MagicNumber - constantWaiverParentToken", "MultipleStringLiterals - ignoreOccurrenceContext"}).collect(Collectors.toSet()));
    private static final Pattern COMMA_SPACE_PATTERN = Pattern.compile(", ");
    private static final Pattern CHECK_PATTERN = Pattern.compile("Check$");
    private static final String CURLY_BRACKET = "{}";
    private static final String PROPERTY_TYPES_XML = "property_types.xml";
    private static final String URL_F = "%s#%s";
    private static final String CODE_START = "<code>";
    private static final String CODE_END = "</code>";
    private static final String TOKENS_PROPERTY = "tokens";
    private static String currentModuleName = "";
    private static Path currentModulePath = Paths.get("", new String[0]);

    public void execute(Sink sink, MacroRequest request) throws MacroExecutionException {
        if (!(sink instanceof XdocSink)) {
            throw new MacroExecutionException("Expected Sink to be an XdocSink.");
        }
        String modulePath = (String)request.getParameter("modulePath");
        PropertiesMacro.configureGlobalProperties(modulePath);
        PropertiesMacro.writePropertiesTable((XdocSink)sink);
    }

    private static void configureGlobalProperties(String modulePath) throws MacroExecutionException {
        Path modulePathObj;
        currentModulePath = modulePathObj = Paths.get(modulePath, new String[0]);
        Path fileNamePath = modulePathObj.getFileName();
        if (fileNamePath == null) {
            throw new MacroExecutionException("Invalid modulePath '" + modulePath + "': No file name present.");
        }
        currentModuleName = CommonUtil.getFileNameWithoutExtension(fileNamePath.toString());
    }

    private static void writePropertiesTable(XdocSink sink) throws MacroExecutionException {
        sink.table();
        sink.setInsertNewline(false);
        sink.tableRows(null, false);
        sink.rawText(ModuleJavadocParsingUtil.INDENT_LEVEL_12);
        PropertiesMacro.writeTableHeaderRow((Sink)sink);
        PropertiesMacro.writeTablePropertiesRows((Sink)sink);
        sink.rawText(ModuleJavadocParsingUtil.INDENT_LEVEL_10);
        sink.tableRows_();
        sink.table_();
        sink.setInsertNewline(true);
    }

    private static void writeTableHeaderRow(Sink sink) {
        sink.tableRow();
        PropertiesMacro.writeTableHeaderCell(sink, "name");
        PropertiesMacro.writeTableHeaderCell(sink, "description");
        PropertiesMacro.writeTableHeaderCell(sink, "type");
        PropertiesMacro.writeTableHeaderCell(sink, "default value");
        PropertiesMacro.writeTableHeaderCell(sink, "since");
        sink.rawText(ModuleJavadocParsingUtil.INDENT_LEVEL_12);
        sink.tableRow_();
    }

    private static void writeTableHeaderCell(Sink sink, String text) {
        sink.rawText(ModuleJavadocParsingUtil.INDENT_LEVEL_14);
        sink.tableHeaderCell();
        sink.text(text);
        sink.tableHeaderCell_();
    }

    private static void writeTablePropertiesRows(Sink sink) throws MacroExecutionException {
        Object instance = SiteUtil.getModuleInstance(currentModuleName);
        Class<?> clss = instance.getClass();
        Set<String> properties = SiteUtil.getPropertiesForDocumentation(clss, instance);
        Map<String, DetailNode> propertiesJavadocs = SiteUtil.getPropertiesJavadocs(properties, currentModuleName, currentModulePath);
        List<String> orderedProperties = PropertiesMacro.orderProperties(properties);
        for (String property : orderedProperties) {
            try {
                DetailNode propertyJavadoc = propertiesJavadocs.get(property);
                DetailNode currentModuleJavadoc = SiteUtil.getModuleJavadoc(currentModuleName, currentModulePath);
                PropertiesMacro.writePropertyRow(sink, property, propertyJavadoc, instance, currentModuleJavadoc);
            }
            catch (Exception exc) {
                String message = String.format(Locale.ROOT, "Exception while handling moduleName: %s propertyName: %s", currentModuleName, property);
                throw new MacroExecutionException(message, (Throwable)exc);
            }
        }
    }

    private static List<String> orderProperties(Set<String> properties) {
        LinkedList<String> orderProperties = new LinkedList<String>(properties);
        if (orderProperties.remove(TOKENS_PROPERTY)) {
            orderProperties.add(TOKENS_PROPERTY);
        }
        if (orderProperties.remove("javadocTokens")) {
            orderProperties.add("javadocTokens");
        }
        return List.copyOf(orderProperties);
    }

    private static void writePropertyRow(Sink sink, String propertyName, DetailNode propertyJavadoc, Object instance, DetailNode moduleJavadoc) throws MacroExecutionException {
        Field field = SiteUtil.getField(instance.getClass(), propertyName);
        sink.rawText(ModuleJavadocParsingUtil.INDENT_LEVEL_12);
        sink.tableRow();
        PropertiesMacro.writePropertyNameCell(sink, propertyName);
        PropertiesMacro.writePropertyDescriptionCell(sink, propertyName, propertyJavadoc);
        PropertiesMacro.writePropertyTypeCell(sink, propertyName, field, instance);
        PropertiesMacro.writePropertyDefaultValueCell(sink, propertyName, field, instance);
        PropertiesMacro.writePropertySinceVersionCell(sink, propertyName, moduleJavadoc, propertyJavadoc);
        sink.rawText(ModuleJavadocParsingUtil.INDENT_LEVEL_12);
        sink.tableRow_();
    }

    private static void writePropertyNameCell(Sink sink, String propertyName) {
        sink.rawText(ModuleJavadocParsingUtil.INDENT_LEVEL_14);
        sink.tableCell();
        sink.text(propertyName);
        sink.tableCell_();
    }

    private static void writePropertyDescriptionCell(Sink sink, String propertyName, DetailNode propertyJavadoc) throws MacroExecutionException {
        sink.rawText(ModuleJavadocParsingUtil.INDENT_LEVEL_14);
        sink.tableCell();
        String description = SiteUtil.getPropertyDescription(propertyName, propertyJavadoc, currentModuleName);
        sink.rawText(description);
        sink.tableCell_();
    }

    private static void writePropertyTypeCell(Sink sink, String propertyName, Field field, Object instance) throws MacroExecutionException {
        sink.rawText(ModuleJavadocParsingUtil.INDENT_LEVEL_14);
        sink.tableCell();
        if (TOKENS_PROPERTY.equals(propertyName)) {
            AbstractCheck check = (AbstractCheck)instance;
            if (check.getRequiredTokens().length == 0 && Arrays.equals(check.getAcceptableTokens(), TokenUtil.getAllTokenIds())) {
                sink.text("set of any supported");
                PropertiesMacro.writeLink(sink);
            } else {
                List<String> configurableTokens = SiteUtil.getDifference(check.getAcceptableTokens(), check.getRequiredTokens()).stream().map(TokenUtil::getTokenName).toList();
                sink.text("subset of tokens");
                PropertiesMacro.writeTokensList(sink, configurableTokens, "apidocs/com/puppycrawl/tools/checkstyle/api/TokenTypes.html", true);
            }
        } else if ("javadocTokens".equals(propertyName)) {
            AbstractJavadocCheck check = (AbstractJavadocCheck)instance;
            List<String> configurableTokens = SiteUtil.getDifference(check.getAcceptableJavadocTokens(), check.getRequiredJavadocTokens()).stream().map(JavadocUtil::getTokenName).toList();
            sink.text("subset of javadoc tokens");
            PropertiesMacro.writeTokensList(sink, configurableTokens, "apidocs/com/puppycrawl/tools/checkstyle/api/JavadocTokenTypes.html", true);
        } else {
            String type = SiteUtil.getType(field, propertyName, currentModuleName, instance);
            if (PropertyType.TOKEN_ARRAY.getDescription().equals(type)) {
                PropertiesMacro.processLinkForTokenTypes(sink);
            } else {
                String relativePathToPropertyTypes = SiteUtil.getLinkToDocument(currentModuleName, PROPERTY_TYPES_XML);
                String escapedType = type.replace("[", ".5B").replace("]", ".5D");
                String url = String.format(Locale.ROOT, URL_F, relativePathToPropertyTypes, escapedType);
                sink.link(url);
                sink.text(type);
                sink.link_();
            }
        }
        sink.tableCell_();
    }

    private static void processLinkForTokenTypes(Sink sink) throws MacroExecutionException {
        String link = SiteUtil.getLinkToDocument(currentModuleName, "apidocs/com/puppycrawl/tools/checkstyle/api/TokenTypes.html");
        sink.text("subset of tokens ");
        sink.link(link);
        sink.text("TokenTypes");
        sink.link_();
    }

    private static void writeLink(Sink sink) throws MacroExecutionException {
        sink.rawText(ModuleJavadocParsingUtil.INDENT_LEVEL_16);
        String link = SiteUtil.getLinkToDocument(currentModuleName, "apidocs/com/puppycrawl/tools/checkstyle/api/TokenTypes.html");
        sink.link(link);
        sink.rawText(ModuleJavadocParsingUtil.INDENT_LEVEL_20);
        sink.text(TOKENS_PROPERTY);
        sink.link_();
        sink.rawText(ModuleJavadocParsingUtil.INDENT_LEVEL_14);
    }

    private static void writeTokensList(Sink sink, List<String> tokens, String tokenTypesLink, boolean printDotAtTheEnd) throws MacroExecutionException {
        for (int index = 0; index < tokens.size(); ++index) {
            String token = tokens.get(index);
            sink.rawText(ModuleJavadocParsingUtil.INDENT_LEVEL_16);
            if (index != 0) {
                sink.text(", ");
            }
            PropertiesMacro.writeLinkToToken(sink, tokenTypesLink, token);
        }
        if (tokens.isEmpty()) {
            sink.rawText(CODE_START);
            sink.text(EMPTY);
            sink.rawText(CODE_END);
        } else if (printDotAtTheEnd) {
            sink.rawText(ModuleJavadocParsingUtil.INDENT_LEVEL_18);
            sink.text(".");
            sink.rawText(ModuleJavadocParsingUtil.INDENT_LEVEL_14);
        } else {
            sink.rawText(ModuleJavadocParsingUtil.INDENT_LEVEL_14);
        }
    }

    private static void writeLinkToToken(Sink sink, String document, String tokenName) throws MacroExecutionException {
        String link = SiteUtil.getLinkToDocument(currentModuleName, document) + "#" + tokenName;
        sink.link(link);
        sink.rawText(ModuleJavadocParsingUtil.INDENT_LEVEL_20);
        sink.text(tokenName);
        sink.link_();
    }

    private static void writePropertyDefaultValueCell(Sink sink, String propertyName, Field field, Object instance) throws MacroExecutionException {
        sink.rawText(ModuleJavadocParsingUtil.INDENT_LEVEL_14);
        sink.tableCell();
        if (TOKENS_PROPERTY.equals(propertyName)) {
            AbstractCheck check = (AbstractCheck)instance;
            if (check.getRequiredTokens().length == 0 && Arrays.equals(check.getDefaultTokens(), TokenUtil.getAllTokenIds())) {
                sink.text("TokenTypes");
            } else {
                List<String> configurableTokens = SiteUtil.getDifference(check.getDefaultTokens(), check.getRequiredTokens()).stream().map(TokenUtil::getTokenName).toList();
                PropertiesMacro.writeTokensList(sink, configurableTokens, "apidocs/com/puppycrawl/tools/checkstyle/api/TokenTypes.html", true);
            }
        } else if ("javadocTokens".equals(propertyName)) {
            AbstractJavadocCheck check = (AbstractJavadocCheck)instance;
            List<String> configurableTokens = SiteUtil.getDifference(check.getDefaultJavadocTokens(), check.getRequiredJavadocTokens()).stream().map(JavadocUtil::getTokenName).toList();
            PropertiesMacro.writeTokensList(sink, configurableTokens, "apidocs/com/puppycrawl/tools/checkstyle/api/JavadocTokenTypes.html", true);
        } else {
            String defaultValue = PropertiesMacro.getDefaultValue(propertyName, field, instance);
            String checkName = CHECK_PATTERN.matcher(instance.getClass().getSimpleName()).replaceAll("");
            boolean isSpecialTokenProp = NON_BASE_TOKEN_PROPERTIES.stream().anyMatch(tokenProp -> tokenProp.equals(checkName + " - " + propertyName));
            if (isSpecialTokenProp && !CURLY_BRACKET.equals(defaultValue)) {
                List<String> defaultValuesList = Arrays.asList(COMMA_SPACE_PATTERN.split(defaultValue));
                PropertiesMacro.writeTokensList(sink, defaultValuesList, "apidocs/com/puppycrawl/tools/checkstyle/api/TokenTypes.html", false);
            } else {
                sink.rawText(CODE_START);
                sink.text(defaultValue);
                sink.rawText(CODE_END);
            }
        }
        sink.tableCell_();
    }

    private static String getDefaultValue(String propertyName, Field field, Object instance) throws MacroExecutionException {
        Class<?> fieldClass;
        String result = field != null ? SiteUtil.getDefaultValue(propertyName, field, instance, currentModuleName) : ((fieldClass = SiteUtil.getPropertyClass(propertyName, instance)).isArray() ? CURLY_BRACKET : "null");
        return result;
    }

    private static void writePropertySinceVersionCell(Sink sink, String propertyName, DetailNode moduleJavadoc, DetailNode propertyJavadoc) throws MacroExecutionException {
        sink.rawText(ModuleJavadocParsingUtil.INDENT_LEVEL_14);
        sink.tableCell();
        String sinceVersion = SiteUtil.getPropertySinceVersion(currentModuleName, moduleJavadoc, propertyName, propertyJavadoc);
        sink.text(sinceVersion);
        sink.tableCell_();
    }
}

