/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.OsSpecificUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;

public final class PropertyCacheFile {
    public static final String CONFIG_HASH_KEY = "configuration*?";
    public static final String EXTERNAL_RESOURCE_KEY_PREFIX = "module-resource*?:";
    private static final int BUFFER_SIZE = 1024;
    private static final byte[] BUFFER = new byte[1024];
    private static final int BASE_16 = 16;
    private final Properties details = new Properties();
    private final Configuration config;
    private final String fileName;
    private String configHash;

    public PropertyCacheFile(Configuration config, String fileName) {
        if (config == null) {
            throw new IllegalArgumentException("config can not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("fileName can not be null");
        }
        this.config = config;
        this.fileName = fileName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load() throws IOException {
        this.configHash = PropertyCacheFile.getHashCodeBasedOnObjectContent(this.config);
        Path path = Path.of(this.fileName, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try (InputStream inStream = Files.newInputStream(path, new OpenOption[0]);){
                this.details.load(inStream);
                String cachedConfigHash = this.details.getProperty(CONFIG_HASH_KEY);
                if (this.configHash.equals(cachedConfigHash)) return;
                this.reset();
                return;
            }
        } else {
            this.reset();
        }
    }

    public void persist() throws IOException {
        Path path = Path.of(this.fileName, new String[0]);
        Path directory = path.getParent();
        if (directory != null) {
            OsSpecificUtil.updateDirectory(directory);
        }
        try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
            this.details.store(out, null);
        }
    }

    public void reset() {
        this.details.clear();
        this.details.setProperty(CONFIG_HASH_KEY, this.configHash);
    }

    public boolean isInCache(String uncheckedFileName, long timestamp) {
        String lastChecked = this.details.getProperty(uncheckedFileName);
        return Objects.equals(lastChecked, Long.toString(timestamp));
    }

    public void put(String checkedFileName, long timestamp) {
        this.details.setProperty(checkedFileName, Long.toString(timestamp));
    }

    public String get(String name) {
        return this.details.getProperty(name);
    }

    public void remove(String checkedFileName) {
        this.details.remove(checkedFileName);
    }

    private static String getHashCodeBasedOnObjectContent(Serializable object) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            PropertyCacheFile.serialize(object, outputStream);
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(outputStream.toByteArray());
            return new BigInteger(1, digest.digest()).toString(16).toUpperCase(Locale.ROOT);
        }
        catch (IOException | NoSuchAlgorithmException exc) {
            throw new IllegalStateException("Unable to calculate hashcode.", exc);
        }
    }

    private static void serialize(Serializable object, OutputStream outputStream) throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(outputStream);){
            oos.writeObject(object);
        }
    }

    public void putExternalResources(Set<String> locations) {
        Set<ExternalResource> resources = PropertyCacheFile.loadExternalResources(locations);
        if (this.areExternalResourcesChanged(resources)) {
            this.reset();
            this.fillCacheWithExternalResources(resources);
        }
    }

    private static Set<ExternalResource> loadExternalResources(Set<String> resourceLocations) {
        HashSet<ExternalResource> resources = new HashSet<ExternalResource>();
        for (String location : resourceLocations) {
            String contentHashSum;
            try {
                byte[] content = PropertyCacheFile.loadExternalResource(location);
                contentHashSum = PropertyCacheFile.getHashCodeBasedOnObjectContent((Serializable)content);
                resources.add(new ExternalResource(EXTERNAL_RESOURCE_KEY_PREFIX + location, contentHashSum));
            }
            catch (CheckstyleException | IOException exc) {
                contentHashSum = PropertyCacheFile.getHashCodeBasedOnObjectContent(exc);
                resources.add(new ExternalResource(EXTERNAL_RESOURCE_KEY_PREFIX + location, contentHashSum));
            }
        }
        return resources;
    }

    private static byte[] loadExternalResource(String location) throws IOException, CheckstyleException {
        URI uri = CommonUtil.getUriByFilename(location);
        try (InputStream is = uri.toURL().openStream();){
            byte[] byArray = PropertyCacheFile.toByteArray(is);
            return byArray;
        }
    }

    private static byte[] toByteArray(InputStream stream) throws IOException {
        int size;
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        while ((size = stream.read(BUFFER)) != -1) {
            content.write(BUFFER, 0, size);
        }
        return content.toByteArray();
    }

    private boolean areExternalResourcesChanged(Set<ExternalResource> resources) {
        return resources.stream().anyMatch(this::isResourceChanged);
    }

    private boolean isResourceChanged(ExternalResource resource) {
        boolean changed = false;
        if (this.isResourceLocationInCache(resource.location)) {
            String contentHashSum = resource.contentHashSum;
            String cachedHashSum = this.details.getProperty(resource.location);
            if (!cachedHashSum.equals(contentHashSum)) {
                changed = true;
            }
        } else {
            changed = true;
        }
        return changed;
    }

    private void fillCacheWithExternalResources(Set<ExternalResource> externalResources) {
        externalResources.forEach(resource -> this.details.setProperty(resource.location, resource.contentHashSum));
    }

    private boolean isResourceLocationInCache(String location) {
        String cachedHashSum = this.details.getProperty(location);
        return cachedHashSum != null;
    }

    private static final class ExternalResource {
        private final String location;
        private final String contentHashSum;

        private ExternalResource(String location, String contentHashSum) {
            this.location = location;
            this.contentHashSum = contentHashSum;
        }
    }
}

