/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.common.spring;

import com.playtika.testcontainer.common.properties.TestcontainersProperties;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.testcontainers.containers.GenericContainer;

public final class AllContainers
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(AllContainers.class);
    private final List<GenericContainer> genericContainers;
    private final TestcontainersProperties testcontainersProperties;

    public AllContainers(List<GenericContainer> genericContainers, TestcontainersProperties testcontainersProperties) {
        this.genericContainers = genericContainers;
        this.testcontainersProperties = testcontainersProperties;
    }

    public void destroy() {
        if (this.testcontainersProperties.isForceShutdown()) {
            this.genericContainers.parallelStream().forEach(GenericContainer::stop);
        }
    }

    public List<GenericContainer> getGenericContainers() {
        return this.genericContainers;
    }

    public TestcontainersProperties getTestcontainersProperties() {
        return this.testcontainersProperties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AllContainers)) {
            return false;
        }
        AllContainers other = (AllContainers)o;
        List<GenericContainer> this$genericContainers = this.getGenericContainers();
        List<GenericContainer> other$genericContainers = other.getGenericContainers();
        if (this$genericContainers == null ? other$genericContainers != null : !((Object)this$genericContainers).equals(other$genericContainers)) {
            return false;
        }
        TestcontainersProperties this$testcontainersProperties = this.getTestcontainersProperties();
        TestcontainersProperties other$testcontainersProperties = other.getTestcontainersProperties();
        return !(this$testcontainersProperties == null ? other$testcontainersProperties != null : !((Object)this$testcontainersProperties).equals(other$testcontainersProperties));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<GenericContainer> $genericContainers = this.getGenericContainers();
        result = result * 59 + ($genericContainers == null ? 43 : ((Object)$genericContainers).hashCode());
        TestcontainersProperties $testcontainersProperties = this.getTestcontainersProperties();
        result = result * 59 + ($testcontainersProperties == null ? 43 : ((Object)$testcontainersProperties).hashCode());
        return result;
    }

    public String toString() {
        return "AllContainers(genericContainers=" + this.getGenericContainers() + ", testcontainersProperties=" + this.getTestcontainersProperties() + ")";
    }
}

